/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetgraphics.view.phetcomponents;

import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PJCFocusManager;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetJComponentManager;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphics2D;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.RepaintManager;

public class PhetJComponent
extends PhetGraphic {
    private static boolean inited = false;
    private static JPanel offscreenContentPane = new JPanel(null){

        public void invalidate() {
        }

        protected void paintComponent(Graphics graphics) {
        }
    };
    private JComponent component;
    private boolean topLevel;
    private BufferedImage image;
    private static PhetJComponentRepaintManager repaintManagerPhet = new PhetJComponentRepaintManager();
    private static PhetJComponentManager manager = new PhetJComponentManager();

    public static PhetJComponentRepaintManager getRepaintManager() {
        return repaintManagerPhet;
    }

    public static PhetJComponentManager getManager() {
        return manager;
    }

    private void redraw() {
        Graphics2D graphics2D;
        Dimension dimension = this.component.getPreferredSize();
        if (!this.topLevel) {
            dimension = this.component.getSize();
        }
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        Rectangle rectangle = this.component.getBounds();
        if (!rectangle.equals(new Rectangle(dimension))) {
            this.component.setBounds(0, 0, dimension.width, dimension.height);
        }
        if (this.image == null) {
            this.image = new BufferedImage(dimension.width, dimension.height, 2);
        } else if (this.image.getWidth() != dimension.width || this.image.getHeight() != dimension.height) {
            this.image = new BufferedImage(dimension.width, dimension.height, 2);
        } else {
            graphics2D = this.image.createGraphics();
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.setColor(this.component.getBackground());
            graphics2D.fill(new Rectangle(0, 0, this.image.getWidth(), this.image.getHeight()));
            graphics2D.setComposite(composite);
        }
        graphics2D = this.image.createGraphics();
        graphics2D = new PhetGraphics2D(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.component.paint(graphics2D);
        this.setBoundsDirty();
    }

    protected Rectangle determineBounds() {
        if (this.image == null) {
            return null;
        }
        return this.getNetTransform().createTransformedShape(new Rectangle(0, 0, this.image.getWidth(), this.image.getHeight())).getBounds();
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible()) {
            super.saveGraphicsState(graphics2D);
            RenderingHints renderingHints = super.getRenderingHints();
            if (renderingHints != null) {
                graphics2D.setRenderingHints(renderingHints);
            }
            if (this.component != null && this.image != null) {
                graphics2D.transform(this.getNetTransform());
                Object object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics2D.drawRenderedImage(this.image, new AffineTransform());
                if (object == null) {
                    object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                }
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            }
            super.restoreGraphicsState();
        }
    }

    public void repaint() {
        this.redraw();
        super.repaint();
    }

    public JComponent getSourceComponent() {
        return this.component;
    }

    static {
        PhetJComponent.getManager().addListener(new PJCFocusManager());
    }

    public static class PhetJComponentRepaintManager
    extends RepaintManager {
        private Hashtable table = new Hashtable();
        private Set dirty = new HashSet();
        private boolean tooManyDirty = false;

        public synchronized void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
            super.addDirtyRegion(jComponent, n, n2, n3, n4);
            if (this.table.containsKey(jComponent)) {
                boolean bl;
                PhetJComponent phetJComponent = (PhetJComponent)this.table.get(jComponent);
                boolean bl2 = bl = new Exception().getStackTrace().length > 75;
                if (jComponent.getComponentCount() == 0 && !bl && !this.dirty.contains(jComponent)) {
                    this.dirty.add(phetJComponent);
                    if (this.dirty.size() > 1000 && !this.tooManyDirty) {
                        new RuntimeException("Too many dirty components: " + this.dirty.size()).printStackTrace();
                        this.tooManyDirty = true;
                    }
                }
            }
        }

        public void updateGraphics() {
            Iterator iterator = this.dirty.iterator();
            while (iterator.hasNext()) {
                PhetJComponent phetJComponent = (PhetJComponent)iterator.next();
                phetJComponent.repaint();
            }
            this.dirty.clear();
        }
    }
}

