/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.ModuleEvent;
import edu.colorado.phet.common.phetcommon.application.ModuleObserver;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.SessionCounter;
import edu.colorado.phet.common.phetcommon.preferences.PhetPreferences;
import edu.colorado.phet.common.phetcommon.view.ITabbedModulePane;
import edu.colorado.phet.common.phetcommon.view.ModulePanel;
import edu.colorado.phet.common.phetcommon.view.PhetExit;
import edu.colorado.phet.common.phetcommon.view.menu.HelpMenu;
import edu.colorado.phet.common.phetcommon.view.menu.PhetFileMenu;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class PhetFrame
extends JFrame {
    private HelpMenu helpMenu;
    private JMenu defaultFileMenu;
    private PhetApplication application;
    private Container contentPanel;
    private Module lastAdded;

    public PhetFrame(final PhetApplication phetApplication) throws HeadlessException {
        super(phetApplication.getSimInfo().getName() + " (" + phetApplication.getSimInfo().getVersion().formatForTitleBar() + ")");
        this.application = phetApplication;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PhetExit.exit();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowIconified(WindowEvent windowEvent) {
                phetApplication.pause();
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                phetApplication.resume();
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        this.helpMenu = new HelpMenu(phetApplication);
        this.defaultFileMenu = new PhetFileMenu(this, phetApplication.getSimInfo());
        jMenuBar.add(this.defaultFileMenu);
        jMenuBar.add(this.helpMenu);
        this.setJMenuBar(jMenuBar);
        phetApplication.addModuleObserver(new ModuleObserver(){

            public void moduleAdded(ModuleEvent moduleEvent) {
                PhetFrame.this.addModule(moduleEvent.getModule());
            }

            public void activeModuleChanged(ModuleEvent moduleEvent) {
            }

            public void moduleRemoved(ModuleEvent moduleEvent) {
                PhetFrame.this.removeModule(moduleEvent.getModule());
            }
        });
        if (this.getApplication().getSimInfo().isDev()) {
            this.addF8ToClearPreferencesFile();
        }
    }

    private void addF8ToClearPreferencesFile() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(119, 0), "reset-preferences-file");
        this.getRootPane().getActionMap().put("reset-preferences-file", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = PhetPreferences.getPreferencesFile().getParentFile().getAbsolutePath();
                    System.out.println("Preferences=" + PhetPreferences.getInstance().toString());
                    System.out.println("Resetting preferences file.");
                    PhetPreferences.clear();
                    System.out.println("Clearing session counts.");
                    SessionCounter.getInstance().clear();
                    JOptionPane.showMessageDialog(PhetFrame.this, "Preferences file and session counts cleared, press OK to exit.\nFile is " + string + "");
                    System.exit(0);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    System.out.println("Could not clear preferences, t=" + throwable);
                    JOptionPane.showMessageDialog(PhetFrame.this, "Couldn't clear preferences, perhaps you are not running with permission to do so.");
                }
            }
        });
    }

    public void setContentPane(Container container) {
        super.setContentPane(container);
        this.contentPanel = container;
    }

    private void addModule(Module module) {
        this.setContentPane(this.addToContentPane(module));
        this.lastAdded = module;
    }

    private JComponent addToContentPane(Module module) {
        if (this.contentPanel == null) {
            return module.getModulePanel();
        }
        if (this.contentPanel instanceof ModulePanel) {
            ITabbedModulePane iTabbedModulePane = this.application.createTabbedPane();
            iTabbedModulePane.init(this.application, new Module[]{this.lastAdded, module});
            return iTabbedModulePane.getComponent();
        }
        if (this.contentPanel instanceof ITabbedModulePane) {
            ITabbedModulePane iTabbedModulePane = (ITabbedModulePane)((Object)this.contentPanel);
            iTabbedModulePane.addTab(module);
            return (JComponent)((Object)iTabbedModulePane);
        }
        throw new RuntimeException("Illegal type for content pane: " + this.contentPanel);
    }

    public ITabbedModulePane getTabbedModulePane() {
        if (this.contentPanel instanceof ITabbedModulePane) {
            return (ITabbedModulePane)((Object)this.contentPanel);
        }
        return null;
    }

    private void removeModule(Module module) {
        this.setContentPane(this.removeFromContentPane(module));
    }

    private Container removeFromContentPane(Module module) {
        if (this.contentPanel == null) {
            throw new RuntimeException("Cannot remove module: " + module + ", from contentPane=" + this.contentPanel);
        }
        if (this.contentPanel == module.getModulePanel()) {
            return new JLabel("No modules");
        }
        if (this.contentPanel instanceof ITabbedModulePane) {
            ITabbedModulePane iTabbedModulePane = (ITabbedModulePane)((Object)this.contentPanel);
            iTabbedModulePane.removeTab(module);
            if (iTabbedModulePane.getTabCount() > 1) {
                return (Container)((Object)iTabbedModulePane);
            }
            if (iTabbedModulePane.getTabCount() == 1) {
                return iTabbedModulePane.getModulePanel(0);
            }
        }
        throw new RuntimeException("Illegal module/tab state");
    }

    public PhetApplication getApplication() {
        return this.application;
    }

    public void addMenu(JMenu jMenu) {
        SwingUtils.addMenuAt(jMenu, this.getJMenuBar(), this.getJMenuBar().getMenuCount() - 1);
    }

    public HelpMenu getHelpMenu() {
        return this.helpMenu;
    }
}

