/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.updates.dialogs;

import edu.colorado.phet.common.phetcommon.application.ISimInfo;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.resources.PhetVersion;
import edu.colorado.phet.common.phetcommon.updates.IAskMeLaterStrategy;
import edu.colorado.phet.common.phetcommon.updates.IVersionSkipper;
import edu.colorado.phet.common.phetcommon.updates.dialogs.SimAbstractUpdateDialog;
import java.awt.Frame;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SimAutomaticUpdateDialog
extends SimAbstractUpdateDialog {
    private static final String PREFEENCES_MESSAGE = PhetCommonResources.getString("Common.updates.seePreferences");
    private final IAskMeLaterStrategy askMeLaterStrategy;
    private final IVersionSkipper versionSkipper;

    public SimAutomaticUpdateDialog(Frame frame, ISimInfo iSimInfo, PhetVersion phetVersion, IAskMeLaterStrategy iAskMeLaterStrategy, IVersionSkipper iVersionSkipper) {
        super(frame, iSimInfo, phetVersion);
        this.askMeLaterStrategy = iAskMeLaterStrategy;
        this.versionSkipper = iVersionSkipper;
        this.initGUI();
    }

    protected JPanel createButtonPanel(ISimInfo iSimInfo, PhetVersion phetVersion) {
        JPanel jPanel = new JPanel();
        jPanel.add(new SimAbstractUpdateDialog.UpdateButton(this, iSimInfo, phetVersion));
        jPanel.add(Box.createHorizontalStrut(30));
        jPanel.add(new SimAbstractUpdateDialog.AskMeLaterButton(this, this.askMeLaterStrategy));
        jPanel.add(new SimAbstractUpdateDialog.SkipVersionButton(this, this.versionSkipper, phetVersion));
        return jPanel;
    }

    protected JComponent createAdditionalMessageComponent() {
        String string = "<html><font size=\"2\">" + PREFEENCES_MESSAGE + "</font></html>";
        return new JLabel(string);
    }
}

