/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.Vector2DNode;
import edu.colorado.phet.opticaltweezers.model.Fluid;
import edu.colorado.phet.opticaltweezers.model.MicroscopeSlide;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class MicroscopeSlideNode
extends PhetPNode
implements Observer {
    private static final Stroke EDGE_STROKE = new BasicStroke(1.0f);
    private static final Color FLUID_EDGE_STROKE_COLOR = Color.BLACK;
    private static final Color FLUID_EDGE_FILL_COLOR = new Color(176, 218, 200);
    private static final Color FLUID_CENTER_FILL_COLOR = new Color(220, 239, 239);
    private static final Color VACUUM_EDGE_STROKE_COLOR = Color.BLACK;
    private static final Color VACUUM_EDGE_FILL_COLOR = Color.DARK_GRAY;
    private static final Color VACUUM_CENTER_FILL_COLOR = Color.BLACK;
    private static final Stroke VELOCITY_VECTOR_STROKE = new BasicStroke(1.0f);
    private static final Paint VELOCITY_VECTOR_STROKE_PAINT = Color.BLACK;
    private static final Paint VELOCITY_VECTOR_FILL_PAINT = FLUID_EDGE_FILL_COLOR;
    private final MicroscopeSlide _microscopeSlide;
    private final Fluid _fluid;
    private final OTModelViewTransform _modelViewTransform;
    private double _worldWidth;
    private PPath _topEdgeNode;
    private PPath _bottomEdgeNode;
    private PPath _centerNode;
    private PNode _velocityVectorsParentNode;

    public MicroscopeSlideNode(MicroscopeSlide microscopeSlide, Fluid fluid, OTModelViewTransform oTModelViewTransform, double d) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._microscopeSlide = microscopeSlide;
        this._fluid = fluid;
        this._fluid.addObserver(this);
        this._modelViewTransform = oTModelViewTransform;
        this._worldWidth = 1.0;
        this._topEdgeNode = new PPath();
        this._topEdgeNode.setStroke(EDGE_STROKE);
        this._bottomEdgeNode = new PPath();
        this._bottomEdgeNode.setStroke(EDGE_STROKE);
        this._centerNode = new PPath();
        this._centerNode.setStroke(null);
        double d2 = this._modelViewTransform.modelToView(this._microscopeSlide.getCenterHeight());
        double d3 = d;
        this._velocityVectorsParentNode = new PComposite();
        for (int i = 0; i < 10; ++i) {
            VelocityVectorNode velocityVectorNode = new VelocityVectorNode(d3, 0.0, d3, 125.0);
            double d4 = 30.0;
            double d5 = (double)i * d2 / 10.0 + 10.0;
            velocityVectorNode.setOffset(d4, d5);
            this._velocityVectorsParentNode.addChild(velocityVectorNode);
        }
        this.addChild(this._centerNode);
        this.addChild(this._topEdgeNode);
        this.addChild(this._bottomEdgeNode);
        this.addChild(this._velocityVectorsParentNode);
        this.updateSlideGeometry();
        this.updateSlideColors();
        this.updateVelocityVectors();
    }

    public Rectangle2D getCenterGlobalBounds() {
        return this._centerNode.getGlobalFullBounds();
    }

    public void setWorldSize(Dimension2D dimension2D) {
        double d = dimension2D.getWidth();
        if (d <= 0.0) {
            throw new IllegalArgumentException("worldSize must have width > 0: " + d);
        }
        if (d != this._worldWidth) {
            this._worldWidth = d;
            this.updateSlideGeometry();
            this.updateVelocityVectors();
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this._fluid) {
            if (object == "speed") {
                this.updateVelocityVectors();
            } else if (object == "enabled") {
                this.updateSlideColors();
                this.updateVelocityVectors();
            }
        }
    }

    private void updateSlideGeometry() {
        double d = this._modelViewTransform.modelToView(this._microscopeSlide.getCenterHeight());
        double d2 = this._modelViewTransform.modelToView(this._microscopeSlide.getEdgeHeight());
        double d3 = this._modelViewTransform.modelToView(this._microscopeSlide.getY());
        this._topEdgeNode.setPathTo(new Rectangle2D.Double(0.0, 0.0, this._worldWidth, d2));
        this._bottomEdgeNode.setPathTo(new Rectangle2D.Double(0.0, 0.0, this._worldWidth, d2));
        this._centerNode.setPathTo(new Rectangle2D.Double(0.0, 0.0, this._worldWidth, d));
        this._topEdgeNode.setOffset(0.0, -(d / 2.0) - d2);
        this._centerNode.setOffset(0.0, -(d / 2.0));
        this._bottomEdgeNode.setOffset(0.0, d / 2.0);
        this._velocityVectorsParentNode.setOffset(0.0, this._centerNode.getOffset().getY() + (this._centerNode.getFullBoundsReference().getHeight() - this._velocityVectorsParentNode.getFullBoundsReference().getHeight()) / 2.0);
        this.setOffset(0.0, d3);
    }

    private void updateSlideColors() {
        if (this._fluid.isEnabled()) {
            this._topEdgeNode.setStrokePaint(FLUID_EDGE_STROKE_COLOR);
            this._topEdgeNode.setPaint(FLUID_EDGE_FILL_COLOR);
            this._topEdgeNode.setPaint(FLUID_EDGE_FILL_COLOR);
            this._bottomEdgeNode.setStrokePaint(FLUID_EDGE_STROKE_COLOR);
            this._bottomEdgeNode.setPaint(FLUID_EDGE_FILL_COLOR);
            this._bottomEdgeNode.setPaint(FLUID_EDGE_FILL_COLOR);
            this._centerNode.setPaint(FLUID_CENTER_FILL_COLOR);
        } else {
            this._topEdgeNode.setStrokePaint(VACUUM_EDGE_STROKE_COLOR);
            this._topEdgeNode.setPaint(VACUUM_EDGE_STROKE_COLOR);
            this._topEdgeNode.setPaint(VACUUM_EDGE_FILL_COLOR);
            this._bottomEdgeNode.setStrokePaint(VACUUM_EDGE_STROKE_COLOR);
            this._bottomEdgeNode.setPaint(VACUUM_EDGE_STROKE_COLOR);
            this._bottomEdgeNode.setPaint(VACUUM_EDGE_FILL_COLOR);
            this._centerNode.setPaint(VACUUM_CENTER_FILL_COLOR);
        }
    }

    private void updateVelocityVectors() {
        boolean bl = this._fluid.isEnabled();
        this._velocityVectorsParentNode.setVisible(bl);
        if (bl) {
            double d = this._fluid.getSpeed();
            double d2 = this._fluid.getDirection();
            List list = this._velocityVectorsParentNode.getChildrenReference();
            for (Object e : list) {
                if (!(e instanceof VelocityVectorNode)) continue;
                VelocityVectorNode velocityVectorNode = (VelocityVectorNode)e;
                velocityVectorNode.setMagnitudeAngle(d, d2);
            }
        }
    }

    private class VelocityVectorNode
    extends Vector2DNode {
        public VelocityVectorNode(double d, double d2, double d3, double d4) {
            super(d, d2, d3, d4);
            this.setHeadSize(20.0, 20.0);
            this.setTailWidth(10.0);
            this.setArrowFillPaint(VELOCITY_VECTOR_FILL_PAINT);
            this.setArrowStroke(VELOCITY_VECTOR_STROKE);
            this.setArrowStrokePaint(VELOCITY_VECTOR_STROKE_PAINT);
            this.setFractionalHeadHeight(0.5);
            this.setValueVisible(false);
        }
    }
}

