/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class LaserOutlineNode
extends PhetPNode {
    private static final Color OUTLINE_COLOR = Color.GRAY;
    public static final Stroke OUTLINE_STROKE = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 6.0f}, 0.0f);

    public LaserOutlineNode(Laser laser, OTModelViewTransform oTModelViewTransform) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        PNode pNode = this.createOutlineNode(laser, oTModelViewTransform);
        this.addChild(pNode);
    }

    private PNode createOutlineNode(Laser laser, OTModelViewTransform oTModelViewTransform) {
        int n;
        int n2;
        int n3;
        int n4 = (int)laser.getDistanceFromObjectiveToWaist();
        Point2D.Double[] doubleArray = new Point2D.Double[n4];
        for (n3 = 0; n3 < doubleArray.length; ++n3) {
            double d = laser.getRadius(n3);
            doubleArray[n3] = new Point2D.Double(d, n3);
        }
        n3 = 0;
        int n5 = doubleArray.length - 1;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)((Point2D)doubleArray[n5]).getX(), -((float)((Point2D)doubleArray[n5]).getY()));
        for (n2 = n5 - 1; n2 > n3; --n2) {
            generalPath.lineTo((float)((Point2D)doubleArray[n2]).getX(), -((float)((Point2D)doubleArray[n2]).getY()));
        }
        for (n2 = n3; n2 < n5; ++n2) {
            generalPath.lineTo((float)((Point2D)doubleArray[n2]).getX(), (float)((Point2D)doubleArray[n2]).getY());
        }
        generalPath.lineTo((float)((Point2D)doubleArray[n5]).getX(), (float)(((Point2D)doubleArray[n5]).getY() + laser.getDistanceFromObjectiveToControlPanel()));
        Shape shape = oTModelViewTransform.createTransformedShapeModelToView(generalPath);
        PPath pPath = new PPath(shape);
        pPath.setStroke(OUTLINE_STROKE);
        pPath.setStrokePaint(OUTLINE_COLOR);
        pPath.setPaint(null);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo((float)(-((Point2D)doubleArray[n5]).getX()), -((float)((Point2D)doubleArray[n5]).getY()));
        for (n = n5 - 1; n > n3; --n) {
            generalPath2.lineTo((float)(-((Point2D)doubleArray[n]).getX()), -((float)((Point2D)doubleArray[n]).getY()));
        }
        for (n = n3; n < n5; ++n) {
            generalPath2.lineTo((float)(-((Point2D)doubleArray[n]).getX()), (float)((Point2D)doubleArray[n]).getY());
        }
        generalPath2.lineTo((float)(-((Point2D)doubleArray[n5]).getX()), (float)(((Point2D)doubleArray[n5]).getY() + laser.getDistanceFromObjectiveToControlPanel()));
        Shape shape2 = oTModelViewTransform.createTransformedShapeModelToView(generalPath2);
        PPath pPath2 = new PPath(shape2);
        pPath2.setStroke(OUTLINE_STROKE);
        pPath2.setStrokePaint(OUTLINE_COLOR);
        pPath2.setPaint(null);
        PComposite pComposite = new PComposite();
        pComposite.addChild(pPath2);
        pComposite.addChild(pPath);
        double d = oTModelViewTransform.modelToView(laser.getDistanceFromObjectiveToControlPanel());
        PBounds pBounds = pComposite.getFullBoundsReference();
        pComposite.setOffset(pBounds.getWidth() / 2.0, pBounds.getHeight() / 2.0 - d / 2.0);
        return pComposite;
    }
}

