/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.view;

import edu.colorado.phet.common.piccolophet.nodes.Vector2DNode;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.OTResources;
import java.awt.BasicStroke;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ElectricFieldVectorNode
extends Vector2DNode {
    private static final String UNITS = OTResources.getString("units.electricField");
    private static final Stroke VECTOR_STROKE = new BasicStroke(2.0f);
    private final Point2D _offsetFromLaser;

    public ElectricFieldVectorNode(double d, double d2, double d3, double d4) {
        super(0.0, 0.0, d3, d4);
        this._offsetFromLaser = new Point2D.Double(d, d2);
        this.setArrowStroke(VECTOR_STROKE);
        this.setArrowFillPaint(null);
        this.setUnits(UNITS);
    }

    public Point2D getOffsetFromLaserReference() {
        return this._offsetFromLaser;
    }

    public static Icon createIcon() {
        Vector2DNode vector2DNode = new Vector2DNode(-25.0, 0.0, 25.0, 25.0);
        vector2DNode.setUpdateEnabled(false);
        vector2DNode.setArrowStroke(VECTOR_STROKE);
        vector2DNode.setArrowStrokePaint(OTConstants.ELECTRIC_FIELD_COLOR);
        vector2DNode.setArrowFillPaint(null);
        vector2DNode.setTailWidth(3.0);
        vector2DNode.setHeadSize(OTConstants.VECTOR_ICON_HEAD_SIZE.width, OTConstants.VECTOR_ICON_HEAD_SIZE.height);
        vector2DNode.setUpdateEnabled(true);
        Image image = vector2DNode.toImage();
        return new ImageIcon(image);
    }
}

