/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.view;

import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.colorado.phet.opticaltweezers.view.AbstractChargeNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;

public class ChargeExcessNode
extends AbstractChargeNode {
    private PNode _positiveNode;
    private PNode _negativeNode;
    private double _viewBeadRadius;
    private double _viewMargin;

    public ChargeExcessNode(Bead bead, Laser laser, OTModelViewTransform oTModelViewTransform) {
        super(bead, laser, oTModelViewTransform);
    }

    protected void initialize() {
        OTModelViewTransform oTModelViewTransform = this.getModelViewTransform();
        double d = oTModelViewTransform.modelToView(80.0);
        double d2 = oTModelViewTransform.modelToView(20.0);
        this._positiveNode = ChargeExcessNode.createPositiveNode(d, d2);
        this.addChild(this._positiveNode);
        this._negativeNode = ChargeExcessNode.createNegativeNode(d, d2);
        this.addChild(this._negativeNode);
        Bead bead = this.getBead();
        this._viewBeadRadius = oTModelViewTransform.modelToView(bead.getDiameter() / 2.0);
        this._viewMargin = oTModelViewTransform.modelToView(10.0);
        this.updateCharges();
    }

    protected void updateCharges() {
        Bead bead = this.getBead();
        double d = bead.getElectricFieldX();
        double d2 = this.getChargeScale(d);
        this._positiveNode.setVisible(d2 > 0.0);
        this._negativeNode.setVisible(d2 > 0.0);
        if (d2 > 0.0) {
            PBounds pBounds = this._positiveNode.getFullBoundsReference();
            PBounds pBounds2 = this._negativeNode.getFullBoundsReference();
            this._positiveNode.setScale(d2);
            double d3 = d > 0.0 ? this._viewBeadRadius - pBounds.getWidth() - this._viewMargin : -this._viewBeadRadius + this._viewMargin;
            double d4 = -pBounds.getHeight() / 2.0;
            this._positiveNode.setOffset(d3, d4);
            this._negativeNode.setScale(d2);
            d3 = d > 0.0 ? -this._viewBeadRadius + this._viewMargin : this._viewBeadRadius - pBounds2.getWidth() - this._viewMargin;
            d4 = -pBounds2.getHeight() / 2.0;
            this._negativeNode.setOffset(d3, d4);
        }
    }
}

