/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.Vector2DNode;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.util.OTVector2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DecimalFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class AbstractForceNode
extends PhetPNode {
    private static final Stroke VECTOR_STROKE = new BasicStroke(1.0f);
    private static final Paint VECTOR_STROKE_PAINT = Color.BLACK;
    private static final Paint VALUE_PAINT = Color.BLACK;
    private static final DecimalFormat VALUE_FORMAT = new DecimalFormat("0.##E0");
    private Vector2DNode _sumNode;
    private Vector2DNode _xComponentNode;
    private Vector2DNode _yComponentNode;

    public AbstractForceNode(double d, double d2, String string, Color color) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._sumNode = AbstractForceNode.createVectorNode(color, d, d2, string);
        this._sumNode.setValuePaint(VALUE_PAINT);
        this._sumNode.setValueVisible(false);
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 100);
        this._xComponentNode = AbstractForceNode.createVectorNode(color2, d, d2, string);
        this._xComponentNode.setValuePaint(VALUE_PAINT);
        this._xComponentNode.setValueVisible(false);
        this._yComponentNode = AbstractForceNode.createVectorNode(color2, d, d2, string);
        this._yComponentNode.setValuePaint(VALUE_PAINT);
        this._yComponentNode.setValueVisible(false);
        this.addChild(this._xComponentNode);
        this.addChild(this._yComponentNode);
        this.addChild(this._sumNode);
        this.setValuesVisible(false);
        this.setComponentVectorsVisible(false);
    }

    private static Vector2DNode createVectorNode(Paint paint, double d, double d2, String string) {
        Vector2DNode vector2DNode = new Vector2DNode(0.0, 0.0, d, d2);
        vector2DNode.setUpdateEnabled(false);
        vector2DNode.setHeadSize(20.0, 20.0);
        vector2DNode.setTailWidth(5.0);
        vector2DNode.setArrowFillPaint(paint);
        vector2DNode.setArrowStroke(VECTOR_STROKE);
        vector2DNode.setArrowStrokePaint(VECTOR_STROKE_PAINT);
        vector2DNode.setValueSpacing(2.0);
        vector2DNode.setValueVisible(false);
        vector2DNode.setValueFormat(VALUE_FORMAT);
        vector2DNode.setUnits(string);
        vector2DNode.setUpdateEnabled(true);
        return vector2DNode;
    }

    public void setComponentVectorsVisible(boolean bl) {
        this._xComponentNode.setVisible(bl);
        this._yComponentNode.setVisible(bl);
    }

    public void setValuesVisible(boolean bl) {
        this._sumNode.setValueVisible(bl);
        this._xComponentNode.setValueVisible(bl);
        this._yComponentNode.setValueVisible(bl);
    }

    protected void setForce(OTVector2D oTVector2D) {
        this._sumNode.setXY(oTVector2D.getX(), oTVector2D.getY());
        this._xComponentNode.setXY(oTVector2D.getX(), 0.0);
        this._yComponentNode.setXY(0.0, oTVector2D.getY());
    }

    public void setArrowFillPaint(Paint paint) {
        this._sumNode.setArrowFillPaint(paint);
        this._xComponentNode.setArrowFillPaint(paint);
        this._yComponentNode.setArrowFillPaint(paint);
    }

    public Paint getArrowFillPaint() {
        return this._sumNode.getArrowFillPaint();
    }

    protected static Icon createIcon(Color color) {
        Vector2DNode vector2DNode = new Vector2DNode(-25.0, 0.0, 25.0, 25.0);
        vector2DNode.setArrowFillPaint(color);
        vector2DNode.setTailWidth(3.0);
        vector2DNode.setHeadSize(OTConstants.VECTOR_ICON_HEAD_SIZE.width, OTConstants.VECTOR_ICON_HEAD_SIZE.height);
        Image image = vector2DNode.toImage();
        return new ImageIcon(image);
    }
}

