/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.util;

public abstract class OTVector2D {
    private double _x = 0.0;
    private double _y = 0.0;
    private double _magnitude = 0.0;
    private double _angle = 0.0;
    private boolean _cartesianDirty = false;
    private boolean _polarDirty = false;

    protected OTVector2D() {
    }

    private void updateCartesian() {
        assert (this._cartesianDirty && !this._polarDirty);
        this._x = this._magnitude * Math.cos(this._angle);
        this._y = this._magnitude * Math.sin(this._angle);
        this._cartesianDirty = false;
    }

    private void updatePolar() {
        assert (this._polarDirty && !this._cartesianDirty);
        this._magnitude = Math.sqrt(this._x * this._x + this._y * this._y);
        this._angle = Math.atan2(this._y, this._x);
        this._polarDirty = false;
    }

    public void setXY(double d, double d2) {
        this._x = d;
        this._y = d2;
        this._cartesianDirty = false;
        this._polarDirty = true;
    }

    public double getX() {
        if (this._cartesianDirty) {
            this.updateCartesian();
        }
        return this._x;
    }

    public double getY() {
        if (this._cartesianDirty) {
            this.updateCartesian();
        }
        return this._y;
    }

    public void setMagnitudeAngle(double d, double d2) {
        this._magnitude = d;
        this._angle = d2;
        this._polarDirty = false;
        this._cartesianDirty = true;
    }

    public double getMagnitude() {
        if (this._polarDirty) {
            this.updatePolar();
        }
        return this._magnitude;
    }

    public static class Cartesian
    extends OTVector2D {
        public Cartesian() {
            this(0.0, 0.0);
        }

        public Cartesian(double d, double d2) {
            this.setXY(d, d2);
        }
    }

    public static class Polar
    extends OTVector2D {
        public Polar() {
            this(0.0, 0.0);
        }

        public Polar(double d, double d2) {
            this.setMagnitudeAngle(d, d2);
        }
    }
}

