/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.module.physics;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.piccolophet.help.HelpBalloon;
import edu.colorado.phet.common.piccolophet.help.HelpPane;
import edu.colorado.phet.opticaltweezers.OTResources;
import edu.colorado.phet.opticaltweezers.control.ChargeControlPanel;
import edu.colorado.phet.opticaltweezers.control.ChartsControlPanel;
import edu.colorado.phet.opticaltweezers.control.ForcesControlPanel;
import edu.colorado.phet.opticaltweezers.control.LaserDisplayControlPanel;
import edu.colorado.phet.opticaltweezers.control.MiscControlPanel;
import edu.colorado.phet.opticaltweezers.control.OTClockControlPanel;
import edu.colorado.phet.opticaltweezers.control.developer.DeveloperControlPanel;
import edu.colorado.phet.opticaltweezers.defaults.PhysicsDefaults;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.FixedObject;
import edu.colorado.phet.opticaltweezers.model.Fluid;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.MovableObject;
import edu.colorado.phet.opticaltweezers.model.OTClock;
import edu.colorado.phet.opticaltweezers.module.OTAbstractModel;
import edu.colorado.phet.opticaltweezers.module.OTAbstractModule;
import edu.colorado.phet.opticaltweezers.module.physics.PhysicsCanvas;
import edu.colorado.phet.opticaltweezers.module.physics.PhysicsControlPanel;
import edu.colorado.phet.opticaltweezers.module.physics.PhysicsModel;
import edu.colorado.phet.opticaltweezers.persistence.PhysicsConfig;
import java.awt.Frame;

public class PhysicsModule
extends OTAbstractModule {
    private PhysicsModel _model;
    private PhysicsCanvas _canvas;
    private PhysicsControlPanel _controlPanel;
    private OTClockControlPanel _clockControlPanel;
    private boolean _fluidControlsWasSelected;
    private boolean _positionHistogramWasSelected;

    public PhysicsModule(Frame frame) {
        super(OTResources.getString("title.physicsOfTweezers"), PhysicsDefaults.CLOCK);
        OTClock oTClock = (OTClock)this.getClock();
        this._model = new PhysicsModel(oTClock);
        this._canvas = new PhysicsCanvas(this._model);
        this.setSimulationPanel(this._canvas);
        this._controlPanel = new PhysicsControlPanel(this, frame);
        this.setControlPanel(this._controlPanel);
        this._clockControlPanel = new OTClockControlPanel((OTClock)this.getClock());
        this._clockControlPanel.setTimeColumns(10);
        this.setClockControlPanel(this._clockControlPanel);
        if (this.hasHelp()) {
            HelpPane helpPane = this.getDefaultHelpPane();
            HelpBalloon helpBalloon = new HelpBalloon(helpPane, OTResources.getString("help.bead"), HelpBalloon.RIGHT_CENTER, 20.0);
            helpPane.add(helpBalloon);
            helpBalloon.pointAt(this._canvas.getBeadNode(), this._canvas);
            HelpBalloon helpBalloon2 = new HelpBalloon(helpPane, OTResources.getString("help.laser"), HelpBalloon.RIGHT_CENTER, 20.0);
            helpPane.add(helpBalloon2);
            helpBalloon2.pointAt(this._canvas.getLaserNode().getLeftHandleNode(), this._canvas);
            HelpBalloon helpBalloon3 = new HelpBalloon(helpPane, OTResources.getString("help.ruler"), HelpBalloon.TOP_CENTER, 20.0);
            helpPane.add(helpBalloon3);
            helpBalloon3.pointAt(this._canvas.getRulerNode(), this._canvas);
        }
        this.reset();
        this._fluidControlsWasSelected = this._controlPanel.getMiscControlPanel().isFluidControlsSelected();
        this._positionHistogramWasSelected = this._controlPanel.getChartsControlPanel().isPositionHistogramSelected();
    }

    public PhysicsModel getPhysicsModel() {
        return this._model;
    }

    public PhysicsCanvas getPhysicsCanvas() {
        return this._canvas;
    }

    public boolean hasHelp() {
        return true;
    }

    public void activate() {
        super.activate();
        this._controlPanel.getMiscControlPanel().setFluidControlsSelected(this._fluidControlsWasSelected);
        this._controlPanel.getChartsControlPanel().setPositionHistogramSelected(this._positionHistogramWasSelected);
    }

    public void deactivate() {
        this._fluidControlsWasSelected = this._controlPanel.getMiscControlPanel().isFluidControlsSelected();
        this._positionHistogramWasSelected = this._controlPanel.getChartsControlPanel().isPositionHistogramSelected();
        this._controlPanel.closeAllDialogs();
        super.deactivate();
    }

    public void reset() {
        Object object = this._model.getClock();
        ((OTClock)object).setDt(PhysicsDefaults.DEFAULT_DT);
        this.setClockRunningWhenActive(true);
        Object object2 = this._model.getBead();
        ((MovableObject)object2).setPosition(PhysicsDefaults.BEAD_POSITION);
        ((MovableObject)object2).setOrientation(PhysicsDefaults.BEAD_ORIENTATION);
        ((Bead)object2).setDtSubdivisionThreshold(PhysicsDefaults.BEAD_DT_SUBDIVISION_THRESHOLD_RANGE.getDefault());
        ((Bead)object2).setNumberOfDtSubdivisions(PhysicsDefaults.BEAD_NUMBER_OF_DT_SUBDIVISIONS_RANGE.getDefault());
        ((Bead)object2).setBrownianMotionScale(PhysicsDefaults.BEAD_BROWNIAN_MOTION_SCALE_RANGE.getDefault());
        ((Bead)object2).setBrownianMotionEnabled(true);
        ((Bead)object2).setVerletDtSubdivisionThreshold(PhysicsDefaults.BEAD_VERLET_DT_SUBDIVISION_THRESHOLD_RANGE.getDefault());
        ((Bead)object2).setVerletNumberOfDtSubdivisions(PhysicsDefaults.BEAD_VERLET_NUMBER_OF_DT_SUBDIVISIONS_RANGE.getDefault());
        ((Bead)object2).setVerletAccelerationScale(PhysicsDefaults.BEAD_VERLET_ACCELERATION_SCALE_RANGE.getDefault());
        ((Bead)object2).setVacuumFastThreshold(PhysicsDefaults.BEAD_VACUUM_FAST_THRESHOLD_RANGE.getDefault());
        ((Bead)object2).setVacuumFastDt(PhysicsDefaults.BEAD_VACUUM_FAST_DT_RANGE.getDefault());
        ((Bead)object2).setVacuumFastPower(PhysicsDefaults.BEAD_VACUUM_FAST_POWER_RANGE.getDefault());
        Object object3 = this._model.getLaser();
        ((MovableObject)object3).setPosition(PhysicsDefaults.LASER_POSITION);
        ((Laser)object3).setPower(PhysicsDefaults.LASER_POWER_RANGE.getDefault());
        ((Laser)object3).setRunning(true);
        ((Laser)object3).setTrapForceRatio(PhysicsDefaults.LASER_TRAP_FORCE_RATIO.getDefault());
        ((Laser)object3).setElectricFieldScale(PhysicsDefaults.LASER_ELECTRIC_FIELD_SCALE_RANGE.getDefault());
        Object object4 = this._model.getFluid();
        ((Fluid)object4).setSpeed(PhysicsDefaults.FLUID_SPEED_RANGE.getDefault());
        ((Fluid)object4).setViscosity(PhysicsDefaults.FLUID_VISCOSITY_RANGE.getDefault());
        ((Fluid)object4).setTemperature(PhysicsDefaults.FLUID_TEMPERATURE_RANGE.getDefault());
        this._controlPanel.getSimulationSpeedControlPanel().setSimulationSpeed(PhysicsDefaults.DEFAULT_DT);
        object = this._controlPanel.getLaserDisplayControlPanel();
        ((LaserDisplayControlPanel)object).setDisplaySelection(true, false);
        object2 = this._controlPanel.getChargeControlPanel();
        ((ChargeControlPanel)object2).setHiddenSelected(true);
        ((ChargeControlPanel)object2).setDistributionSelected(false);
        ((ChargeControlPanel)object2).setExcessSelected(false);
        object3 = this._controlPanel.getForcesControlPanel();
        ((ForcesControlPanel)object3).setTrapForceSelected(false);
        ((ForcesControlPanel)object3).setDragForceSelected(false);
        object4 = this._controlPanel.getChartsControlPanel();
        ((ChartsControlPanel)object4).setPositionHistogramSelected(false);
        ((ChartsControlPanel)object4).setPotentialEnergySelected(false);
        MiscControlPanel miscControlPanel = this._controlPanel.getMiscControlPanel();
        miscControlPanel.setRulerSelected(false);
        miscControlPanel.setFluidSelected(true);
        miscControlPanel.setVacuumSelected(false);
        miscControlPanel.setFluidControlsSelected(false);
        DeveloperControlPanel developerControlPanel = this._controlPanel.getDeveloperControlPanel();
        developerControlPanel.getVectorsPanel().setComponentsVisible(false);
        developerControlPanel.getBeadPanel().setChargeMotionScale(PhysicsDefaults.CHARGE_MOTION_SCALE_RANGE.getDefault());
    }

    public PhysicsConfig save() {
        PhysicsConfig physicsConfig = new PhysicsConfig();
        physicsConfig.setActive(this.isActive());
        Object object = this.getPhysicsModel();
        Object object2 = ((OTAbstractModel)object).getClock();
        physicsConfig.setClockDt(((ConstantDtClock)object2).getDt());
        physicsConfig.setClockRunning(this.getClockRunningWhenActive());
        Object object3 = ((PhysicsModel)object).getLaser();
        physicsConfig.setLaserX(((FixedObject)object3).getX());
        physicsConfig.setLaserRunning(((Laser)object3).isRunning());
        physicsConfig.setLaserPower(((Laser)object3).getPower());
        Object object4 = ((PhysicsModel)object).getBead();
        physicsConfig.setBeadX(((FixedObject)object4).getX());
        physicsConfig.setBeadY(((FixedObject)object4).getY());
        Object object5 = ((PhysicsModel)object).getFluid();
        physicsConfig.setFluidSpeed(((Fluid)object5).getSpeed());
        physicsConfig.setFluidViscosity(((Fluid)object5).getViscosity());
        physicsConfig.setFluidTemperature(((Fluid)object5).getTemperature());
        object = this._controlPanel.getLaserDisplayControlPanel();
        physicsConfig.setLaserBeamSelected(((LaserDisplayControlPanel)object).isBeamSelected());
        physicsConfig.setLaserElectricFieldSelected(((LaserDisplayControlPanel)object).isElectricFieldSelected());
        object2 = this._controlPanel.getChargeControlPanel();
        physicsConfig.setChargeDistributionSelected(((ChargeControlPanel)object2).isDistributionSelected());
        physicsConfig.setChargeExcessSelected(((ChargeControlPanel)object2).isExcessSelected());
        object3 = this._controlPanel.getForcesControlPanel();
        physicsConfig.setTrapForceSelected(((ForcesControlPanel)object3).isTrapForceSelected());
        physicsConfig.setDragForceSelected(((ForcesControlPanel)object3).isDragForceSelected());
        physicsConfig.setBrownianForceEnabled(((ForcesControlPanel)object3).isBrownianMotionSelected());
        object4 = this._controlPanel.getChartsControlPanel();
        if (this.isActive()) {
            physicsConfig.setPositionHistogramSelected(((ChartsControlPanel)object4).isPositionHistogramSelected());
        } else {
            physicsConfig.setPositionHistogramSelected(this._positionHistogramWasSelected);
        }
        physicsConfig.setPotentialEnergySelected(((ChartsControlPanel)object4).isPotentialChartSelected());
        object5 = this._controlPanel.getMiscControlPanel();
        physicsConfig.setRulerSelected(((MiscControlPanel)object5).isRulerSelected());
        physicsConfig.setFluidSelected(((MiscControlPanel)object5).isFluidSelected());
        physicsConfig.setVacuumSelected(((MiscControlPanel)object5).isVacuumSelected());
        if (this.isActive()) {
            physicsConfig.setFluidControlsSelected(((MiscControlPanel)object5).isFluidControlsSelected());
        } else {
            physicsConfig.setFluidControlsSelected(this._fluidControlsWasSelected);
        }
        return physicsConfig;
    }

    public void load(PhysicsConfig physicsConfig) {
        if (physicsConfig.isActive()) {
            PhetApplication.getInstance().setActiveModule(this);
        }
        Object object = this.getPhysicsModel();
        Object object2 = ((OTAbstractModel)object).getClock();
        ((OTClock)object2).setDt(physicsConfig.getClockDt());
        this.setClockRunningWhenActive(physicsConfig.isClockRunning());
        Object object3 = ((PhysicsModel)object).getLaser();
        ((MovableObject)object3).setPosition(physicsConfig.getLaserX(), ((FixedObject)object3).getY());
        ((Laser)object3).setRunning(physicsConfig.isLaserRunning());
        ((Laser)object3).setPower(physicsConfig.getLaserPower());
        Object object4 = ((PhysicsModel)object).getBead();
        ((MovableObject)object4).setPosition(physicsConfig.getBeadX(), physicsConfig.getBeadY());
        Object object5 = ((PhysicsModel)object).getFluid();
        ((Fluid)object5).setSpeed(physicsConfig.getFluidSpeed());
        ((Fluid)object5).setViscosity(physicsConfig.getFluidViscosity());
        ((Fluid)object5).setTemperature(physicsConfig.getFluidTemperature());
        object = this._controlPanel.getLaserDisplayControlPanel();
        ((LaserDisplayControlPanel)object).setDisplaySelection(physicsConfig.isLaserBeamSelected(), physicsConfig.isLaserElectricFieldSelected());
        object2 = this._controlPanel.getChargeControlPanel();
        ((ChargeControlPanel)object2).setDistributionSelected(physicsConfig.isChargeDistributionSelected());
        ((ChargeControlPanel)object2).setExcessSelected(physicsConfig.isChargeExcessSelected());
        object3 = this._controlPanel.getForcesControlPanel();
        ((ForcesControlPanel)object3).setTrapForceSelected(physicsConfig.isTrapForceSelected());
        ((ForcesControlPanel)object3).setDragForceSelected(physicsConfig.isDragForceSelected());
        ((ForcesControlPanel)object3).setBrownianMotionSelected(physicsConfig.isBrownianForceEnabled());
        object4 = this._controlPanel.getChartsControlPanel();
        if (this.isActive()) {
            ((ChartsControlPanel)object4).setPositionHistogramSelected(physicsConfig.isPositionHistogramSelected());
        } else {
            this._positionHistogramWasSelected = physicsConfig.isPositionHistogramSelected();
        }
        ((ChartsControlPanel)object4).setPotentialEnergySelected(physicsConfig.isPotentialEnergySelected());
        object5 = this._controlPanel.getMiscControlPanel();
        ((MiscControlPanel)object5).setRulerSelected(physicsConfig.isRulerSelected());
        ((MiscControlPanel)object5).setFluidSelected(physicsConfig.isFluidSelected());
        ((MiscControlPanel)object5).setVacuumSelected(physicsConfig.isVacuumSelected());
        if (this.isActive()) {
            ((MiscControlPanel)object5).setFluidControlsSelected(physicsConfig.isFluidControlsSelected());
        } else {
            this._fluidControlsWasSelected = physicsConfig.isFluidControlsSelected();
        }
    }
}

