/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.module.physics;

import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.opticaltweezers.control.ChargeControlPanel;
import edu.colorado.phet.opticaltweezers.control.ChartsControlPanel;
import edu.colorado.phet.opticaltweezers.control.ForcesControlPanel;
import edu.colorado.phet.opticaltweezers.control.LaserDisplayControlPanel;
import edu.colorado.phet.opticaltweezers.control.MiscControlPanel;
import edu.colorado.phet.opticaltweezers.control.SimulationSpeedControlPanel;
import edu.colorado.phet.opticaltweezers.control.developer.DeveloperControlPanel;
import edu.colorado.phet.opticaltweezers.defaults.PhysicsDefaults;
import edu.colorado.phet.opticaltweezers.model.OTClock;
import edu.colorado.phet.opticaltweezers.module.OTAbstractControlPanel;
import edu.colorado.phet.opticaltweezers.module.physics.PhysicsCanvas;
import edu.colorado.phet.opticaltweezers.module.physics.PhysicsModel;
import edu.colorado.phet.opticaltweezers.module.physics.PhysicsModule;
import java.awt.Frame;

public class PhysicsControlPanel
extends OTAbstractControlPanel {
    private PhysicsCanvas _canvas;
    private SimulationSpeedControlPanel _simulationSpeedControlPanel;
    private LaserDisplayControlPanel _laserDisplayControlPanel;
    private ChargeControlPanel _chargeControlPanel;
    private ForcesControlPanel _forcesControlPanel;
    private ChartsControlPanel _chartsControlPanel;
    private MiscControlPanel _miscControlPanel;
    private DeveloperControlPanel _developerControlPanel;

    public PhysicsControlPanel(PhysicsModule physicsModule, Frame frame) {
        super(physicsModule);
        this._canvas = physicsModule.getPhysicsCanvas();
        PhysicsModel physicsModel = physicsModule.getPhysicsModel();
        this._simulationSpeedControlPanel = new SimulationSpeedControlPanel(TITLE_FONT, CONTROL_FONT, physicsModel.getClock());
        this._laserDisplayControlPanel = new LaserDisplayControlPanel(TITLE_FONT, CONTROL_FONT, this._canvas.getLaserNode());
        this._chargeControlPanel = new ChargeControlPanel(TITLE_FONT, CONTROL_FONT, this._canvas.getChargeDistributionNode(), this._canvas.getChargeExcessNode());
        this._forcesControlPanel = new ForcesControlPanel(TITLE_FONT, CONTROL_FONT, physicsModel.getBead(), physicsModel.getFluid(), physicsModel.getLaser(), null, this._canvas.getTrapForceNode(), this._canvas.getFluidDragForceNode(), null, this._canvas.getBeadNode(), this._canvas.getLaserNode());
        this._chartsControlPanel = new ChartsControlPanel(TITLE_FONT, CONTROL_FONT, frame, PhysicsDefaults.POSITION_HISTOGRAM_DIALOG_OFFSET, physicsModel.getClock(), physicsModel.getBead(), physicsModel.getLaser(), this._canvas.getPotentialEnergyChartNode(), this._canvas.getLaserNode());
        this._miscControlPanel = new MiscControlPanel(TITLE_FONT, CONTROL_FONT, frame, PhysicsDefaults.FLUID_CONTROLS_DIALOG_OFFSET, this._canvas.getRulerNode(), physicsModel.getFluid());
        this._developerControlPanel = new DeveloperControlPanel(TITLE_FONT, CONTROL_FONT, frame, (OTClock)physicsModule.getClock(), physicsModel.getBead(), null, physicsModel.getLaser(), null, null, null, null, this._canvas.getTrapForceNode(), this._canvas.getFluidDragForceNode(), null, this._canvas.getLaserNode().getElectricFieldNode(), this._canvas.getChargeDistributionNode(), true);
        this._forcesControlPanel.setShowValuesCheckBoxVisible(false);
        this._forcesControlPanel.setKeepTrapForceConstantCheckBoxVisible(false);
        this.addControlFullWidth(this._simulationSpeedControlPanel);
        this.addSeparator();
        this.addControlFullWidth(this._laserDisplayControlPanel);
        this.addSeparator();
        this.addControlFullWidth(this._chargeControlPanel);
        this.addSeparator();
        this.addControlFullWidth(this._forcesControlPanel);
        this.addSeparator();
        this.addControlFullWidth(this._chartsControlPanel);
        this.addSeparator();
        this.addControlFullWidth(this._miscControlPanel);
        this.addSeparator();
        if (PiccoloPhetApplication.getInstance().isDeveloperControlsEnabled()) {
            this.addControlFullWidth(this._developerControlPanel);
            this.addSeparator();
        }
        this.addResetAllButton(physicsModule);
    }

    public void closeAllDialogs() {
        this._chartsControlPanel.setPositionHistogramSelected(false);
        this._miscControlPanel.setFluidControlsSelected(false);
    }

    public DeveloperControlPanel getDeveloperControlPanel() {
        return this._developerControlPanel;
    }

    public SimulationSpeedControlPanel getSimulationSpeedControlPanel() {
        return this._simulationSpeedControlPanel;
    }

    public LaserDisplayControlPanel getLaserDisplayControlPanel() {
        return this._laserDisplayControlPanel;
    }

    public ChargeControlPanel getChargeControlPanel() {
        return this._chargeControlPanel;
    }

    public ForcesControlPanel getForcesControlPanel() {
        return this._forcesControlPanel;
    }

    public ChartsControlPanel getChartsControlPanel() {
        return this._chartsControlPanel;
    }

    public MiscControlPanel getMiscControlPanel() {
        return this._miscControlPanel;
    }
}

