/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.module.motors;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.piccolophet.help.HelpBalloon;
import edu.colorado.phet.common.piccolophet.help.HelpPane;
import edu.colorado.phet.opticaltweezers.OTResources;
import edu.colorado.phet.opticaltweezers.control.ChartsControlPanel;
import edu.colorado.phet.opticaltweezers.control.EnzymeControlPanel;
import edu.colorado.phet.opticaltweezers.control.ForcesControlPanel;
import edu.colorado.phet.opticaltweezers.control.MiscControlPanel;
import edu.colorado.phet.opticaltweezers.control.OTClockControlPanel;
import edu.colorado.phet.opticaltweezers.control.developer.DeveloperControlPanel;
import edu.colorado.phet.opticaltweezers.defaults.MotorsDefaults;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.DNAStrand;
import edu.colorado.phet.opticaltweezers.model.FixedObject;
import edu.colorado.phet.opticaltweezers.model.Fluid;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.MovableObject;
import edu.colorado.phet.opticaltweezers.model.OTClock;
import edu.colorado.phet.opticaltweezers.module.OTAbstractModel;
import edu.colorado.phet.opticaltweezers.module.OTAbstractModule;
import edu.colorado.phet.opticaltweezers.module.motors.MotorsCanvas;
import edu.colorado.phet.opticaltweezers.module.motors.MotorsControlPanel;
import edu.colorado.phet.opticaltweezers.module.motors.MotorsModel;
import edu.colorado.phet.opticaltweezers.persistence.MotorsConfig;
import edu.colorado.phet.opticaltweezers.view.DNAStrandNode;
import java.awt.Frame;
import java.util.Observer;

public class MotorsModule
extends OTAbstractModule {
    private MotorsModel _model;
    private MotorsCanvas _canvas;
    private MotorsControlPanel _controlPanel;
    private OTClockControlPanel _clockControlPanel;
    private boolean _fluidControlsWasSelected;
    private boolean _positionHistogramWasSelected;

    public MotorsModule(Frame frame) {
        super(OTResources.getString("title.molecularMotors"), MotorsDefaults.CLOCK);
        OTClock oTClock = (OTClock)this.getClock();
        this._model = new MotorsModel(oTClock);
        this._canvas = new MotorsCanvas(this._model);
        this.setSimulationPanel(this._canvas);
        this._controlPanel = new MotorsControlPanel(this, frame);
        this.setControlPanel(this._controlPanel);
        this._clockControlPanel = new OTClockControlPanel((OTClock)this.getClock());
        this._clockControlPanel.setTimeColumns(10);
        this.setClockControlPanel(this._clockControlPanel);
        if (this.hasHelp()) {
            HelpPane helpPane = this.getDefaultHelpPane();
            HelpBalloon helpBalloon = new HelpBalloon(helpPane, OTResources.getString("help.bead"), HelpBalloon.RIGHT_CENTER, 20.0);
            helpPane.add(helpBalloon);
            helpBalloon.pointAt(this._canvas.getBeadNode(), this._canvas);
            HelpBalloon helpBalloon2 = new HelpBalloon(helpPane, OTResources.getString("help.laser"), HelpBalloon.RIGHT_CENTER, 20.0);
            helpPane.add(helpBalloon2);
            helpBalloon2.pointAt(this._canvas.getLaserNode().getLeftHandleNode(), this._canvas);
            HelpBalloon helpBalloon3 = new HelpBalloon(helpPane, OTResources.getString("help.ruler"), HelpBalloon.TOP_CENTER, 20.0);
            helpPane.add(helpBalloon3);
            helpBalloon3.pointAt(this._canvas.getRulerNode(), this._canvas);
        }
        this.reset();
        this._fluidControlsWasSelected = this._controlPanel.getMiscControlPanel().isFluidControlsSelected();
        this._positionHistogramWasSelected = this._controlPanel.getChartsControlPanel().isPositionHistogramSelected();
    }

    public MotorsModel getMotorsModel() {
        return this._model;
    }

    public MotorsCanvas getMotorsCanvas() {
        return this._canvas;
    }

    public boolean hasHelp() {
        return true;
    }

    public void activate() {
        super.activate();
        this._controlPanel.getMiscControlPanel().setFluidControlsSelected(this._fluidControlsWasSelected);
        this._controlPanel.getChartsControlPanel().setPositionHistogramSelected(this._positionHistogramWasSelected);
    }

    public void deactivate() {
        this._fluidControlsWasSelected = this._controlPanel.getMiscControlPanel().isFluidControlsSelected();
        this._positionHistogramWasSelected = this._controlPanel.getChartsControlPanel().isPositionHistogramSelected();
        this._controlPanel.closeAllDialogs();
        super.deactivate();
    }

    public void reset() {
        Object object = this._model.getClock();
        ((OTClock)object).setDt(MotorsDefaults.DEFAULT_DT);
        this.setClockRunningWhenActive(true);
        Object object2 = this._model.getBead();
        ((MovableObject)object2).setPosition(MotorsDefaults.BEAD_POSITION);
        ((MovableObject)object2).setOrientation(MotorsDefaults.BEAD_ORIENTATION);
        ((Bead)object2).setDtSubdivisionThreshold(MotorsDefaults.BEAD_DT_SUBDIVISION_THRESHOLD_RANGE.getDefault());
        ((Bead)object2).setNumberOfDtSubdivisions(MotorsDefaults.BEAD_NUMBER_OF_DT_SUBDIVISIONS_RANGE.getDefault());
        ((Bead)object2).setBrownianMotionScale(MotorsDefaults.BEAD_BROWNIAN_MOTION_SCALE_RANGE.getDefault());
        ((Bead)object2).setBrownianMotionEnabled(true);
        ((Bead)object2).setVerletDtSubdivisionThreshold(MotorsDefaults.BEAD_VERLET_DT_SUBDIVISION_THRESHOLD_RANGE.getDefault());
        ((Bead)object2).setVerletNumberOfDtSubdivisions(MotorsDefaults.BEAD_VERLET_NUMBER_OF_DT_SUBDIVISIONS_RANGE.getDefault());
        ((Bead)object2).setVerletAccelerationScale(MotorsDefaults.BEAD_VERLET_ACCELERATION_SCALE_RANGE.getDefault());
        ((Bead)object2).setVacuumFastThreshold(MotorsDefaults.BEAD_VACUUM_FAST_THRESHOLD_RANGE.getDefault());
        ((Bead)object2).setVacuumFastDt(MotorsDefaults.BEAD_VACUUM_FAST_DT_RANGE.getDefault());
        ((Bead)object2).setVacuumFastPower(MotorsDefaults.BEAD_VACUUM_FAST_POWER_RANGE.getDefault());
        Object object3 = this._model.getInvisibleBead();
        ((MovableObject)object3).setPosition(MotorsDefaults.INVISIBLE_BEAD_POSITION);
        ((MovableObject)object3).setOrientation(MotorsDefaults.INVISIBLE_BEAD_ORIENTATION);
        ((Bead)object3).setDtSubdivisionThreshold(MotorsDefaults.INVISIBLE_BEAD_DT_SUBDIVISION_THRESHOLD_RANGE.getDefault());
        ((Bead)object3).setNumberOfDtSubdivisions(MotorsDefaults.INVISIBLE_BEAD_NUMBER_OF_DT_SUBDIVISIONS_RANGE.getDefault());
        ((Bead)object3).setBrownianMotionScale(MotorsDefaults.INVISIBLE_BEAD_BROWNIAN_MOTION_SCALE_RANGE.getDefault());
        ((Bead)object3).setBrownianMotionEnabled(true);
        ((Bead)object3).setVerletDtSubdivisionThreshold(MotorsDefaults.INVISIBLE_BEAD_VERLET_DT_SUBDIVISION_THRESHOLD_RANGE.getDefault());
        ((Bead)object3).setVerletNumberOfDtSubdivisions(MotorsDefaults.INVISIBLE_BEAD_VERLET_NUMBER_OF_DT_SUBDIVISIONS_RANGE.getDefault());
        ((Bead)object3).setVerletAccelerationScale(MotorsDefaults.INVISIBLE_BEAD_VERLET_ACCELERATION_SCALE_RANGE.getDefault());
        ((Bead)object3).setVacuumFastThreshold(MotorsDefaults.INVISIBLE_BEAD_VACUUM_FAST_THRESHOLD_RANGE.getDefault());
        ((Bead)object3).setVacuumFastDt(MotorsDefaults.INVISIBLE_BEAD_VACUUM_FAST_DT_RANGE.getDefault());
        ((Bead)object3).setVacuumFastPower(MotorsDefaults.INVISIBLE_BEAD_VACUUM_FAST_POWER_RANGE.getDefault());
        Object object4 = this._model.getLaser();
        ((MovableObject)object4).setPosition(MotorsDefaults.LASER_POSITION);
        ((Laser)object4).setPower(MotorsDefaults.LASER_POWER_RANGE.getDefault());
        ((Laser)object4).setRunning(true);
        ((Laser)object4).setTrapForceRatio(MotorsDefaults.LASER_TRAP_FORCE_RATIO.getDefault());
        ((Laser)object4).setElectricFieldScale(MotorsDefaults.LASER_ELECTRIC_FIELD_SCALE_RANGE.getDefault());
        Object object5 = this._model.getFluid();
        ((Fluid)object5).setATPConcentration(MotorsDefaults.FLUID_APT_CONCENTRATION_RANGE.getDefault());
        ((Fluid)object5).setSpeed(MotorsDefaults.FLUID_SPEED_RANGE.getDefault());
        ((Fluid)object5).setViscosity(MotorsDefaults.FLUID_VISCOSITY_RANGE.getDefault());
        ((Fluid)object5).setTemperature(MotorsDefaults.FLUID_TEMPERATURE_RANGE.getDefault());
        DNAStrand dNAStrand = this._model.getDNAStrandBead();
        dNAStrand.setContourLength(1809.75);
        dNAStrand.setSpringConstant(MotorsDefaults.DNA_SPRING_CONSTANT_RANGE.getDefault());
        dNAStrand.setDragCoefficient(MotorsDefaults.DNA_DRAG_COEFFICIENT_RANGE.getDefault());
        dNAStrand.setKickConstant(MotorsDefaults.DNA_KICK_CONSTANT_RANGE.getDefault());
        dNAStrand.setNumberOfEvolutionsPerClockTick(MotorsDefaults.DNA_NUMBER_OF_EVOLUTIONS_PER_CLOCK_STEP_RANGE.getDefault());
        dNAStrand.setEvolutionDt(MotorsDefaults.DNA_EVOLUTION_DT_RANGE.getDefault());
        dNAStrand.setFluidDragCoefficient(MotorsDefaults.DNA_FLUID_DRAG_COEFFICIENT_RANGE.getDefault());
        dNAStrand.initializePivots();
        DNAStrand dNAStrand2 = this._model.getDNAStrandFree();
        dNAStrand2.setContourLength(603.25);
        dNAStrand2.setSpringConstant(MotorsDefaults.DNA_SPRING_CONSTANT_RANGE.getDefault());
        dNAStrand2.setDragCoefficient(MotorsDefaults.DNA_DRAG_COEFFICIENT_RANGE.getDefault());
        dNAStrand2.setKickConstant(MotorsDefaults.DNA_KICK_CONSTANT_RANGE.getDefault());
        dNAStrand2.setNumberOfEvolutionsPerClockTick(MotorsDefaults.DNA_NUMBER_OF_EVOLUTIONS_PER_CLOCK_STEP_RANGE.getDefault());
        dNAStrand2.setEvolutionDt(MotorsDefaults.DNA_EVOLUTION_DT_RANGE.getDefault());
        dNAStrand2.setFluidDragCoefficient(MotorsDefaults.DNA_FLUID_DRAG_COEFFICIENT_RANGE.getDefault());
        dNAStrand2.initializePivots();
        this._model.getEnzymeA().setEnabled(true);
        this._model.getEnzymeB().setEnabled(false);
        this._model.resetDNA();
        object = this._canvas.getDNAStrandBeadNode();
        ((DNAStrandNode)object).setPivotsVisible(false);
        ((DNAStrandNode)object).setExtensionVisible(false);
        object2 = this._canvas.getDNAStrandFreeNode();
        ((DNAStrandNode)object2).setPivotsVisible(false);
        ((DNAStrandNode)object2).setExtensionVisible(false);
        this._controlPanel.getSimulationSpeedControlPanel().setSimulationSpeed(MotorsDefaults.DEFAULT_DT);
        object = this._controlPanel.getEnzymeControlPanel();
        ((EnzymeControlPanel)object).setEnzymeASelected(true);
        ((EnzymeControlPanel)object).setEnzymeBSelected(false);
        object2 = this._controlPanel.getForcesControlPanel();
        ((ForcesControlPanel)object2).setTrapForceSelected(false);
        ((ForcesControlPanel)object2).setDragForceSelected(false);
        ((ForcesControlPanel)object2).setDNAForceSelected(false);
        ((ForcesControlPanel)object2).setShowValuesSelected(false);
        ((ForcesControlPanel)object2).setKeepTrapForceConstantSelected(false);
        object3 = this._controlPanel.getChartsControlPanel();
        ((ChartsControlPanel)object3).setPositionHistogramSelected(false);
        ((ChartsControlPanel)object3).setPotentialEnergySelected(false);
        object4 = this._controlPanel.getMiscControlPanel();
        ((MiscControlPanel)object4).setRulerSelected(false);
        ((MiscControlPanel)object4).setFluidControlsSelected(false);
        object5 = this._controlPanel.getDeveloperControlPanel();
        ((DeveloperControlPanel)object5).getVectorsPanel().setComponentsVisible(false);
    }

    public MotorsConfig save() {
        MotorsConfig motorsConfig = new MotorsConfig();
        motorsConfig.setActive(this.isActive());
        Observer observer = this.getMotorsModel();
        Object object = ((OTAbstractModel)((Object)observer)).getClock();
        motorsConfig.setClockDt(((ConstantDtClock)object).getDt());
        motorsConfig.setClockRunning(this.getClockRunningWhenActive());
        Object object2 = ((MotorsModel)observer).getLaser();
        motorsConfig.setLaserX(((FixedObject)object2).getX());
        motorsConfig.setLaserRunning(((Laser)object2).isRunning());
        motorsConfig.setLaserPower(((Laser)object2).getPower());
        Object object3 = ((MotorsModel)observer).getBead();
        motorsConfig.setBeadX(((FixedObject)object3).getX());
        motorsConfig.setBeadY(((FixedObject)object3).getY());
        Fluid fluid = ((MotorsModel)observer).getFluid();
        motorsConfig.setFluidSpeed(fluid.getSpeed());
        motorsConfig.setFluidViscosity(fluid.getViscosity());
        motorsConfig.setFluidTemperature(fluid.getTemperature());
        observer = this._controlPanel.getEnzymeControlPanel();
        motorsConfig.setEnzymeASelected(((EnzymeControlPanel)observer).isEnzymeASelected());
        motorsConfig.setEnzymeBSelected(((EnzymeControlPanel)observer).isEnzymeBSelected());
        object = this._controlPanel.getForcesControlPanel();
        motorsConfig.setTrapForceSelected(((ForcesControlPanel)object).isTrapForceSelected());
        motorsConfig.setDragForceSelected(((ForcesControlPanel)object).isDragForceSelected());
        motorsConfig.setDnaForceSelected(((ForcesControlPanel)object).isDNAForceSelected());
        motorsConfig.setBrownianForceEnabled(((ForcesControlPanel)object).isBrownianMotionSelected());
        motorsConfig.setShowForceValuesSelected(((ForcesControlPanel)object).isShowValuesSelected());
        motorsConfig.setKeepTrapForceConstantSelected(((ForcesControlPanel)object).isKeepTrapForceConstantSelected());
        object2 = this._controlPanel.getChartsControlPanel();
        if (this.isActive()) {
            motorsConfig.setPositionHistogramSelected(((ChartsControlPanel)object2).isPositionHistogramSelected());
        } else {
            motorsConfig.setPositionHistogramSelected(this._positionHistogramWasSelected);
        }
        motorsConfig.setPotentialEnergySelected(((ChartsControlPanel)object2).isPotentialChartSelected());
        object3 = this._controlPanel.getMiscControlPanel();
        motorsConfig.setRulerSelected(((MiscControlPanel)object3).isRulerSelected());
        if (this.isActive()) {
            motorsConfig.setFluidControlsSelected(((MiscControlPanel)object3).isFluidControlsSelected());
        } else {
            motorsConfig.setFluidControlsSelected(this._fluidControlsWasSelected);
        }
        return motorsConfig;
    }

    public void load(MotorsConfig motorsConfig) {
        if (motorsConfig.isActive()) {
            PhetApplication.getInstance().setActiveModule(this);
        }
        Observer observer = this.getMotorsModel();
        Object object = ((OTAbstractModel)((Object)observer)).getClock();
        ((OTClock)object).setDt(motorsConfig.getClockDt());
        this.setClockRunningWhenActive(motorsConfig.isClockRunning());
        Object object2 = ((MotorsModel)observer).getLaser();
        ((MovableObject)object2).setPosition(motorsConfig.getLaserX(), ((FixedObject)object2).getY());
        ((Laser)object2).setRunning(motorsConfig.isLaserRunning());
        ((Laser)object2).setPower(motorsConfig.getLaserPower());
        Object object3 = ((MotorsModel)observer).getBead();
        ((MovableObject)object3).setPosition(motorsConfig.getBeadX(), motorsConfig.getBeadY());
        Fluid fluid = ((MotorsModel)observer).getFluid();
        fluid.setSpeed(motorsConfig.getFluidSpeed());
        fluid.setViscosity(motorsConfig.getFluidViscosity());
        fluid.setTemperature(motorsConfig.getFluidTemperature());
        observer = this._controlPanel.getEnzymeControlPanel();
        ((EnzymeControlPanel)observer).setEnzymeASelected(motorsConfig.isEnzymeASelected());
        ((EnzymeControlPanel)observer).setEnzymeBSelected(motorsConfig.isEnzymeBSelected());
        this._model.resetDNA();
        object = this._controlPanel.getForcesControlPanel();
        ((ForcesControlPanel)object).setTrapForceSelected(motorsConfig.isTrapForceSelected());
        ((ForcesControlPanel)object).setDragForceSelected(motorsConfig.isDragForceSelected());
        ((ForcesControlPanel)object).setDNAForceSelected(motorsConfig.isDnaForceSelected());
        ((ForcesControlPanel)object).setBrownianMotionSelected(motorsConfig.isBrownianForceEnabled());
        ((ForcesControlPanel)object).setShowValuesSelected(motorsConfig.isShowForceValuesSelected());
        ((ForcesControlPanel)object).setKeepTrapForceConstantSelected(motorsConfig.isKeepTrapForceConstantSelected());
        object2 = this._controlPanel.getChartsControlPanel();
        if (this.isActive()) {
            ((ChartsControlPanel)object2).setPositionHistogramSelected(motorsConfig.isPositionHistogramSelected());
        } else {
            this._positionHistogramWasSelected = motorsConfig.isPositionHistogramSelected();
        }
        ((ChartsControlPanel)object2).setPotentialEnergySelected(motorsConfig.isPotentialEnergySelected());
        object3 = this._controlPanel.getMiscControlPanel();
        ((MiscControlPanel)object3).setRulerSelected(motorsConfig.isRulerSelected());
        if (this.isActive()) {
            ((MiscControlPanel)object3).setFluidControlsSelected(motorsConfig.isFluidControlsSelected());
        } else {
            this._fluidControlsWasSelected = motorsConfig.isFluidControlsSelected();
        }
    }
}

