/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.module.motors;

import edu.colorado.phet.opticaltweezers.defaults.MotorsDefaults;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.DNAStrand;
import edu.colorado.phet.opticaltweezers.model.EnzymeA;
import edu.colorado.phet.opticaltweezers.model.EnzymeB;
import edu.colorado.phet.opticaltweezers.model.Fluid;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.LaserPositionController;
import edu.colorado.phet.opticaltweezers.model.MicroscopeSlide;
import edu.colorado.phet.opticaltweezers.model.OTClock;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.colorado.phet.opticaltweezers.module.OTAbstractModel;
import java.util.Observable;
import java.util.Observer;

public class MotorsModel
extends OTAbstractModel
implements Observer {
    private final Fluid _fluid = new Fluid(MotorsDefaults.FLUID_SPEED_RANGE, MotorsDefaults.FLUID_DIRECTION, MotorsDefaults.FLUID_VISCOSITY_RANGE, MotorsDefaults.FLUID_TEMPERATURE_RANGE, MotorsDefaults.FLUID_APT_CONCENTRATION_RANGE);
    private final MicroscopeSlide _microscopeSlide;
    private final Laser _laser;
    private final Bead _bead;
    private final Bead _invisibleBead;
    private final DNAStrand _dnaStrandBead;
    private final DNAStrand _dnaStrandFree;
    private final EnzymeA _enzymeA;
    private final EnzymeB _enzymeB;
    private final LaserPositionController _laserPositionController;
    private OTModelViewTransform _modelViewTransform;

    public MotorsModel(OTClock oTClock) {
        super(oTClock);
        this.addModelElement(this._fluid);
        this._microscopeSlide = new MicroscopeSlide(MotorsDefaults.MICROSCOPE_SLIDE_POSITION, MotorsDefaults.MICROSCOPE_SLIDE_ORIENTATION, 2000.0, 50.0);
        this.addModelElement(this._microscopeSlide);
        this._laser = new Laser(MotorsDefaults.LASER_POSITION, MotorsDefaults.LASER_ORIENTATION, 1800.0, 500.0, 1200.0, 200.0, 1064.0, 632.0, MotorsDefaults.LASER_POWER_RANGE, MotorsDefaults.LASER_TRAP_FORCE_RATIO, MotorsDefaults.LASER_ELECTRIC_FIELD_SCALE_RANGE, oTClock);
        this.addModelElement(this._laser);
        this._bead = new Bead(MotorsDefaults.BEAD_POSITION, MotorsDefaults.BEAD_ORIENTATION, 200.0, 1.05E-21, this._fluid, this._microscopeSlide, this._laser, MotorsDefaults.BEAD_BROWNIAN_MOTION_SCALE_RANGE, MotorsDefaults.BEAD_DT_SUBDIVISION_THRESHOLD_RANGE, MotorsDefaults.BEAD_NUMBER_OF_DT_SUBDIVISIONS_RANGE, MotorsDefaults.BEAD_VERLET_DT_SUBDIVISION_THRESHOLD_RANGE, MotorsDefaults.BEAD_VERLET_NUMBER_OF_DT_SUBDIVISIONS_RANGE, MotorsDefaults.BEAD_VERLET_ACCELERATION_SCALE_RANGE, MotorsDefaults.BEAD_VACUUM_FAST_THRESHOLD_RANGE, MotorsDefaults.BEAD_VACUUM_FAST_DT_RANGE, MotorsDefaults.BEAD_VACUUM_FAST_POWER_RANGE);
        this.addModelElement(this._bead);
        this._dnaStrandBead = new DNAStrand(MotorsDefaults.DNA_POSITION, 1809.75, 50.0, 63.5, 0.95, this._bead, this._fluid, oTClock, MotorsDefaults.DNA_REFERENCE_CLOCK_STEP, MotorsDefaults.DNA_SPRING_CONSTANT_RANGE, MotorsDefaults.DNA_DRAG_COEFFICIENT_RANGE, MotorsDefaults.DNA_KICK_CONSTANT_RANGE, MotorsDefaults.DNA_NUMBER_OF_EVOLUTIONS_PER_CLOCK_STEP_RANGE, MotorsDefaults.DNA_EVOLUTION_DT_RANGE, MotorsDefaults.DNA_FLUID_DRAG_COEFFICIENT_RANGE);
        this.addModelElement(this._dnaStrandBead);
        this._bead.attachTo(this._dnaStrandBead);
        this._invisibleBead = new Bead(MotorsDefaults.INVISIBLE_BEAD_POSITION, MotorsDefaults.INVISIBLE_BEAD_ORIENTATION, 100.0, 1.05E-21, this._fluid, this._microscopeSlide, null, MotorsDefaults.INVISIBLE_BEAD_BROWNIAN_MOTION_SCALE_RANGE, MotorsDefaults.INVISIBLE_BEAD_DT_SUBDIVISION_THRESHOLD_RANGE, MotorsDefaults.INVISIBLE_BEAD_NUMBER_OF_DT_SUBDIVISIONS_RANGE, MotorsDefaults.INVISIBLE_BEAD_VERLET_DT_SUBDIVISION_THRESHOLD_RANGE, MotorsDefaults.INVISIBLE_BEAD_VERLET_NUMBER_OF_DT_SUBDIVISIONS_RANGE, MotorsDefaults.INVISIBLE_BEAD_VERLET_ACCELERATION_SCALE_RANGE, MotorsDefaults.INVISIBLE_BEAD_VACUUM_FAST_THRESHOLD_RANGE, MotorsDefaults.INVISIBLE_BEAD_VACUUM_FAST_DT_RANGE, MotorsDefaults.INVISIBLE_BEAD_VACUUM_FAST_POWER_RANGE);
        this.addModelElement(this._invisibleBead);
        this._dnaStrandFree = new DNAStrand(MotorsDefaults.DNA_POSITION, 603.25, 50.0, 63.5, 0.95, this._invisibleBead, this._fluid, oTClock, MotorsDefaults.DNA_REFERENCE_CLOCK_STEP, MotorsDefaults.DNA_SPRING_CONSTANT_RANGE, MotorsDefaults.DNA_DRAG_COEFFICIENT_RANGE, MotorsDefaults.DNA_KICK_CONSTANT_RANGE, MotorsDefaults.DNA_NUMBER_OF_EVOLUTIONS_PER_CLOCK_STEP_RANGE, MotorsDefaults.DNA_EVOLUTION_DT_RANGE, MotorsDefaults.DNA_FLUID_DRAG_COEFFICIENT_RANGE);
        this.addModelElement(this._dnaStrandFree);
        this._invisibleBead.attachTo(this._dnaStrandFree);
        this._enzymeA = new EnzymeA(MotorsDefaults.ENZYME_POSITION, 150.0, 75.0, this._dnaStrandBead, this._dnaStrandFree, this._fluid, oTClock.getFastRange().getMax());
        this._enzymeA.setEnabled(true);
        this._enzymeA.addObserver(this);
        this.addModelElement(this._enzymeA);
        this._enzymeB = new EnzymeB(MotorsDefaults.ENZYME_POSITION, 150.0, 75.0, this._dnaStrandBead, this._dnaStrandFree, this._fluid, oTClock.getFastRange().getMax());
        this._enzymeB.setEnabled(!this._enzymeA.isEnabled());
        this._enzymeB.addObserver(this);
        this.addModelElement(this._enzymeB);
        this._laserPositionController = new LaserPositionController(this._laser, this._dnaStrandBead);
        this.addModelElement(this._laserPositionController);
        this._modelViewTransform = new OTModelViewTransform(0.25);
        this.resetDNA();
    }

    public Fluid getFluid() {
        return this._fluid;
    }

    public MicroscopeSlide getMicroscopeSlide() {
        return this._microscopeSlide;
    }

    public Laser getLaser() {
        return this._laser;
    }

    public Bead getBead() {
        return this._bead;
    }

    public Bead getInvisibleBead() {
        return this._invisibleBead;
    }

    public DNAStrand getDNAStrandBead() {
        return this._dnaStrandBead;
    }

    public DNAStrand getDNAStrandFree() {
        return this._dnaStrandFree;
    }

    public EnzymeA getEnzymeA() {
        return this._enzymeA;
    }

    public EnzymeB getEnzymeB() {
        return this._enzymeB;
    }

    public LaserPositionController getLaserPositionController() {
        return this._laserPositionController;
    }

    public OTModelViewTransform getModelViewTransform() {
        return this._modelViewTransform;
    }

    public void resetDNA() {
        this._dnaStrandBead.setContourLength(1809.75);
        this._dnaStrandFree.setContourLength(603.25);
        this._bead.setPosition(MotorsDefaults.BEAD_POSITION);
        this._invisibleBead.setPosition(MotorsDefaults.INVISIBLE_BEAD_POSITION);
        if (this._enzymeA.isEnabled()) {
            this._dnaStrandBead.attachEnzyme(this._enzymeA);
        } else if (this._enzymeB.isEnabled()) {
            this._dnaStrandBead.attachEnzyme(this._enzymeB);
        } else {
            this._dnaStrandBead.attachEnzyme(null);
        }
    }

    public void update(Observable observable, Object object) {
        if ((observable == this._enzymeA || observable == this._enzymeB) && object == "enabled") {
            this.resetDNA();
        }
    }
}

