/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.module.dna;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.piccolophet.help.HelpBalloon;
import edu.colorado.phet.common.piccolophet.help.HelpPane;
import edu.colorado.phet.opticaltweezers.OTResources;
import edu.colorado.phet.opticaltweezers.control.ChartsControlPanel;
import edu.colorado.phet.opticaltweezers.control.ForcesControlPanel;
import edu.colorado.phet.opticaltweezers.control.MiscControlPanel;
import edu.colorado.phet.opticaltweezers.control.OTClockControlPanel;
import edu.colorado.phet.opticaltweezers.control.developer.DeveloperControlPanel;
import edu.colorado.phet.opticaltweezers.defaults.DNADefaults;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.DNAStrand;
import edu.colorado.phet.opticaltweezers.model.FixedObject;
import edu.colorado.phet.opticaltweezers.model.Fluid;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.MovableObject;
import edu.colorado.phet.opticaltweezers.model.OTClock;
import edu.colorado.phet.opticaltweezers.module.OTAbstractModel;
import edu.colorado.phet.opticaltweezers.module.OTAbstractModule;
import edu.colorado.phet.opticaltweezers.module.dna.DNACanvas;
import edu.colorado.phet.opticaltweezers.module.dna.DNAControlPanel;
import edu.colorado.phet.opticaltweezers.module.dna.DNAModel;
import edu.colorado.phet.opticaltweezers.persistence.DNAConfig;
import edu.colorado.phet.opticaltweezers.view.DNAStrandNode;
import java.awt.Frame;

public class DNAModule
extends OTAbstractModule {
    private DNAModel _model;
    private DNACanvas _canvas;
    private DNAControlPanel _controlPanel;
    private OTClockControlPanel _clockControlPanel;
    private boolean _fluidControlsWasSelected;
    private boolean _positionHistogramWasSelected;

    public DNAModule(Frame frame) {
        super(OTResources.getString("title.funWithDNA"), DNADefaults.CLOCK);
        OTClock oTClock = (OTClock)this.getClock();
        this._model = new DNAModel(oTClock);
        this._canvas = new DNACanvas(this._model);
        this.setSimulationPanel(this._canvas);
        this._controlPanel = new DNAControlPanel(this, frame);
        this.setControlPanel(this._controlPanel);
        this._clockControlPanel = new OTClockControlPanel((OTClock)this.getClock());
        this._clockControlPanel.setTimeColumns(10);
        this.setClockControlPanel(this._clockControlPanel);
        if (this.hasHelp()) {
            HelpPane helpPane = this.getDefaultHelpPane();
            HelpBalloon helpBalloon = new HelpBalloon(helpPane, OTResources.getString("help.bead"), HelpBalloon.RIGHT_CENTER, 20.0);
            helpPane.add(helpBalloon);
            helpBalloon.pointAt(this._canvas.getBeadNode(), this._canvas);
            HelpBalloon helpBalloon2 = new HelpBalloon(helpPane, OTResources.getString("help.laser"), HelpBalloon.RIGHT_CENTER, 20.0);
            helpPane.add(helpBalloon2);
            helpBalloon2.pointAt(this._canvas.getLaserNode().getLeftHandleNode(), this._canvas);
            HelpBalloon helpBalloon3 = new HelpBalloon(helpPane, OTResources.getString("help.ruler"), HelpBalloon.TOP_CENTER, 20.0);
            helpPane.add(helpBalloon3);
            helpBalloon3.pointAt(this._canvas.getRulerNode(), this._canvas);
        }
        this.reset();
        this._fluidControlsWasSelected = this._controlPanel.getMiscControlPanel().isFluidControlsSelected();
        this._positionHistogramWasSelected = this._controlPanel.getChartsControlPanel().isPositionHistogramSelected();
    }

    public DNAModel getDNAModel() {
        return this._model;
    }

    public DNACanvas getDNACanvas() {
        return this._canvas;
    }

    public boolean hasHelp() {
        return true;
    }

    public void activate() {
        super.activate();
        this._controlPanel.getMiscControlPanel().setFluidControlsSelected(this._fluidControlsWasSelected);
        this._controlPanel.getChartsControlPanel().setPositionHistogramSelected(this._positionHistogramWasSelected);
    }

    public void deactivate() {
        this._fluidControlsWasSelected = this._controlPanel.getMiscControlPanel().isFluidControlsSelected();
        this._positionHistogramWasSelected = this._controlPanel.getChartsControlPanel().isPositionHistogramSelected();
        this._controlPanel.closeAllDialogs();
        super.deactivate();
    }

    public void reset() {
        Object object = this._model.getClock();
        ((OTClock)object).setDt(DNADefaults.DEFAULT_DT);
        this.setClockRunningWhenActive(true);
        Object object2 = this._model.getBead();
        ((MovableObject)object2).setPosition(DNADefaults.BEAD_POSITION);
        ((MovableObject)object2).setOrientation(DNADefaults.BEAD_ORIENTATION);
        ((Bead)object2).setDtSubdivisionThreshold(DNADefaults.BEAD_DT_SUBDIVISION_THRESHOLD_RANGE.getDefault());
        ((Bead)object2).setNumberOfDtSubdivisions(DNADefaults.BEAD_NUMBER_OF_DT_SUBDIVISIONS_RANGE.getDefault());
        ((Bead)object2).setBrownianMotionScale(DNADefaults.BEAD_BROWNIAN_MOTION_SCALE_RANGE.getDefault());
        ((Bead)object2).setBrownianMotionEnabled(true);
        ((Bead)object2).setVerletDtSubdivisionThreshold(DNADefaults.BEAD_VERLET_DT_SUBDIVISION_THRESHOLD_RANGE.getDefault());
        ((Bead)object2).setVerletNumberOfDtSubdivisions(DNADefaults.BEAD_VERLET_NUMBER_OF_DT_SUBDIVISIONS_RANGE.getDefault());
        ((Bead)object2).setVerletAccelerationScale(DNADefaults.BEAD_VERLET_ACCELERATION_SCALE_RANGE.getDefault());
        ((Bead)object2).setVacuumFastThreshold(DNADefaults.BEAD_VACUUM_FAST_THRESHOLD_RANGE.getDefault());
        ((Bead)object2).setVacuumFastDt(DNADefaults.BEAD_VACUUM_FAST_DT_RANGE.getDefault());
        ((Bead)object2).setVacuumFastPower(DNADefaults.BEAD_VACUUM_FAST_POWER_RANGE.getDefault());
        Object object3 = this._model.getLaser();
        ((MovableObject)object3).setPosition(DNADefaults.LASER_POSITION);
        ((Laser)object3).setPower(DNADefaults.LASER_POWER_RANGE.getDefault());
        ((Laser)object3).setRunning(true);
        ((Laser)object3).setTrapForceRatio(DNADefaults.LASER_TRAP_FORCE_RATIO.getDefault());
        ((Laser)object3).setElectricFieldScale(DNADefaults.LASER_ELECTRIC_FIELD_SCALE_RANGE.getDefault());
        Object object4 = this._model.getFluid();
        ((Fluid)object4).setSpeed(DNADefaults.FLUID_SPEED_RANGE.getDefault());
        ((Fluid)object4).setViscosity(DNADefaults.FLUID_VISCOSITY_RANGE.getDefault());
        ((Fluid)object4).setTemperature(DNADefaults.FLUID_TEMPERATURE_RANGE.getDefault());
        DNAStrand dNAStrand = this._model.getDNAStrand();
        dNAStrand.setSpringConstant(DNADefaults.DNA_SPRING_CONSTANT_RANGE.getDefault());
        dNAStrand.setDragCoefficient(DNADefaults.DNA_DRAG_COEFFICIENT_RANGE.getDefault());
        dNAStrand.setKickConstant(DNADefaults.DNA_KICK_CONSTANT_RANGE.getDefault());
        dNAStrand.setNumberOfEvolutionsPerClockTick(DNADefaults.DNA_NUMBER_OF_EVOLUTIONS_PER_CLOCK_STEP_RANGE.getDefault());
        dNAStrand.setEvolutionDt(DNADefaults.DNA_EVOLUTION_DT_RANGE.getDefault());
        dNAStrand.setFluidDragCoefficient(DNADefaults.DNA_FLUID_DRAG_COEFFICIENT_RANGE.getDefault());
        dNAStrand.initializePivots();
        object = this._canvas.getDNAStrandNode();
        ((DNAStrandNode)object).setPivotsVisible(false);
        ((DNAStrandNode)object).setExtensionVisible(false);
        this._controlPanel.getSimulationSpeedControlPanel().setSimulationSpeed(DNADefaults.DEFAULT_DT);
        object = this._controlPanel.getForcesControlPanel();
        ((ForcesControlPanel)object).setTrapForceSelected(false);
        ((ForcesControlPanel)object).setDragForceSelected(false);
        ((ForcesControlPanel)object).setDNAForceSelected(false);
        ((ForcesControlPanel)object).setShowValuesSelected(false);
        object2 = this._controlPanel.getChartsControlPanel();
        ((ChartsControlPanel)object2).setPositionHistogramSelected(false);
        ((ChartsControlPanel)object2).setPotentialEnergySelected(false);
        object3 = this._controlPanel.getMiscControlPanel();
        ((MiscControlPanel)object3).setRulerSelected(false);
        ((MiscControlPanel)object3).setFluidControlsSelected(false);
        object4 = this._controlPanel.getDeveloperControlPanel();
        ((DeveloperControlPanel)object4).getVectorsPanel().setComponentsVisible(false);
    }

    public DNAConfig save() {
        DNAConfig dNAConfig = new DNAConfig();
        dNAConfig.setActive(this.isActive());
        Object object = this.getDNAModel();
        Object object2 = ((OTAbstractModel)object).getClock();
        dNAConfig.setClockDt(((ConstantDtClock)object2).getDt());
        dNAConfig.setClockRunning(this.getClockRunningWhenActive());
        Object object3 = ((DNAModel)object).getLaser();
        dNAConfig.setLaserX(((FixedObject)object3).getX());
        dNAConfig.setLaserRunning(((Laser)object3).isRunning());
        dNAConfig.setLaserPower(((Laser)object3).getPower());
        Bead bead = ((DNAModel)object).getBead();
        dNAConfig.setBeadX(bead.getX());
        dNAConfig.setBeadY(bead.getY());
        Fluid fluid = ((DNAModel)object).getFluid();
        dNAConfig.setFluidSpeed(fluid.getSpeed());
        dNAConfig.setFluidViscosity(fluid.getViscosity());
        dNAConfig.setFluidTemperature(fluid.getTemperature());
        object = this._controlPanel.getForcesControlPanel();
        dNAConfig.setTrapForceSelected(((ForcesControlPanel)object).isTrapForceSelected());
        dNAConfig.setDragForceSelected(((ForcesControlPanel)object).isDragForceSelected());
        dNAConfig.setDnaForceSelected(((ForcesControlPanel)object).isDNAForceSelected());
        dNAConfig.setBrownianForceEnabled(((ForcesControlPanel)object).isBrownianMotionSelected());
        dNAConfig.setShowForceValuesSelected(((ForcesControlPanel)object).isShowValuesSelected());
        object2 = this._controlPanel.getChartsControlPanel();
        if (this.isActive()) {
            dNAConfig.setPositionHistogramSelected(((ChartsControlPanel)object2).isPositionHistogramSelected());
        } else {
            dNAConfig.setPositionHistogramSelected(this._positionHistogramWasSelected);
        }
        dNAConfig.setPotentialEnergySelected(((ChartsControlPanel)object2).isPotentialChartSelected());
        object3 = this._controlPanel.getMiscControlPanel();
        dNAConfig.setRulerSelected(((MiscControlPanel)object3).isRulerSelected());
        if (this.isActive()) {
            dNAConfig.setFluidControlsSelected(((MiscControlPanel)object3).isFluidControlsSelected());
        } else {
            dNAConfig.setFluidControlsSelected(this._fluidControlsWasSelected);
        }
        return dNAConfig;
    }

    public void load(DNAConfig dNAConfig) {
        if (dNAConfig.isActive()) {
            PhetApplication.getInstance().setActiveModule(this);
        }
        Object object = this.getDNAModel();
        Object object2 = ((OTAbstractModel)object).getClock();
        ((OTClock)object2).setDt(dNAConfig.getClockDt());
        this.setClockRunningWhenActive(dNAConfig.isClockRunning());
        Object object3 = ((DNAModel)object).getLaser();
        ((MovableObject)object3).setPosition(dNAConfig.getLaserX(), ((FixedObject)object3).getY());
        ((Laser)object3).setRunning(dNAConfig.isLaserRunning());
        ((Laser)object3).setPower(dNAConfig.getLaserPower());
        Bead bead = ((DNAModel)object).getBead();
        bead.setPosition(dNAConfig.getBeadX(), dNAConfig.getBeadY());
        Fluid fluid = ((DNAModel)object).getFluid();
        fluid.setSpeed(dNAConfig.getFluidSpeed());
        fluid.setViscosity(dNAConfig.getFluidViscosity());
        fluid.setTemperature(dNAConfig.getFluidTemperature());
        object = this._controlPanel.getForcesControlPanel();
        ((ForcesControlPanel)object).setTrapForceSelected(dNAConfig.isTrapForceSelected());
        ((ForcesControlPanel)object).setDragForceSelected(dNAConfig.isDragForceSelected());
        ((ForcesControlPanel)object).setDNAForceSelected(dNAConfig.isDnaForceSelected());
        ((ForcesControlPanel)object).setBrownianMotionSelected(dNAConfig.isBrownianForceEnabled());
        ((ForcesControlPanel)object).setShowValuesSelected(dNAConfig.isShowForceValuesSelected());
        object2 = this._controlPanel.getChartsControlPanel();
        if (this.isActive()) {
            ((ChartsControlPanel)object2).setPositionHistogramSelected(dNAConfig.isPositionHistogramSelected());
        } else {
            this._positionHistogramWasSelected = dNAConfig.isPositionHistogramSelected();
        }
        ((ChartsControlPanel)object2).setPotentialEnergySelected(dNAConfig.isPotentialEnergySelected());
        object3 = this._controlPanel.getMiscControlPanel();
        ((MiscControlPanel)object3).setRulerSelected(dNAConfig.isRulerSelected());
        if (this.isActive()) {
            ((MiscControlPanel)object3).setFluidControlsSelected(dNAConfig.isFluidControlsSelected());
        } else {
            this._fluidControlsWasSelected = dNAConfig.isFluidControlsSelected();
        }
    }
}

