/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.module.dna;

import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.opticaltweezers.control.ChartsControlPanel;
import edu.colorado.phet.opticaltweezers.control.ForcesControlPanel;
import edu.colorado.phet.opticaltweezers.control.MiscControlPanel;
import edu.colorado.phet.opticaltweezers.control.SimulationSpeedControlPanel;
import edu.colorado.phet.opticaltweezers.control.developer.DeveloperControlPanel;
import edu.colorado.phet.opticaltweezers.defaults.DNADefaults;
import edu.colorado.phet.opticaltweezers.model.OTClock;
import edu.colorado.phet.opticaltweezers.module.OTAbstractControlPanel;
import edu.colorado.phet.opticaltweezers.module.dna.DNACanvas;
import edu.colorado.phet.opticaltweezers.module.dna.DNAModel;
import edu.colorado.phet.opticaltweezers.module.dna.DNAModule;
import java.awt.Frame;

public class DNAControlPanel
extends OTAbstractControlPanel {
    private DNACanvas _canvas;
    private SimulationSpeedControlPanel _simulationSpeedControlPanel;
    private ForcesControlPanel _forcesControlPanel;
    private ChartsControlPanel _chartsControlPanel;
    private MiscControlPanel _miscControlPanel;
    private DeveloperControlPanel _developerControlPanel;

    public DNAControlPanel(DNAModule dNAModule, Frame frame) {
        super(dNAModule);
        this._canvas = dNAModule.getDNACanvas();
        DNAModel dNAModel = dNAModule.getDNAModel();
        this._simulationSpeedControlPanel = new SimulationSpeedControlPanel(TITLE_FONT, CONTROL_FONT, dNAModel.getClock());
        this._forcesControlPanel = new ForcesControlPanel(TITLE_FONT, CONTROL_FONT, dNAModel.getBead(), dNAModel.getFluid(), dNAModel.getLaser(), null, this._canvas.getTrapForceNode(), this._canvas.getFluidDragForceNode(), this._canvas.getDNAForceNode(), this._canvas.getBeadNode(), this._canvas.getLaserNode());
        this._chartsControlPanel = new ChartsControlPanel(TITLE_FONT, CONTROL_FONT, frame, DNADefaults.POSITION_HISTOGRAM_DIALOG_OFFSET, dNAModel.getClock(), dNAModel.getBead(), dNAModel.getLaser(), this._canvas.getPotentialEnergyChartNode(), this._canvas.getLaserNode());
        this._miscControlPanel = new MiscControlPanel(TITLE_FONT, CONTROL_FONT, frame, DNADefaults.FLUID_CONTROLS_DIALOG_OFFSET, this._canvas.getRulerNode(), dNAModel.getFluid());
        this._developerControlPanel = new DeveloperControlPanel(TITLE_FONT, CONTROL_FONT, frame, (OTClock)dNAModule.getClock(), dNAModel.getBead(), null, dNAModel.getLaser(), dNAModel.getDNAStrand(), this._canvas.getDNAStrandNode(), null, null, this._canvas.getTrapForceNode(), this._canvas.getFluidDragForceNode(), this._canvas.getDNAForceNode(), null, null, false);
        this._forcesControlPanel.setKeepTrapForceConstantCheckBoxVisible(false);
        this._miscControlPanel.setFluidVacuumPanelVisible(false);
        this.addControlFullWidth(this._simulationSpeedControlPanel);
        this.addSeparator();
        this.addControlFullWidth(this._forcesControlPanel);
        this.addSeparator();
        this.addControlFullWidth(this._chartsControlPanel);
        this.addSeparator();
        this.addControlFullWidth(this._miscControlPanel);
        this.addSeparator();
        if (PiccoloPhetApplication.getInstance().isDeveloperControlsEnabled()) {
            this.addControlFullWidth(this._developerControlPanel);
            this.addSeparator();
        }
        this.addResetAllButton(dNAModule);
    }

    public void closeAllDialogs() {
        this._chartsControlPanel.setPositionHistogramSelected(false);
        this._miscControlPanel.setFluidControlsSelected(false);
    }

    public DeveloperControlPanel getDeveloperControlPanel() {
        return this._developerControlPanel;
    }

    public SimulationSpeedControlPanel getSimulationSpeedControlPanel() {
        return this._simulationSpeedControlPanel;
    }

    public ForcesControlPanel getForcesControlPanel() {
        return this._forcesControlPanel;
    }

    public ChartsControlPanel getChartsControlPanel() {
        return this._chartsControlPanel;
    }

    public MiscControlPanel getMiscControlPanel() {
        return this._miscControlPanel;
    }
}

