/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.module.dna;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.OTResources;
import edu.colorado.phet.opticaltweezers.charts.PotentialEnergyChartNode;
import edu.colorado.phet.opticaltweezers.defaults.DNADefaults;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.DNAStrand;
import edu.colorado.phet.opticaltweezers.model.Fluid;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.MicroscopeSlide;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.colorado.phet.opticaltweezers.module.OTAbstractCanvas;
import edu.colorado.phet.opticaltweezers.module.dna.DNAModel;
import edu.colorado.phet.opticaltweezers.view.BeadNode;
import edu.colorado.phet.opticaltweezers.view.DNAForceNode;
import edu.colorado.phet.opticaltweezers.view.DNAStrandNode;
import edu.colorado.phet.opticaltweezers.view.FluidDragForceNode;
import edu.colorado.phet.opticaltweezers.view.LaserNode;
import edu.colorado.phet.opticaltweezers.view.MicroscopeSlideNode;
import edu.colorado.phet.opticaltweezers.view.OTRulerNode;
import edu.colorado.phet.opticaltweezers.view.PushpinNode;
import edu.colorado.phet.opticaltweezers.view.TrapForceNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;

public class DNACanvas
extends OTAbstractCanvas {
    private DNAModel _model;
    private MicroscopeSlideNode _microscopeSlideNode;
    private LaserNode _laserNode;
    private DNAStrandNode _dnaStrandNode;
    private BeadNode _beadNode;
    private PPath _beadDragBoundsNode;
    private PPath _laserDragBoundsNode;
    private OTRulerNode _rulerNode;
    private PPath _rulerDragBoundsNode;
    private PotentialEnergyChartNode _potentialEnergyChartNode;
    private TrapForceNode _trapForceNode;
    private FluidDragForceNode _dragForceNode;
    private DNAForceNode _dnaForceNode;
    private PSwing _returnBeadButtonWrapper;

    public DNACanvas(DNAModel dNAModel) {
        super(DNADefaults.VIEW_SIZE);
        this._model = dNAModel;
        Fluid fluid = dNAModel.getFluid();
        MicroscopeSlide microscopeSlide = dNAModel.getMicroscopeSlide();
        Laser laser = dNAModel.getLaser();
        DNAStrand dNAStrand = dNAModel.getDNAStrand();
        Bead bead = dNAModel.getBead();
        OTModelViewTransform oTModelViewTransform = dNAModel.getModelViewTransform();
        this.setBackground(OTConstants.CANVAS_BACKGROUND);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DNACanvas.this.updateReturnBeadButtonVisibility();
            }
        });
        this._microscopeSlideNode = new MicroscopeSlideNode(microscopeSlide, fluid, oTModelViewTransform, DNADefaults.FLUID_SPEED_RANGE.getMax());
        this._laserDragBoundsNode = new PPath();
        this._laserDragBoundsNode.setStroke(null);
        this._laserNode = new LaserNode(laser, oTModelViewTransform, (PNode)this._laserDragBoundsNode);
        this._laserNode.setElectricFieldVisible(false);
        this._dnaStrandNode = new DNAStrandNode(dNAStrand, oTModelViewTransform);
        PushpinNode pushpinNode = new PushpinNode();
        Point2D.Double double_ = new Point2D.Double(dNAStrand.getPinX(), dNAStrand.getPinY());
        Point2D point2D = oTModelViewTransform.modelToView(double_);
        pushpinNode.setOffset(point2D);
        this._beadDragBoundsNode = new PPath();
        this._beadDragBoundsNode.setStroke(null);
        this._beadNode = new BeadNode(bead, oTModelViewTransform, (PNode)this._beadDragBoundsNode);
        this._beadNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("transform")) {
                    DNACanvas.this.updateReturnBeadButtonVisibility();
                }
            }
        });
        double d = laser.getMaxTrapForce().getMagnitude();
        this._trapForceNode = new TrapForceNode(laser, bead, oTModelViewTransform, d, 125.0);
        this._dragForceNode = new FluidDragForceNode(fluid, bead, oTModelViewTransform, d, 125.0);
        this._dnaForceNode = new DNAForceNode(bead, dNAStrand, fluid, oTModelViewTransform, d, 125.0);
        this._rulerDragBoundsNode = new PPath();
        this._rulerDragBoundsNode.setStroke(null);
        this._rulerNode = new OTRulerNode(200, 3, laser, dNAModel.getModelViewTransform(), this._rulerDragBoundsNode);
        this._rulerNode.setOffset(0.0, oTModelViewTransform.modelToView(DNADefaults.RULER_Y_POSITION));
        this._potentialEnergyChartNode = new PotentialEnergyChartNode(bead, laser, oTModelViewTransform, 5.0);
        JButton jButton = new JButton(OTResources.getString("button.returnBead"));
        PhetFont phetFont = new PhetFont(1, 18);
        jButton.setFont(phetFont);
        jButton.setOpaque(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DNACanvas.this.handleReturnBeadButton();
            }
        });
        this._returnBeadButtonWrapper = new PSwing(jButton);
        this.addNode(this._microscopeSlideNode);
        this.addNode(this._laserNode);
        this.addNode(this._laserDragBoundsNode);
        this.addNode(this._beadNode);
        this.addNode(this._dnaStrandNode);
        this.addNode(pushpinNode);
        this.addNode(this._beadDragBoundsNode);
        this.addNode(this._trapForceNode);
        this.addNode(this._dragForceNode);
        this.addNode(this._dnaForceNode);
        this.addNode(this._potentialEnergyChartNode);
        this.addNode(this._rulerNode);
        this.addNode(this._rulerDragBoundsNode);
        this.addNode(this._returnBeadButtonWrapper);
    }

    public BeadNode getBeadNode() {
        return this._beadNode;
    }

    public LaserNode getLaserNode() {
        return this._laserNode;
    }

    public PotentialEnergyChartNode getPotentialEnergyChartNode() {
        return this._potentialEnergyChartNode;
    }

    public OTRulerNode getRulerNode() {
        return this._rulerNode;
    }

    public TrapForceNode getTrapForceNode() {
        return this._trapForceNode;
    }

    public FluidDragForceNode getFluidDragForceNode() {
        return this._dragForceNode;
    }

    public DNAForceNode getDNAForceNode() {
        return this._dnaForceNode;
    }

    public DNAStrandNode getDNAStrandNode() {
        return this._dnaStrandNode;
    }

    protected void updateLayout() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        Dimension2D dimension2D = this.getWorldSize();
        if (dimension2D.getWidth() <= 0.0 || dimension2D.getHeight() <= 0.0) {
            return;
        }
        this._microscopeSlideNode.setWorldSize(dimension2D);
        this._rulerNode.setWorldSize(dimension2D);
        this._potentialEnergyChartNode.setChartSize(dimension2D.getWidth(), 200.0);
        Rectangle2D rectangle2D = this._microscopeSlideNode.getCenterGlobalBounds();
        PBounds pBounds = this._beadNode.getGlobalFullBounds();
        d = rectangle2D.getX() - 0.85 * ((RectangularShape)pBounds).getWidth();
        d2 = rectangle2D.getY();
        d3 = rectangle2D.getWidth() + 1.7 * ((RectangularShape)pBounds).getWidth();
        d4 = rectangle2D.getHeight();
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        Rectangle2D rectangle2D2 = this._beadDragBoundsNode.globalToLocal(double_);
        this._beadDragBoundsNode.setPathTo(rectangle2D2);
        PBounds pBounds2 = this._returnBeadButtonWrapper.getFullBoundsReference();
        d = (dimension2D.getWidth() - pBounds2.getWidth()) / 2.0;
        d2 = (dimension2D.getHeight() - pBounds2.getHeight()) / 2.0;
        this._returnBeadButtonWrapper.setOffset(d, d2);
        rectangle2D = this._microscopeSlideNode.getCenterGlobalBounds();
        pBounds = this._laserNode.getGlobalFullBounds();
        double d5 = 0.85 * ((RectangularShape)pBounds).getWidth();
        d = -d5;
        d2 = ((RectangularShape)pBounds).getY();
        d3 = rectangle2D.getWidth() + 2.0 * d5;
        d4 = ((RectangularShape)pBounds).getHeight();
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d, d2, d3, d4);
        Rectangle2D rectangle2D3 = this._laserDragBoundsNode.globalToLocal(double_2);
        this._laserDragBoundsNode.setPathTo(rectangle2D3);
        Laser laser = this._model.getLaser();
        Rectangle2D.Double double_3 = new Rectangle2D.Double(0.0, 0.0, dimension2D.getWidth(), dimension2D.getHeight());
        PBounds pBounds3 = this._laserNode.getFullBoundsReference();
        if (!double_3.intersects(pBounds3)) {
            OTModelViewTransform oTModelViewTransform = this._model.getModelViewTransform();
            double d6 = oTModelViewTransform.viewToModel(dimension2D.getWidth() / 2.0);
            double d7 = laser.getPositionReference().getY();
            laser.setPosition(d6, d7);
        }
    }

    private void updateReturnBeadButtonVisibility() {
        PBounds pBounds;
        Dimension2D dimension2D = this.getWorldSize();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, dimension2D.getWidth(), dimension2D.getHeight());
        this._returnBeadButtonWrapper.setVisible(!double_.intersects(pBounds = this._beadNode.getFullBoundsReference()));
        this._returnBeadButtonWrapper.setPickable(this._returnBeadButtonWrapper.getVisible());
        this._returnBeadButtonWrapper.setChildrenPickable(this._returnBeadButtonWrapper.getVisible());
    }

    private void handleReturnBeadButton() {
        PBounds pBounds = this._returnBeadButtonWrapper.getFullBoundsReference();
        double d = pBounds.getX() + pBounds.getWidth() / 2.0;
        double d2 = pBounds.getY() + pBounds.getHeight() / 2.0;
        OTModelViewTransform oTModelViewTransform = this._model.getModelViewTransform();
        Point2D point2D = oTModelViewTransform.viewToModel(d, d2);
        Bead bead = this._model.getBead();
        bead.setMotionEnabled(false);
        bead.setPosition(point2D);
        bead.setMotionEnabled(true);
        this._returnBeadButtonWrapper.setVisible(false);
        this._returnBeadButtonWrapper.setPickable(false);
        this._returnBeadButtonWrapper.setChildrenPickable(false);
    }
}

