/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.model;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class OTModelViewTransform {
    private AffineTransform _modelToViewTransform = new AffineTransform();
    private AffineTransform _viewToModelTransform;
    private Point2D _pModelDistance;
    private Point2D _pViewDistance;

    public OTModelViewTransform(double d) {
        this(d, 0.0, 0.0);
    }

    public OTModelViewTransform(double d, double d2, double d3) {
        this._modelToViewTransform.scale(d, d);
        this._modelToViewTransform.translate(d2, d3);
        this._viewToModelTransform = new AffineTransform();
        this._viewToModelTransform.translate(-d2, -d3);
        this._viewToModelTransform.scale(1.0 / d, 1.0 / d);
        this._pModelDistance = new Point2D.Double();
        this._pViewDistance = new Point2D.Double();
    }

    public Shape createTransformedShapeModelToView(Shape shape) {
        return this._modelToViewTransform.createTransformedShape(shape);
    }

    public double getScaleModelToView() {
        return this._modelToViewTransform.getScaleX();
    }

    public Point2D modelToView(Point2D point2D) {
        return this.modelToView(point2D, null);
    }

    public Point2D modelToView(Point2D point2D, Point2D point2D2) {
        return this._modelToViewTransform.transform(point2D, point2D2);
    }

    public double modelToView(double d) {
        this._pModelDistance.setLocation(d, 0.0);
        this.modelToView(this._pModelDistance, this._pViewDistance);
        return this._pViewDistance.getX();
    }

    public Point2D viewToModel(Point2D point2D) {
        return this.viewToModel(point2D, null);
    }

    public Point2D viewToModel(double d, double d2) {
        return this.viewToModel(new Point2D.Double(d, d2));
    }

    public Point2D viewToModel(Point2D point2D, Point2D point2D2) {
        return this._viewToModelTransform.transform(point2D, point2D2);
    }

    public double viewToModel(double d) {
        this._pViewDistance.setLocation(d, 0.0);
        this.viewToModel(this._pViewDistance, this._pModelDistance);
        return this._pModelDistance.getX();
    }
}

