/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.opticaltweezers.model.MovableObject;
import edu.colorado.phet.opticaltweezers.model.OTClock;
import edu.colorado.phet.opticaltweezers.util.OTVector2D;
import java.awt.geom.Point2D;

public class Laser
extends MovableObject
implements ModelElement {
    private boolean _running = false;
    private final double _diameterAtObjective;
    private final double _diameterAtWaist;
    private final double _distanceFromObjectiveToWaist;
    private final double _distanceFromObjectiveToControlPanel;
    private final double _wavelength;
    private final double _visibleWavelength;
    private double _power;
    private final DoubleRange _powerRange;
    private double _electricFieldTime;
    private OTClock _clock;
    private double _trapForceRatio;
    private DoubleRange _trapForceRatioRange;
    private double _electricFieldScale;
    private DoubleRange _electricFieldScaleRange;

    public Laser(Point2D point2D, double d, double d2, double d3, double d4, double d5, double d6, double d7, DoubleRange doubleRange, DoubleRange doubleRange2, DoubleRange doubleRange3, OTClock oTClock) {
        super(point2D, d, 0.0);
        this._diameterAtObjective = d2;
        this._diameterAtWaist = d3;
        this._distanceFromObjectiveToWaist = d4;
        this._distanceFromObjectiveToControlPanel = d5;
        this._wavelength = d6;
        this._visibleWavelength = d7;
        this._powerRange = new DoubleRange(doubleRange);
        this._power = this._powerRange.getDefault();
        this._trapForceRatioRange = doubleRange2;
        this._trapForceRatio = this._trapForceRatioRange.getDefault();
        this._electricFieldScaleRange = doubleRange3;
        this._electricFieldScale = this._electricFieldScaleRange.getDefault();
        this._electricFieldTime = 0.0;
        this._clock = oTClock;
        this._clock.addConstantDtClockListener(new ConstantDtClock.ConstantDtClockAdapter(){

            public void dtChanged(ConstantDtClock.ConstantDtClockEvent constantDtClockEvent) {
                Laser.this.resetElectricFieldTime();
            }
        });
    }

    public void setRunning(boolean bl) {
        if (bl != this._running) {
            this._running = bl;
            this.notifyObservers("running");
        }
    }

    public boolean isRunning() {
        return this._running;
    }

    public double getDiameterAtObjective() {
        return this._diameterAtObjective;
    }

    public double getDistanceFromObjectiveToWaist() {
        return this._distanceFromObjectiveToWaist;
    }

    public double getDistanceFromObjectiveToControlPanel() {
        return this._distanceFromObjectiveToControlPanel;
    }

    public double getVisibleWavelength() {
        return this._visibleWavelength;
    }

    public double getPower() {
        return this._power;
    }

    public void setPower(double d) {
        if (d < this._powerRange.getMin() || d > this._powerRange.getMax()) {
            throw new IllegalArgumentException("power out of range: " + d);
        }
        if (d != this._power) {
            this._power = d;
            this.notifyObservers("power");
        }
    }

    public DoubleRange getPowerRange() {
        return this._powerRange;
    }

    public void setTrapForceRatio(double d) {
        if (!this._trapForceRatioRange.contains(d)) {
            throw new IllegalArgumentException("trapForceRation out of range: " + d);
        }
        if (d != this._trapForceRatio) {
            this._trapForceRatio = d;
            this.notifyObservers("trapForceRatio");
        }
    }

    public double getTrapForceRatio() {
        return this._trapForceRatio;
    }

    public DoubleRange getTrapForceRatioRange() {
        return this._trapForceRatioRange;
    }

    public void setElectricFieldScale(double d) {
        if (!this._electricFieldScaleRange.contains(d)) {
            throw new IllegalArgumentException("electricFieldScale out of range: " + d);
        }
        if (d != this._electricFieldScale) {
            this._electricFieldScale = d;
            this.notifyObservers("electricFieldScale");
        }
    }

    public double getElectricFieldScale() {
        return this._electricFieldScale;
    }

    public DoubleRange getElectricFieldScaleRange() {
        return this._electricFieldScaleRange;
    }

    public double getRadius(double d) {
        double d2 = Math.abs(d);
        double d3 = this._diameterAtWaist / 2.0;
        double d4 = this._diameterAtObjective / 2.0;
        double d5 = Math.PI * d3 * d3 / this._wavelength;
        double d6 = this._distanceFromObjectiveToWaist / d5 / Math.sqrt(d4 / d3 * (d4 / d3) - 1.0);
        double d7 = d2 / (d6 * d5);
        return d3 * Math.sqrt(1.0 + d7 * d7);
    }

    public boolean contains(double d, double d2) {
        double d3;
        assert (this.getOrientation() == Math.toRadians(-90.0));
        boolean bl = false;
        double d4 = d - this.getX();
        double d5 = d2 - this.getY();
        if (d5 <= this._distanceFromObjectiveToWaist && (d3 = this.getRadius(d5)) >= Math.abs(d4)) {
            bl = true;
        }
        return bl;
    }

    public double getIntensity(double d, double d2) {
        double d3 = this._running ? this._power : 0.0;
        return this.getIntensity(d, d2, d3);
    }

    public double getIntensity(double d, double d2, double d3) {
        double d4 = d - this.getX();
        double d5 = d2 - this.getY();
        double d6 = this.getRadius(d5);
        return Laser.getIntensityOnRadius(d4, d6, d3);
    }

    public static double getIntensityOnRadius(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("radius must be > 0: " + d2);
        }
        if (d3 < 0.0) {
            throw new IllegalArgumentException("power must be >= 0 : " + d3);
        }
        double d4 = d3 / (Math.PI * (d2 * d2 / 2.0));
        double d5 = Math.exp(-2.0 * d * d / (d2 * d2));
        return d4 * d5;
    }

    public double getMaxIntensity() {
        return this.getIntensity(this.getX(), this.getY(), this._powerRange.getMax());
    }

    public OTVector2D getTrapForce(double d, double d2) {
        double d3 = this._running ? this._power : 0.0;
        return this.getTrapForce(d, d2, d3);
    }

    public OTVector2D getTrapForce(double d, double d2, double d3) {
        double d4 = d - this.getX();
        double d5 = d2 - this.getY();
        return this.getTrapForceAtOffset(d4, d5, d3);
    }

    public OTVector2D getMaxTrapForce() {
        double d = this._diameterAtWaist / 4.0;
        double d2 = 0.0;
        double d3 = this._powerRange.getMax();
        return this.getTrapForceAtOffset(d, d2, d3);
    }

    private OTVector2D getTrapForceAtOffset(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new IllegalArgumentException("power must be >= 0 : " + d3);
        }
        double d4 = this.getRadius(d2);
        double d5 = Laser.getIntensityOnRadius(d, d4, d3);
        double d6 = -582771.6 * (d / (d4 * d4)) * d5;
        double d7 = -582771.6 * (d2 / (d4 * d4)) * d5 * this._trapForceRatio * (1.0 - 2.0 * d * d / (d4 * d4));
        if (this._clock.getDt() <= this._clock.getSlowRange().getMax()) {
            double d8 = this.getElectricFieldComponent(d2);
            double d9 = Math.sqrt(2.0) * Math.abs(d8);
            d6 *= d9;
            d7 *= d9;
        }
        return new OTVector2D.Cartesian(d6, d7);
    }

    public double getPotentialEnergy(double d, double d2) {
        double d3 = this._running ? this._power : 0.0;
        return this.getPotentialEnergy(d, d2, d3);
    }

    private double getPotentialEnergy(double d, double d2, double d3) {
        return -1.0 * this.getIntensity(d, d2, d3);
    }

    public double getMinPotentialEnergy() {
        return this.getPotentialEnergy(this.getX(), this.getY(), this._powerRange.getMax());
    }

    public double getMaxPotentialEnergy() {
        return 0.0;
    }

    public double getElectricFieldX(Point2D point2D) {
        return this.getElectricFieldX(point2D.getX(), point2D.getY());
    }

    public double getElectricFieldX(double d, double d2) {
        double d3 = this.getIntensity(this.getX() + d, this.getY() + d2);
        double d4 = this.getInitialElectricFieldX(d3);
        double d5 = d4 * this.getElectricFieldComponent(d2);
        return d5;
    }

    private double getElectricFieldComponent(double d) {
        return Math.sin(Math.PI * 2 / this._wavelength * (d + 3.0E17 * this._electricFieldTime));
    }

    public double getMaxElectricFieldX() {
        double d = this.getMaxIntensity();
        return this.getInitialElectricFieldX(d);
    }

    private double getInitialElectricFieldX(double d) {
        return this._electricFieldScale * d;
    }

    private void resetElectricFieldTime() {
        double d = this._wavelength / 3.0E17;
        int n = (int)(this._electricFieldTime / d);
        if (n > 0) {
            this._electricFieldScale -= (double)n * d;
        }
    }

    public void stepInTime(double d) {
        if (this._running) {
            double d2 = this._electricFieldTime;
            this._electricFieldTime = d <= this._clock.getSlowRange().getMax() ? (this._electricFieldTime += d) : (this._electricFieldTime += 4.0E-5);
            if (this._electricFieldTime == d2) {
                System.out.println("Laser.stepInTime: resetting t, t got big enough that t+dt=t: t=" + this._electricFieldTime + " dt=" + d);
                this._electricFieldTime = 0.0;
            }
            this.notifyObservers("electricField");
        }
    }
}

