/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.opticaltweezers.model.OTObservable;
import edu.colorado.phet.opticaltweezers.util.OTVector2D;

public class Fluid
extends OTObservable
implements ModelElement {
    private final DoubleRange _speedRange;
    private final DoubleRange _viscosityRange;
    private final DoubleRange _temperatureRange;
    private final DoubleRange _atpConcentrationRange;
    private double _speed;
    private final double _direction;
    private double _viscosity;
    private double _temperature;
    private double _atpConcentration;
    private boolean _enabled;

    public Fluid(DoubleRange doubleRange, double d, DoubleRange doubleRange2, DoubleRange doubleRange3, DoubleRange doubleRange4) {
        this._speedRange = doubleRange;
        this._viscosityRange = doubleRange2;
        this._temperatureRange = doubleRange3;
        this._atpConcentrationRange = doubleRange4;
        this._speed = this._speedRange.getDefault();
        this._direction = d;
        this._viscosity = this._viscosityRange.getDefault();
        this._temperature = this._temperatureRange.getDefault();
        this._atpConcentration = this._atpConcentrationRange.getDefault();
        this._enabled = true;
    }

    public double getDirection() {
        return this._direction;
    }

    public OTVector2D getVelocity() {
        return this.getVelocity(null);
    }

    public OTVector2D getVelocity(OTVector2D oTVector2D) {
        OTVector2D oTVector2D2 = oTVector2D;
        if (oTVector2D2 == null) {
            oTVector2D2 = new OTVector2D.Cartesian();
        }
        oTVector2D2.setMagnitudeAngle(this.getSpeed(), this._direction);
        return oTVector2D2;
    }

    public double getSpeed() {
        return this._speed;
    }

    public void setSpeed(double d) {
        if (d < this._speedRange.getMin() || d > this._speedRange.getMax()) {
            throw new IllegalArgumentException("speed out of range: " + d);
        }
        this._speed = d;
        this.notifyObservers("speed");
    }

    public DoubleRange getSpeedRange() {
        return this._speedRange;
    }

    public double getViscosity() {
        return this._viscosity;
    }

    public void setViscosity(double d) {
        if (d < this._viscosityRange.getMin() || d > this._viscosityRange.getMax()) {
            throw new IllegalArgumentException("viscosity out of range: " + d);
        }
        if (d != this._viscosity) {
            this._viscosity = d;
            this.notifyObservers("viscosity");
        }
    }

    public DoubleRange getViscosityRange() {
        return this._viscosityRange;
    }

    public double getTemperature() {
        return this._temperature;
    }

    public void setTemperature(double d) {
        if (d < this._temperatureRange.getMin() || d > this._temperatureRange.getMax()) {
            throw new IllegalArgumentException("temperature out of range: " + d);
        }
        if (d != this._temperature) {
            this._temperature = d;
            this.notifyObservers("temperature");
        }
    }

    public DoubleRange getTemperatureRange() {
        return this._temperatureRange;
    }

    public double getATPConcentration() {
        return this._atpConcentration;
    }

    public void setATPConcentration(double d) {
        if (d < this._atpConcentrationRange.getMin() || d > this._atpConcentrationRange.getMax()) {
            throw new IllegalArgumentException("aptConcentration out of range: " + d);
        }
        if (d != this._atpConcentration) {
            this._atpConcentration = d;
            this.notifyObservers("aptConcentration");
        }
    }

    public DoubleRange getATPConcentrationRange() {
        return this._atpConcentrationRange;
    }

    public void setEnabled(boolean bl) {
        if (bl != this._enabled) {
            this._enabled = bl;
            this.notifyObservers("enabled");
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public OTVector2D getDragForce(OTVector2D oTVector2D, double d) {
        double d2 = this.getMobility(d);
        OTVector2D oTVector2D2 = this.getVelocity();
        double d3 = (oTVector2D2.getX() - oTVector2D.getX()) / d2;
        double d4 = (oTVector2D2.getY() - oTVector2D.getY()) / d2;
        return new OTVector2D.Cartesian(d3, d4);
    }

    public double getMobility(double d) {
        double d2 = this.getMobilityConstant(d);
        double d3 = this.getDimensionlessNormalizedViscosity();
        return d2 / d3;
    }

    private double getMobilityConstant(double d) {
        return 6.0E7 / (d / 2.0);
    }

    public double getDimensionlessNormalizedViscosity() {
        return this._viscosity / 0.001;
    }

    public void stepInTime(double d) {
    }
}

