/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.opticaltweezers.model.DNAStrand;
import edu.colorado.phet.opticaltweezers.model.FixedObject;
import edu.colorado.phet.opticaltweezers.model.Fluid;
import edu.colorado.phet.opticaltweezers.model.IDNASpeedStrategy;
import edu.colorado.phet.opticaltweezers.model.IStallForceStrategy;
import java.awt.geom.Point2D;

public abstract class AbstractEnzyme
extends FixedObject
implements ModelElement {
    private static final double MAX_ROTATION_DELTA = Math.toRadians(45.0);
    private DNAStrand _dnaStrandBead;
    private DNAStrand _dnaStrandFree;
    private Fluid _fluid;
    private final double _maxDt;
    private IDNASpeedStrategy _dnaSpeedStrategy;
    private IStallForceStrategy _stallForceStrategy;
    private final double _outerDiameter;
    private final double _innerDiameter;
    private double _innerOrientation;
    private boolean _enabled;

    public AbstractEnzyme(Point2D point2D, double d, double d2, DNAStrand dNAStrand, DNAStrand dNAStrand2, Fluid fluid, double d3, IDNASpeedStrategy iDNASpeedStrategy, IStallForceStrategy iStallForceStrategy) {
        super(point2D, 0.0);
        this._outerDiameter = d;
        this._innerDiameter = d2;
        this._innerOrientation = 0.0;
        this._enabled = false;
        this._dnaStrandBead = dNAStrand;
        this._dnaStrandFree = dNAStrand2;
        this._fluid = fluid;
        this._maxDt = d3;
        this._dnaSpeedStrategy = iDNASpeedStrategy;
        this._stallForceStrategy = iStallForceStrategy;
    }

    public double getOuterDiameter() {
        return this._outerDiameter;
    }

    public double getInnerDiameter() {
        return this._innerDiameter;
    }

    public double getInnerOrientation() {
        return this._innerOrientation;
    }

    public void setEnabled(boolean bl) {
        if (bl != this._enabled) {
            this._enabled = bl;
            this.notifyObservers("enabled");
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public double getDNASpeed(double d, double d2) {
        return this._dnaSpeedStrategy.getSpeed(d, d2);
    }

    public double getStallForceMagnitude(double d) {
        return this._stallForceStrategy.getStallForceMagnitude(d);
    }

    public void stepInTime(double d) {
        if (this._enabled) {
            double d2;
            double d3;
            double d4 = this._fluid.getATPConcentration();
            double d5 = this._dnaStrandBead.getForceAtBead().getMagnitude();
            double d6 = this.getDNASpeed(d4, d5);
            double d7 = d6 * d;
            double d8 = this._dnaStrandBead.getContourLength();
            double d9 = d8 - (d3 = this._dnaStrandBead.setContourLength(d2 = d8 - d7));
            if (d9 > 0.0) {
                this._dnaStrandFree.setContourLength(this._dnaStrandFree.getContourLength() + d9);
            }
            if (d9 > 0.0) {
                double d10 = d6 / this._dnaSpeedStrategy.getMaxSpeed();
                double d11 = d / this._maxDt;
                double d12 = MAX_ROTATION_DELTA * d10 * d11;
                this._innerOrientation += d12;
                this.notifyObservers("innerOrientation");
            }
        }
    }
}

