/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.defaults;

import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.opticaltweezers.defaults.GlobalDefaults;
import edu.colorado.phet.opticaltweezers.model.OTClock;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;

public class PhysicsDefaults {
    public static final DoubleRange SLOW_DT_RANGE = new DoubleRange(4.0E-18, 5.0E-16);
    public static final DoubleRange FAST_DT_RANGE = new DoubleRange(1.0E-7, 4.0E-5);
    public static final double DEFAULT_DT = FAST_DT_RANGE.getMax();
    public static final OTClock CLOCK = new OTClock(25, SLOW_DT_RANGE, FAST_DT_RANGE, DEFAULT_DT);
    public static final Dimension VIEW_SIZE = new Dimension(750, 750);
    public static final Point2D MICROSCOPE_SLIDE_POSITION = new Point2D.Double(0.0, 600.0);
    public static final double MICROSCOPE_SLIDE_ORIENTATION = Math.toRadians(0.0);
    public static final double FLUID_DIRECTION = GlobalDefaults.FLUID_DIRECTION;
    public static final DoubleRange FLUID_SPEED_RANGE = GlobalDefaults.FLUID_SPEED_RANGE;
    public static final DoubleRange FLUID_VISCOSITY_RANGE = GlobalDefaults.FLUID_VISCOSITY_RANGE;
    public static final DoubleRange FLUID_TEMPERATURE_RANGE = GlobalDefaults.FLUID_TEMPERATURE_RANGE;
    public static final DoubleRange FLUID_APT_CONCENTRATION_RANGE = GlobalDefaults.FLUID_APT_CONCENTRATION_RANGE;
    public static final Point2D LASER_POSITION = new Point2D.Double(1200.0, MICROSCOPE_SLIDE_POSITION.getY());
    public static final double LASER_ORIENTATION = GlobalDefaults.LASER_ORIENTATION;
    public static final DoubleRange LASER_POWER_RANGE = GlobalDefaults.LASER_POWER_RANGE;
    public static final DoubleRange LASER_TRAP_FORCE_RATIO = GlobalDefaults.LASER_TRAP_FORCE_RATIO;
    public static final DoubleRange LASER_ELECTRIC_FIELD_SCALE_RANGE = GlobalDefaults.LASER_ELECTRIC_FIELD_SCALE_RANGE;
    public static final Point2D BEAD_POSITION = new Point2D.Double(LASER_POSITION.getX(), LASER_POSITION.getY());
    public static final double BEAD_ORIENTATION = GlobalDefaults.BEAD_ORIENTATION;
    public static final IntegerRange BEAD_NUMBER_OF_DT_SUBDIVISIONS_RANGE = new IntegerRange(1, 2000, 100);
    public static final DoubleRange BEAD_DT_SUBDIVISION_THRESHOLD_RANGE = new DoubleRange(FAST_DT_RANGE.getMin(), FAST_DT_RANGE.getMax(), 1.0E-6);
    public static final DoubleRange BEAD_VERLET_DT_SUBDIVISION_THRESHOLD_RANGE = new DoubleRange(FAST_DT_RANGE.getMin(), FAST_DT_RANGE.getMax(), 1.0E-6);
    public static final DoubleRange BEAD_VACUUM_FAST_DT_RANGE = new DoubleRange(FAST_DT_RANGE.getMin(), FAST_DT_RANGE.getMax(), 1.0E-5);
    public static final DoubleRange BEAD_BROWNIAN_MOTION_SCALE_RANGE = GlobalDefaults.BEAD_BROWNIAN_MOTION_SCALE_RANGE;
    public static final DoubleRange BEAD_VERLET_ACCELERATION_SCALE_RANGE = GlobalDefaults.BEAD_VERLET_ACCELERATION_SCALE_RANGE;
    public static final IntegerRange BEAD_VERLET_NUMBER_OF_DT_SUBDIVISIONS_RANGE = GlobalDefaults.BEAD_VERLET_NUMBER_OF_DT_SUBDIVISIONS_RANGE;
    public static final DoubleRange BEAD_VACUUM_FAST_THRESHOLD_RANGE = GlobalDefaults.BEAD_VACUUM_FAST_THRESHOLD_RANGE;
    public static final DoubleRange BEAD_VACUUM_FAST_POWER_RANGE = GlobalDefaults.BEAD_VACUUM_FAST_POWER_RANGE;
    public static final DoubleRange CHARGE_MOTION_SCALE_RANGE = new DoubleRange(0.0, 1.0, 0.25);
    public static final double RULER_Y_POSITION = MICROSCOPE_SLIDE_POSITION.getY() + 500.0 - 150.0;
    public static final Point POSITION_HISTOGRAM_DIALOG_OFFSET = GlobalDefaults.POSITION_HISTOGRAM_DIALOG_OFFSET;
    public static final Point FLUID_CONTROLS_DIALOG_OFFSET = new Point(10, 400);
}

