/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.control;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import edu.colorado.phet.opticaltweezers.OTResources;
import java.awt.FlowLayout;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OTClockControlPanel
extends PiccoloClockControlPanel {
    private OTClockTimePanel _timePanel;

    public OTClockControlPanel(ConstantDtClock constantDtClock) {
        super(constantDtClock);
        this.setRewindButtonVisible(true);
        this.setTimeDisplayVisible(false);
        String string = OTResources.getString("units.time");
        this._timePanel = new OTClockTimePanel(constantDtClock, string);
        this.addBetweenTimeDisplayAndButtons(this._timePanel);
    }

    public void setTimeColumns(int n) {
        this._timePanel.setTimeColumns(n);
    }

    private static class OTClockTimePanel
    extends JPanel {
        public static final DecimalFormat PLAIN_FORMAT = new DecimalFormat("0.0000000000000000000000000000000000000000");
        public static final DecimalFormat MANTISSA_FORMAT = new DecimalFormat("0.0");
        private ConstantDtClock _clock;
        private JTextField _timeTextField;
        private JLabel _unitsLabel;
        private ClockListener _clockListener;
        private String _exponentString;
        private double _timeMultiplier;

        public OTClockTimePanel(ConstantDtClock constantDtClock, String string) {
            this._clock = constantDtClock;
            this._clockListener = new ClockAdapter(){

                public void simulationTimeChanged(ClockEvent clockEvent) {
                    super.simulationTimeChanged(clockEvent);
                    OTClockTimePanel.this.update();
                }

                public void simulationTimeReset(ClockEvent clockEvent) {
                    super.simulationTimeReset(clockEvent);
                    OTClockTimePanel.this.update();
                }
            };
            this._clock.addClockListener(this._clockListener);
            constantDtClock.addConstantDtClockListener(new ConstantDtClock.ConstantDtClockAdapter(){

                public void dtChanged(ConstantDtClock.ConstantDtClockEvent constantDtClockEvent) {
                    ConstantDtClock constantDtClock = constantDtClockEvent.getClock();
                    double d = constantDtClock.getDt();
                    OTClockTimePanel.this.updateTimeFormat(d);
                }
            });
            this._timeTextField = new JTextField();
            this._timeTextField.setColumns(8);
            this._timeTextField.setEditable(false);
            this._timeTextField.setHorizontalAlignment(4);
            this._unitsLabel = new JLabel(string);
            this.setLayout(new FlowLayout(1));
            this.add(this._timeTextField);
            this.add(this._unitsLabel);
            this.updateTimeFormat(constantDtClock.getDt());
        }

        public void setTimeColumns(int n) {
            this._timeTextField.setColumns(n);
        }

        private void update() {
            double d = this._clock.getSimulationTime() * this._timeMultiplier;
            String string = MANTISSA_FORMAT.format(d) + this._exponentString;
            this._timeTextField.setText(string);
        }

        private void updateTimeFormat(double d) {
            int n = OTClockTimePanel.getNumberOfZerosToRightOfDecimalPlace(d) + 1;
            this._exponentString = "E-" + String.valueOf(n);
            this._timeMultiplier = Math.pow(10.0, n);
            this.update();
        }

        private static int getNumberOfZerosToRightOfDecimalPlace(double d) {
            String string = PLAIN_FORMAT.format(d);
            boolean bl = false;
            int n = 0;
            boolean bl2 = false;
            for (int i = 0; !bl2 && i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '.') {
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                if (c == '0') {
                    ++n;
                    continue;
                }
                bl2 = true;
            }
            return n;
        }
    }
}

