/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.control;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.OTResources;
import edu.colorado.phet.opticaltweezers.dialog.FluidControlsDialog;
import edu.colorado.phet.opticaltweezers.model.Fluid;
import edu.umd.cs.piccolo.PNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class MiscControlPanel
extends JPanel
implements Observer {
    private PNode _rulerNode;
    private Fluid _fluid;
    private Frame _parentFrame;
    private FluidControlsDialog _fluidControlsDialog;
    private Point _fluidControlsDialogOffset;
    private Point _fluidControlsDialogLocation;
    private JCheckBox _rulerCheckBox;
    private Box _fluidVacuumPanel;
    private JRadioButton _fluidRadioButton;
    private JRadioButton _vacuumRadioButton;
    private JCheckBox _fluidControlsCheckBox;

    public MiscControlPanel(Font font, Font font2, Frame frame, Point point, PNode pNode, Fluid fluid) {
        this._parentFrame = frame;
        this._rulerNode = pNode;
        this._fluid = fluid;
        this._fluid.addObserver(this);
        this._fluidControlsDialog = null;
        this._fluidControlsDialogOffset = new Point(point);
        this._fluidControlsDialogLocation = null;
        this._rulerCheckBox = new JCheckBox(OTResources.getString("label.showRuler"));
        this._rulerCheckBox.setFont(font2);
        this._rulerCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MiscControlPanel.this.handleRulerCheckBox();
            }
        });
        ImageIcon imageIcon = new ImageIcon(OTResources.getImage("rulerIcon.png"));
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                MiscControlPanel.this._rulerCheckBox.setSelected(!MiscControlPanel.this._rulerCheckBox.isSelected());
                MiscControlPanel.this.handleRulerCheckBox();
            }
        });
        Box box = new Box(0);
        box.add(this._rulerCheckBox);
        box.add(Box.createHorizontalStrut(5));
        box.add(jLabel);
        JComponent jComponent = new JLabel(OTResources.getString("label.beadIsIn"));
        this._fluidRadioButton = new JRadioButton(OTResources.getString("choice.fluid"));
        this._fluidRadioButton.setFont(font2);
        this._fluidRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MiscControlPanel.this.handleFluidOrVacuumChoice();
            }
        });
        this._vacuumRadioButton = new JRadioButton(OTResources.getString("choice.vacuum"));
        this._vacuumRadioButton.setFont(font2);
        this._vacuumRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MiscControlPanel.this.handleFluidOrVacuumChoice();
            }
        });
        Serializable serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this._fluidRadioButton);
        ((ButtonGroup)serializable).add(this._vacuumRadioButton);
        this._fluidVacuumPanel = new Box(0);
        this._fluidVacuumPanel.add(jComponent);
        this._fluidVacuumPanel.add(this._fluidRadioButton);
        this._fluidVacuumPanel.add(this._vacuumRadioButton);
        this._fluidControlsCheckBox = new JCheckBox(OTResources.getString("label.showFluidControls"));
        this._fluidControlsCheckBox.setFont(font2);
        this._fluidControlsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MiscControlPanel.this.handleFluidControlsCheckBox();
            }
        });
        jComponent = new JPanel();
        serializable = new EasyGridBagLayout((JPanel)jComponent);
        jComponent.setLayout((LayoutManager)((Object)serializable));
        ((EasyGridBagLayout)serializable).setAnchor(17);
        ((EasyGridBagLayout)serializable).setFill(2);
        ((EasyGridBagLayout)serializable).setInsets(OTConstants.SUB_PANEL_INSETS);
        ((EasyGridBagLayout)serializable).setMinimumWidth(0, 20);
        int n = 0;
        ((EasyGridBagLayout)serializable).addComponent(box, n++, 0);
        ((EasyGridBagLayout)serializable).addComponent(this._fluidVacuumPanel, n++, 0);
        ((EasyGridBagLayout)serializable).addComponent(this._fluidControlsCheckBox, n++, 0);
        this.setLayout(new BorderLayout());
        this.add((Component)jComponent, "West");
        if (this._fluid.isEnabled()) {
            this._fluidRadioButton.setSelected(true);
        } else {
            this._vacuumRadioButton.setSelected(true);
        }
        this._fluidControlsCheckBox.setSelected(false);
        this._rulerCheckBox.setSelected(false);
    }

    public void setRulerSelected(boolean bl) {
        this._rulerCheckBox.setSelected(bl);
        this.handleRulerCheckBox();
    }

    public boolean isRulerSelected() {
        return this._rulerCheckBox.isSelected();
    }

    public void setFluidVacuumPanelVisible(boolean bl) {
        this._fluidVacuumPanel.setVisible(bl);
    }

    public void setFluidSelected(boolean bl) {
        this._fluidRadioButton.setSelected(bl);
        this._vacuumRadioButton.setSelected(!bl);
        this.handleFluidOrVacuumChoice();
    }

    public boolean isFluidSelected() {
        return this._fluidRadioButton.isSelected();
    }

    public void setVacuumSelected(boolean bl) {
        this._fluidRadioButton.setSelected(!bl);
        this._vacuumRadioButton.setSelected(bl);
        this.handleFluidOrVacuumChoice();
    }

    public boolean isVacuumSelected() {
        return this._vacuumRadioButton.isSelected();
    }

    public void setFluidControlsSelected(boolean bl) {
        this._fluidControlsCheckBox.setSelected(bl);
        this.handleFluidControlsCheckBox();
    }

    public boolean isFluidControlsSelected() {
        return this._fluidControlsCheckBox.isSelected();
    }

    private void handleRulerCheckBox() {
        boolean bl = this._rulerCheckBox.isSelected();
        this._rulerNode.setVisible(bl);
    }

    private void handleFluidOrVacuumChoice() {
        this._fluid.deleteObserver(this);
        this._fluid.setEnabled(this._fluidRadioButton.isSelected());
        this._fluid.addObserver(this);
        this._fluidControlsCheckBox.setEnabled(this._fluidRadioButton.isSelected());
        if (this._fluidRadioButton.isSelected()) {
            if (this._fluidControlsCheckBox.isSelected()) {
                this.openFluidControlsDialog();
            }
        } else {
            this.closeFluidControlsDialog();
        }
    }

    private void handleFluidControlsCheckBox() {
        boolean bl;
        boolean bl2 = bl = this._fluidRadioButton.isSelected() && this._fluidControlsCheckBox.isSelected();
        if (bl) {
            if (this._parentFrame.isVisible()) {
                this.openFluidControlsDialog();
            }
        } else {
            this.closeFluidControlsDialog();
        }
    }

    private void openFluidControlsDialog() {
        this.closeFluidControlsDialog();
        this._fluidControlsDialog = new FluidControlsDialog(this._parentFrame, OTConstants.CONTROL_PANEL_CONTROL_FONT, this._fluid);
        this._fluidControlsDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MiscControlPanel.this.closeFluidControlsDialog();
            }

            public void windowClosed(WindowEvent windowEvent) {
                MiscControlPanel.this._fluidControlsDialog = null;
                if (MiscControlPanel.this._fluidRadioButton.isSelected()) {
                    MiscControlPanel.this._fluidControlsCheckBox.setSelected(false);
                }
            }
        });
        if (this._fluidControlsDialogLocation == null) {
            Point point = this._parentFrame.getLocationOnScreen();
            int n = (int)(point.getX() + this._fluidControlsDialogOffset.getX());
            int n2 = (int)(point.getY() + this._fluidControlsDialogOffset.getY());
            this._fluidControlsDialog.setLocation(n, n2);
        } else {
            this._fluidControlsDialog.setLocation(this._fluidControlsDialogLocation);
        }
        this._fluidControlsDialog.show();
    }

    private void closeFluidControlsDialog() {
        if (this._fluidControlsDialog != null) {
            this._fluidControlsDialogLocation = this._fluidControlsDialog.getLocation();
            this._fluidControlsDialog.dispose();
            this._fluidControlsDialog = null;
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this._fluid && object == "enabled") {
            this.setFluidSelected(this._fluid.isEnabled());
        }
    }
}

