/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.control;

import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.controls.IntensitySlider;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class LaserPowerControl {
    private JLabel _label;
    private IntensitySlider _intensitySlider;
    private JFormattedTextField _formattedTextField;
    private JLabel _units;
    private double _minPower;
    private double _maxPower;
    private double _power;
    private DecimalFormat _formatter;
    private EventHandler _listener;
    private EventListenerList _listenerList;

    public LaserPowerControl(DoubleRange doubleRange, String string, String string2, String string3, int n, double d, Dimension dimension, Font font) {
        this._minPower = doubleRange.getMin();
        this._maxPower = doubleRange.getMax();
        this._listener = new EventHandler();
        this._listenerList = new EventListenerList();
        Color color = VisibleColor.wavelengthToColor(d);
        this._intensitySlider = new IntensitySlider(color, IntensitySlider.HORIZONTAL, dimension);
        this._intensitySlider.addChangeListener(this._listener);
        this._label = new JLabel(string);
        this._label.setFont(font);
        this._formattedTextField = new JFormattedTextField();
        this._formattedTextField.setFont(font);
        this._formattedTextField.setColumns(n);
        this._formattedTextField.setHorizontalAlignment(4);
        this._formattedTextField.addActionListener(this._listener);
        this._formattedTextField.addFocusListener(this._listener);
        this._formattedTextField.addKeyListener(this._listener);
        this._formatter = new DecimalFormat(string3);
        this._units = new JLabel(string2);
        this._units.setFont(font);
        this._intensitySlider.setOpaque(false);
        this._units.setOpaque(false);
        this._power = doubleRange.getMin() - 1.0;
        this.setPower(doubleRange.getDefault());
    }

    public JComponent getLabel() {
        return this._label;
    }

    public JComponent getSlider() {
        return this._intensitySlider;
    }

    public JComponent getTextField() {
        return this._formattedTextField;
    }

    public JComponent getUnitsLabel() {
        return this._units;
    }

    public void setPower(double d) {
        if (d < this._minPower || d > this._maxPower) {
            throw new IllegalArgumentException("power out of range: " + d);
        }
        if (d != this._power) {
            this._power = d;
            int n = this.powerToIntensity(d);
            this._intensitySlider.setValue(n);
            String string = this._formatter.format(d);
            this._formattedTextField.setText(string);
            this.fireChangeEvent(new ChangeEvent(this));
        }
    }

    public double getPower() {
        return this._power;
    }

    public void setLabelForeground(Color color) {
        this._label.setForeground(color);
    }

    public void setUnitsForeground(Color color) {
        this._units.setForeground(color);
    }

    private int powerToIntensity(double d) {
        assert (d >= this._minPower);
        assert (d <= this._maxPower);
        return (int)(100.0 * (d - this._minPower) / (this._maxPower - this._minPower));
    }

    private double intensityToPower(int n) {
        assert (n >= 0);
        assert (n <= 100);
        return this._minPower + (double)n / 100.0 * (this._maxPower - this._minPower);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._listenerList.remove(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private void handleTextFieldChanged() {
        String string = this._formattedTextField.getText();
        double d = 0.0;
        try {
            d = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Toolkit.getDefaultToolkit().beep();
            this.revertTextField();
        }
        boolean bl = false;
        if (d < this._minPower) {
            Toolkit.getDefaultToolkit().beep();
            d = this._minPower;
            bl = true;
        } else if (d > this._maxPower) {
            Toolkit.getDefaultToolkit().beep();
            d = this._maxPower;
            bl = true;
        }
        this._intensitySlider.removeChangeListener(this._listener);
        this.setPower(d);
        this._intensitySlider.addChangeListener(this._listener);
        if (bl) {
            this.revertTextField();
        }
    }

    private void handleSliderChanged() {
        int n = this._intensitySlider.getValue();
        double d = this.intensityToPower(n);
        this._intensitySlider.removeChangeListener(this._listener);
        this.setPower(d);
        this._intensitySlider.addChangeListener(this._listener);
    }

    private void revertTextField() {
        String string = this._formatter.format(this._power);
        this._formattedTextField.setText(string);
    }

    private class EventHandler
    extends KeyAdapter
    implements ActionListener,
    FocusListener,
    ChangeListener {
        private EventHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getSource() == LaserPowerControl.this._formattedTextField) {
                if (keyEvent.getKeyCode() == 38) {
                    if (LaserPowerControl.this._power < LaserPowerControl.this._maxPower) {
                        LaserPowerControl.this._intensitySlider.removeChangeListener(LaserPowerControl.this._listener);
                        LaserPowerControl.this.setPower(LaserPowerControl.this._power + 1.0);
                        LaserPowerControl.this._intensitySlider.addChangeListener(LaserPowerControl.this._listener);
                    }
                } else if (keyEvent.getKeyCode() == 40 && LaserPowerControl.this._power > LaserPowerControl.this._minPower) {
                    LaserPowerControl.this._intensitySlider.removeChangeListener(LaserPowerControl.this._listener);
                    LaserPowerControl.this.setPower(LaserPowerControl.this._power - 1.0);
                    LaserPowerControl.this._intensitySlider.addChangeListener(LaserPowerControl.this._listener);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == LaserPowerControl.this._formattedTextField) {
                LaserPowerControl.this.handleTextFieldChanged();
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == LaserPowerControl.this._intensitySlider) {
                LaserPowerControl.this.handleSliderChanged();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == LaserPowerControl.this._formattedTextField) {
                LaserPowerControl.this._formattedTextField.selectAll();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == LaserPowerControl.this._formattedTextField) {
                try {
                    LaserPowerControl.this._formattedTextField.commitEdit();
                    LaserPowerControl.this.handleTextFieldChanged();
                }
                catch (ParseException parseException) {
                    Toolkit.getDefaultToolkit().beep();
                    LaserPowerControl.this.revertTextField();
                }
            }
        }
    }
}

