/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.control;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.OTResources;
import edu.colorado.phet.opticaltweezers.view.ElectricFieldVectorNode;
import edu.colorado.phet.opticaltweezers.view.LaserNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class LaserDisplayControlPanel
extends JPanel {
    private LaserNode _laserNode;
    private JRadioButton _beamRadioButton;
    private JRadioButton _electricFieldRadioButton;
    private JRadioButton _beamAndElectricFieldRadioButton;

    public LaserDisplayControlPanel(Font font, Font font2, LaserNode laserNode) {
        this._laserNode = laserNode;
        JLabel jLabel = new JLabel(OTResources.getString("title.laserDisplayControlPanel"));
        jLabel.setFont(font);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LaserDisplayControlPanel.this.handleDisplayChoice();
            }
        };
        JPanel jPanel = null;
        this._beamRadioButton = new JRadioButton(OTResources.getString("choice.beam"));
        this._beamRadioButton.setFont(font2);
        this._beamRadioButton.addActionListener(actionListener);
        Accessible accessible = new ImageIcon(OTResources.getImage("beamIcon.png"));
        Object object = new JLabel((Icon)((Object)accessible));
        ((Component)object).addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                LaserDisplayControlPanel.this.setDisplaySelection(true, false);
            }
        });
        jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.add(this._beamRadioButton);
        jPanel.add((Component)object);
        accessible = null;
        this._electricFieldRadioButton = new JRadioButton(OTResources.getString("choice.electricField"));
        this._electricFieldRadioButton.setFont(font2);
        this._electricFieldRadioButton.addActionListener(actionListener);
        object = ElectricFieldVectorNode.createIcon();
        JComponent jComponent = new JLabel((Icon)object);
        jComponent.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                LaserDisplayControlPanel.this.setDisplaySelection(false, true);
            }
        });
        accessible = new JPanel(new FlowLayout(0, 0, 0));
        ((Container)((Object)accessible)).add(this._electricFieldRadioButton);
        ((Container)((Object)accessible)).add(jComponent);
        this._beamAndElectricFieldRadioButton = new JRadioButton(OTResources.getString("choice.beamAndElectricField"));
        this._beamAndElectricFieldRadioButton.setFont(font2);
        this._beamAndElectricFieldRadioButton.addActionListener(actionListener);
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this._beamRadioButton);
        ((ButtonGroup)object).add(this._electricFieldRadioButton);
        ((ButtonGroup)object).add(this._beamAndElectricFieldRadioButton);
        jComponent = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout((JPanel)jComponent);
        jComponent.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        easyGridBagLayout.setFill(2);
        easyGridBagLayout.setInsets(OTConstants.SUB_PANEL_INSETS);
        easyGridBagLayout.setMinimumWidth(0, 20);
        int n = 0;
        easyGridBagLayout.addComponent(jLabel, n++, 0);
        easyGridBagLayout.addComponent(jPanel, n++, 0);
        easyGridBagLayout.addComponent((Component)((Object)accessible), n++, 0);
        easyGridBagLayout.addComponent(this._beamAndElectricFieldRadioButton, n++, 0);
        this.setLayout(new BorderLayout());
        this.add((Component)jComponent, "West");
        this._beamRadioButton.setSelected(true);
    }

    public void setDisplaySelection(boolean bl, boolean bl2) {
        this._beamRadioButton.setSelected(bl && !bl2);
        this._electricFieldRadioButton.setSelected(!bl && bl2);
        this._beamAndElectricFieldRadioButton.setSelected(bl && bl2);
        this.handleDisplayChoice();
    }

    public boolean isBeamSelected() {
        return this._beamRadioButton.isSelected();
    }

    public boolean isElectricFieldSelected() {
        return this._electricFieldRadioButton.isSelected();
    }

    private void handleDisplayChoice() {
        this._laserNode.setBeamVisible(this._beamRadioButton.isSelected() || this._beamAndElectricFieldRadioButton.isSelected());
        this._laserNode.setElectricFieldVisible(this._electricFieldRadioButton.isSelected() || this._beamAndElectricFieldRadioButton.isSelected());
    }
}

