/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.control;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.OTResources;
import edu.colorado.phet.opticaltweezers.dialog.PositionHistogramDialog;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.view.LaserNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChartsControlPanel
extends JPanel {
    private Frame _parentFrame;
    private IClock _clock;
    private Bead _bead;
    private Laser _laser;
    private PNode _potentialEnergyChartNode;
    private LaserNode _laserNode;
    private PositionHistogramDialog _positionHistogramDialog;
    private Point _positionHistogramDialogOffset;
    private Point _positionHistogramDialogLocation;
    private int _positionHistogramZoomIndex;
    private boolean _positionHistogramRulerVisible;
    private JCheckBox _positionHistogramCheckBox;
    private JCheckBox _potentialEnergyChartCheckBox;

    public ChartsControlPanel(Font font, Font font2, Frame frame, Point point, IClock iClock, Bead bead, Laser laser, PNode pNode, LaserNode laserNode) {
        this._parentFrame = frame;
        this._clock = iClock;
        this._bead = bead;
        this._laser = laser;
        this._potentialEnergyChartNode = pNode;
        this._laserNode = laserNode;
        this._positionHistogramDialog = null;
        this._positionHistogramDialogOffset = new Point(point);
        this._positionHistogramDialogLocation = null;
        this._positionHistogramZoomIndex = -1;
        this._positionHistogramRulerVisible = false;
        JLabel jLabel = new JLabel(OTResources.getString("title.chartsControlPanel"));
        jLabel.setFont(font);
        JPanel jPanel = null;
        this._positionHistogramCheckBox = new JCheckBox(OTResources.getString("label.positionHistogram"));
        this._positionHistogramCheckBox.setFont(font2);
        this._positionHistogramCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChartsControlPanel.this.handlePositionHistogramCheckBox();
            }
        });
        Accessible accessible = new ImageIcon(OTResources.getImage("histogramIcon.png"));
        Accessible accessible2 = new JLabel((Icon)((Object)accessible));
        ((Component)((Object)accessible2)).addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                ChartsControlPanel.this.setPositionHistogramSelected(!ChartsControlPanel.this.isPositionHistogramSelected());
            }
        });
        jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.add(this._positionHistogramCheckBox);
        jPanel.add((Component)((Object)accessible2));
        accessible = null;
        this._potentialEnergyChartCheckBox = new JCheckBox(OTResources.getString("label.potentialEnergyChart"));
        this._potentialEnergyChartCheckBox.setFont(font2);
        this._potentialEnergyChartCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChartsControlPanel.this.handlePotentialEnergyCheckBox();
            }
        });
        this._potentialEnergyChartNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ChartsControlPanel.this._potentialEnergyChartCheckBox.setSelected(ChartsControlPanel.this._potentialEnergyChartNode.getVisible());
            }
        });
        accessible2 = new ImageIcon(OTResources.getImage("potentialEnergyChartIcon.png"));
        Serializable serializable = new JLabel((Icon)((Object)accessible2));
        ((Component)serializable).addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                ChartsControlPanel.this.setPotentialEnergySelected(!ChartsControlPanel.this.isPotentialChartSelected());
            }
        });
        accessible = new JPanel(new FlowLayout(0, 0, 0));
        ((Container)((Object)accessible)).add(this._potentialEnergyChartCheckBox);
        ((Container)((Object)accessible)).add((Component)serializable);
        accessible2 = new JPanel();
        serializable = new EasyGridBagLayout((JPanel)accessible2);
        ((Container)((Object)accessible2)).setLayout((LayoutManager)((Object)serializable));
        ((EasyGridBagLayout)serializable).setAnchor(17);
        ((EasyGridBagLayout)serializable).setFill(2);
        ((EasyGridBagLayout)serializable).setInsets(OTConstants.SUB_PANEL_INSETS);
        ((EasyGridBagLayout)serializable).setMinimumWidth(0, 20);
        int n = 0;
        ((EasyGridBagLayout)serializable).addComponent(jLabel, n++, 0);
        ((EasyGridBagLayout)serializable).addComponent(jPanel, n++, 0);
        ((EasyGridBagLayout)serializable).addComponent((Component)((Object)accessible), n++, 0);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)accessible2), "West");
        this._positionHistogramCheckBox.setSelected(this._positionHistogramDialog != null);
        this._potentialEnergyChartCheckBox.setSelected(this._potentialEnergyChartNode.getVisible());
    }

    public void setPositionHistogramSelected(boolean bl) {
        this._positionHistogramCheckBox.setSelected(bl);
        this.handlePositionHistogramCheckBox();
    }

    public boolean isPositionHistogramSelected() {
        return this._positionHistogramCheckBox.isSelected();
    }

    public void setPotentialEnergySelected(boolean bl) {
        this._potentialEnergyChartCheckBox.setSelected(bl);
        this.handlePotentialEnergyCheckBox();
    }

    public boolean isPotentialChartSelected() {
        return this._potentialEnergyChartCheckBox.isSelected();
    }

    private void handlePositionHistogramCheckBox() {
        if (this._positionHistogramCheckBox.isSelected()) {
            if (this._parentFrame.isVisible()) {
                this.openPositionHistogramDialog();
            }
        } else {
            this.closePositionHistogramDialog();
        }
    }

    private void handlePotentialEnergyCheckBox() {
        this._potentialEnergyChartNode.setVisible(this._potentialEnergyChartCheckBox.isSelected());
    }

    private void openPositionHistogramDialog() {
        this.closePositionHistogramDialog();
        this._positionHistogramDialog = new PositionHistogramDialog(this._parentFrame, OTConstants.CONTROL_PANEL_CONTROL_FONT, this._clock, this._bead, this._laser);
        this._positionHistogramDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ChartsControlPanel.this.closePositionHistogramDialog();
            }

            public void windowClosed(WindowEvent windowEvent) {
                ChartsControlPanel.this._positionHistogramDialog = null;
                ChartsControlPanel.this._positionHistogramCheckBox.setSelected(false);
                ChartsControlPanel.this._laserNode.setOriginMarkerVisible(false);
            }
        });
        this._laserNode.setOriginMarkerVisible(true);
        if (this._positionHistogramZoomIndex >= 0) {
            this._positionHistogramDialog.getPanel().setZoomIndex(this._positionHistogramZoomIndex);
        }
        this._positionHistogramDialog.getPanel().setRulerVisible(this._positionHistogramRulerVisible);
        if (this._positionHistogramDialogLocation == null) {
            int n = (int)(this._parentFrame.getLocation().getX() + this._positionHistogramDialogOffset.getX());
            int n2 = (int)(this._parentFrame.getLocation().getY() + this._positionHistogramDialogOffset.getY());
            this._positionHistogramDialog.setLocation(n, n2);
        } else {
            this._positionHistogramDialog.setLocation(this._positionHistogramDialogLocation);
        }
        this._positionHistogramDialog.show();
    }

    private void closePositionHistogramDialog() {
        if (this._positionHistogramDialog != null) {
            this._positionHistogramDialogLocation = this._positionHistogramDialog.getLocation();
            this._positionHistogramZoomIndex = this._positionHistogramDialog.getPanel().getZoomIndex();
            this._positionHistogramRulerVisible = this._positionHistogramDialog.getPanel().isRulerVisible();
            this._positionHistogramDialog.dispose();
            this._positionHistogramDialog = null;
        }
    }
}

