/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.charts;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartNode;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.opticaltweezers.OTResources;
import edu.colorado.phet.opticaltweezers.charts.PotentialEnergyPlot;
import edu.colorado.phet.opticaltweezers.control.CloseButtonNode;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.colorado.phet.opticaltweezers.view.BeadNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.ui.RectangleInsets;

public class PotentialEnergyChartNode
extends PhetPNode
implements Observer {
    private static final Color BACKGROUND_COLOR = new Color(255, 255, 255, 200);
    private static final Color CHART_BORDER_COLOR = Color.BLACK;
    private static final Stroke CHART_BORDER_STROKE = new BasicStroke(6.0f);
    private static final RectangleInsets CHART_INSETS = new RectangleInsets(10.0, 10.0, 10.0, 10.0);
    private Laser _laser;
    private Bead _bead;
    private OTModelViewTransform _modelViewTransform;
    private double _sampleWidth;
    private PotentialEnergyPlot _plot;
    private JFreeChartNode _chartWrapper;
    private CloseButtonNode _closeButtonNode;
    private BeadNode _beadNode;

    public PotentialEnergyChartNode(Bead bead, Laser laser, OTModelViewTransform oTModelViewTransform, double d) {
        this._bead = bead;
        this._bead.addObserver(this);
        this._laser = laser;
        this._laser.addObserver(this);
        this._modelViewTransform = oTModelViewTransform;
        this._sampleWidth = d;
        this._plot = new PotentialEnergyPlot();
        JFreeChart jFreeChart = new JFreeChart(OTResources.getString("title.potentialEnergyChart"), null, this._plot, false);
        jFreeChart.setAntiAlias(true);
        jFreeChart.setBorderVisible(true);
        jFreeChart.setBackgroundPaint(BACKGROUND_COLOR);
        jFreeChart.setBorderPaint(CHART_BORDER_COLOR);
        jFreeChart.setBorderStroke(CHART_BORDER_STROKE);
        jFreeChart.setPadding(CHART_INSETS);
        this._chartWrapper = new JFreeChartNode(jFreeChart);
        this._closeButtonNode = new CloseButtonNode();
        this._closeButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PotentialEnergyChartNode.this.setVisible(false);
            }
        });
        this._beadNode = new BeadNode(20.0);
        this.addChild(this._chartWrapper);
        this.addChild(this._closeButtonNode);
        this.addChild(this._beadNode);
        this.setPickable(false);
        this._chartWrapper.setPickable(false);
        this._chartWrapper.setChildrenPickable(false);
        double d2 = this._laser.getMinPotentialEnergy();
        double d3 = this._laser.getMaxPotentialEnergy();
        this._plot.setPotentialEnergyRange(d2 * 1.02, d3);
        this.updateLayout();
        this.updateCurve();
        this.updateBeadPosition();
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            if (bl) {
                this.updateCurve();
                this.updateBeadPosition();
            }
            super.setVisible(bl);
        }
    }

    public void setChartSize(double d, double d2) {
        this._chartWrapper.setBounds(0.0, 0.0, d, d2);
        this._chartWrapper.updateChartRenderingInfo();
        this.updateLayout();
        Rectangle2D rectangle2D = this.getPlotBounds();
        double d3 = this._modelViewTransform.viewToModel(rectangle2D.getMinX());
        double d4 = this._modelViewTransform.viewToModel(rectangle2D.getMaxX());
        this._plot.setPositionRange(d3, d4);
        this.updateCurve();
        this.updateBeadPosition();
    }

    public Rectangle2D getPlotBounds() {
        ChartRenderingInfo chartRenderingInfo = this._chartWrapper.getChartRenderingInfo();
        PlotRenderingInfo plotRenderingInfo = chartRenderingInfo.getPlotInfo();
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        ((Rectangle2D)double_).setRect(rectangle2D);
        return double_;
    }

    public void update(Observable observable, Object object) {
        if (this.isVisible()) {
            if (observable == this._laser) {
                if (object == "position" || object == "power" || object == "running") {
                    this.updateCurve();
                }
            } else if (observable == this._bead && object == "position") {
                this.updateBeadPosition();
            }
        }
    }

    private void updateLayout() {
        PBounds pBounds = this._chartWrapper.getFullBoundsReference();
        PBounds pBounds2 = this._closeButtonNode.getFullBoundsReference();
        double d = pBounds.getWidth();
        double d2 = pBounds2.getHeight() + 15.0;
        double d3 = 0.0;
        double d4 = 0.0;
        d3 = 0.0;
        d4 = 0.0;
        this._chartWrapper.setOffset(d3, d4);
        d3 = d - 15.0 - pBounds2.getWidth();
        d4 = (d2 - pBounds2.getHeight()) / 2.0;
        this._closeButtonNode.setOffset(d3, d4);
    }

    private void updateCurve() {
        this._plot.clear();
        double d = this._bead.getY();
        double d2 = this._plot.getPositionRange().getUpperBound();
        for (double d3 = this._plot.getPositionRange().getLowerBound(); d3 <= d2; d3 += this._sampleWidth) {
            double d4 = this._laser.getPotentialEnergy(d3, d);
            this._plot.addData(d3, d4);
        }
    }

    private void updateBeadPosition() {
        double d = this._bead.getX();
        double d2 = this._bead.getPotentialEnergy();
        Rectangle2D rectangle2D = this.getPlotBounds();
        double d3 = this._plot.getPositionRange().getLowerBound();
        double d4 = this._plot.getPositionRange().getUpperBound();
        double d5 = this._plot.getPotentialEnergyRange().getLowerBound();
        double d6 = this._plot.getPotentialEnergyRange().getUpperBound();
        if (d < d3 || d > d4) {
            this._beadNode.setVisible(false);
        } else {
            this._beadNode.setVisible(true);
            double d7 = this._chartWrapper.getXOffset() + rectangle2D.getMinX() + rectangle2D.getWidth() * (d - d3) / (d4 - d3);
            double d8 = this._chartWrapper.getYOffset() + rectangle2D.getMaxY() - rectangle2D.getHeight() * (d2 - d5) / (d6 - d5);
            this._beadNode.setOffset(d7, d8);
        }
    }
}

