/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.charts;

import edu.colorado.phet.common.jfreechartphet.PhetHistogramDataset;
import edu.colorado.phet.common.jfreechartphet.PhetHistogramSeries;
import edu.colorado.phet.opticaltweezers.OTResources;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public class PositionHistogramPlot
extends XYPlot {
    private static final Color BAR_FILL_COLOR = Color.BLUE;
    private static final Color BAR_OUTLINE_COLOR = Color.BLACK;
    private PhetHistogramDataset _dataset = new PhetHistogramDataset();
    private PhetHistogramSeries _series;
    private NumberAxis _xAxis;
    private NumberAxis _yAxis;
    private List _observationsCache;

    public PositionHistogramPlot() {
        this.setDataset(this._dataset);
        this._series = null;
        this._observationsCache = new ArrayList();
        PositionHistogramRenderer positionHistogramRenderer = new PositionHistogramRenderer();
        positionHistogramRenderer.setPaint(BAR_FILL_COLOR);
        positionHistogramRenderer.setOutlinePaint(BAR_OUTLINE_COLOR);
        positionHistogramRenderer.setDrawBarOutline(false);
        this.setRenderer(positionHistogramRenderer);
        this._xAxis = new NumberAxis();
        this._xAxis.setLabel(OTResources.getString("axis.relativePosition"));
        this._xAxis.setTickLabelsVisible(true);
        this._xAxis.setTickMarksVisible(true);
        this._xAxis.setVisible(true);
        this.setDomainAxis(this._xAxis);
        this._yAxis = new NumberAxis();
        this._yAxis.setLabel(null);
        this._yAxis.setTickLabelsVisible(false);
        this._yAxis.setTickMarksVisible(false);
        this._yAxis.setAutoRange(false);
        this._yAxis.setRange(0.0, 10.0);
        this.setRangeAxis(this._yAxis);
        this.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        this.setDomainGridlinesVisible(false);
        this.setRangeGridlinesVisible(false);
        this.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        this.setPositionRange(0.0, 1.0, 1.0);
    }

    public void setPositionRange(double d, double d2, double d3) {
        this._xAxis.setRange(d, d2);
        int n = (int)((d2 - d) / d3);
        if (this._series != null) {
            this._dataset.removeSeries(this._series);
        }
        this._series = new PhetHistogramSeries((Comparable)((Object)"position"), d, d2, n);
        this._dataset.addSeries(this._series);
        int n2 = this._observationsCache.size();
        if (n2 > 0) {
            for (int i = 0; i < n2 - 1; ++i) {
                double d4 = (Double)this._observationsCache.get(i);
                if (!(d4 >= d) || !(d4 <= d2)) continue;
                this._series.addObservation(d4, false);
            }
            this._series.fireSeriesChanged();
        }
    }

    public void addPosition(double d) {
        this._series.addObservation(d);
        this._observationsCache.add(new Double(d));
        while (this._observationsCache.size() > 30000) {
            this._observationsCache.remove(0);
        }
        if (!this._yAxis.isAutoRange() && this._series.getMaxObservations() > 10) {
            this._yAxis.setAutoRange(true);
        }
    }

    public void clear() {
        this._series.clear();
        this._observationsCache.clear();
        this._yAxis.setAutoRange(false);
        this._yAxis.setRange(0.0, 10.0);
    }

    private static class PositionHistogramRenderer
    extends XYBarRenderer {
        private PositionHistogramRenderer() {
        }

        public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
            PhetHistogramSeries phetHistogramSeries = ((PhetHistogramDataset)xYDataset).getSeries(n);
            if (phetHistogramSeries.getNumberOfObservations() == 0) {
                return;
            }
            super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairState, n3);
        }
    }
}

