/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.jfreechartphet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.general.Series;

public class PhetHistogramSeries
extends Series {
    private final double minimum;
    private final double maximum;
    private final double binWidth;
    private int numberOfObservations;
    private final List bins;
    private boolean ignoreOutOfRangeObservations;

    public PhetHistogramSeries(Comparable comparable, double d, double d2, int n) {
        this(comparable, d, d2, n, null);
    }

    public PhetHistogramSeries(Comparable comparable, double d, double d2, int n, double[] dArray) {
        super(comparable);
        int n2;
        if (comparable == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(d < d2)) {
            throw new IllegalArgumentException("minimum must be < maximum");
        }
        if (n < 1) {
            throw new IllegalArgumentException("numberOfBins must be >= 1");
        }
        this.minimum = d;
        this.maximum = d2;
        this.binWidth = (d2 - d) / (double)n;
        this.ignoreOutOfRangeObservations = true;
        this.numberOfObservations = 0;
        double d3 = d;
        ArrayList<PhetHistogramBin> arrayList = new ArrayList<PhetHistogramBin>(n);
        for (n2 = 0; n2 < n; ++n2) {
            double d4 = n2 == n - 1 ? d2 : d + (double)(n2 + 1) * this.binWidth;
            arrayList.add(new PhetHistogramBin(d3, d4));
            d3 = d4;
            d4 = d3 + this.binWidth;
        }
        this.bins = arrayList;
        if (dArray != null) {
            for (n2 = 0; n2 < dArray.length; ++n2) {
                this.addObservation(dArray[n2]);
            }
        }
    }

    public int getNumberOfBins() {
        return this.bins.size();
    }

    public double getBinWidth() {
        return this.binWidth;
    }

    public int getNumberOfObservations() {
        return this.numberOfObservations;
    }

    public int getNumberOfObservations(int n) {
        return this.getBin(n).getNumberOfObservations();
    }

    public double getStartBoundary(int n) {
        return this.getBin(n).getStartBoundary();
    }

    public double getEndBoundary(int n) {
        return this.getBin(n).getEndBoundary();
    }

    public int getMaxObservations() {
        int n = 0;
        int n2 = this.getNumberOfBins();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getBin(i).getNumberOfObservations();
            if (n3 <= n) continue;
            n = n3;
        }
        return n;
    }

    private PhetHistogramBin getBin(int n) {
        return (PhetHistogramBin)this.bins.get(n);
    }

    public void addObservation(double d) {
        this.addObservation(d, true);
    }

    public void addObservation(double d, boolean bl) {
        if (d >= this.minimum && d <= this.maximum) {
            int n;
            int n2 = this.getNumberOfBins();
            double d2 = (d - this.minimum) / (this.maximum - this.minimum);
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            if ((n = (int)(d2 * (double)n2)) >= n2) {
                n = n2 - 1;
            }
            this.getBin(n).increment();
            ++this.numberOfObservations;
            if (bl) {
                this.fireSeriesChanged();
            }
        } else if (!this.ignoreOutOfRangeObservations) {
            throw new IllegalArgumentException("series " + this.getKey() + " observation is out of range: " + d);
        }
    }

    public void clear() {
        Iterator iterator = this.bins.iterator();
        while (iterator.hasNext()) {
            ((PhetHistogramBin)iterator.next()).clear();
        }
        this.numberOfObservations = 0;
        this.fireSeriesChanged();
    }

    private static class PhetHistogramBin {
        private final double startBoundary;
        private final double endBoundary;
        private int numberOfObservations;

        public PhetHistogramBin(double d, double d2) {
            this.startBoundary = d;
            this.endBoundary = d2;
            this.numberOfObservations = 0;
        }

        public double getStartBoundary() {
            return this.startBoundary;
        }

        public double getEndBoundary() {
            return this.endBoundary;
        }

        public int getNumberOfObservations() {
            return this.numberOfObservations;
        }

        public void increment() {
            ++this.numberOfObservations;
        }

        public void clear() {
            this.numberOfObservations = 0;
        }

        public String toString() {
            return "startBoundary=" + this.startBoundary + " endBoundary=" + this.endBoundary + " numberOfObservations=" + this.numberOfObservations;
        }
    }
}

