/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticalquantumcontrol.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.opticalquantumcontrol.model.FourierSeries;
import edu.colorado.phet.opticalquantumcontrol.view.HarmonicColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class LightRays
extends CompositePhetGraphic
implements SimpleObserver {
    private FourierSeries _fourierSeries;
    private ArrayList _outputBars;
    private ArrayList _outputRays;
    private PhetShapeGraphic _outputBeam;

    public LightRays(Component component, FourierSeries fourierSeries) {
        super(component);
        PhetShapeGraphic phetShapeGraphic;
        int n;
        Object object;
        Object object2;
        Point[] pointArray;
        int n2;
        this._fourierSeries = fourierSeries;
        this._fourierSeries.addObserver(this);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this.setIgnoreMouse(true);
        int n3 = fourierSeries.getNumberOfHarmonics();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            pointArray = new Rectangle2D.Double(n4, 0.0, 27.0, 325.0);
            object2 = HarmonicColors.getInstance().getColor(n2);
            Color color = new Color(((Color)object2).getRed(), ((Color)object2).getGreen(), ((Color)object2).getBlue(), 200);
            object = new PhetShapeGraphic(component);
            ((PhetShapeGraphic)object).setShape((Shape)pointArray);
            ((PhetShapeGraphic)object).setColor(color);
            this.addGraphic((PhetGraphic)object);
            n4 += 37;
        }
        this._outputBars = new ArrayList();
        n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            pointArray = new Rectangle2D.Double(n4, 325.0, 27.0, 325.0);
            object2 = new PhetShapeGraphic(component);
            ((PhetShapeGraphic)object2).setShape((Shape)pointArray);
            this.addGraphic((PhetGraphic)object2);
            n4 += 37;
            this._outputBars.add(object2);
        }
        Object object3 = new Point(344, 221);
        pointArray = new Point[]{new Point(0, 23), new Point(27, 19), new Point(37, 19), new Point(64, 15), new Point(74, 15), new Point(101, 15), new Point(111, 15), new Point(138, 15), new Point(148, 15), new Point(175, 15), new Point(185, 15), new Point(212, 19), new Point(222, 19), new Point(249, 23)};
        int n5 = 0;
        for (n = 0; n < pointArray.length; ++n) {
            object = new GeneralPath();
            ((Path2D.Float)object).moveTo(((Point)object3).x, ((Point)object3).y);
            ((Path2D.Float)object).lineTo(pointArray[n].x, pointArray[n].y);
            ((Path2D.Float)object).lineTo(pointArray[++n].x, pointArray[n].y);
            ((Path2D)object).closePath();
            phetShapeGraphic = new PhetShapeGraphic(component);
            phetShapeGraphic.setShape((Shape)object);
            Color color = HarmonicColors.getInstance().getColor(n5++);
            Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 200);
            phetShapeGraphic.setColor(color2);
            phetShapeGraphic.setLocation(0, 0);
            this.addGraphic(phetShapeGraphic);
        }
        object3 = new Point(344, 423);
        pointArray = new Point[]{new Point(0, 622), new Point(27, 626), new Point(37, 626), new Point(64, 630), new Point(74, 630), new Point(101, 630), new Point(111, 630), new Point(138, 630), new Point(148, 630), new Point(175, 630), new Point(185, 630), new Point(212, 626), new Point(222, 626), new Point(249, 622)};
        this._outputRays = new ArrayList();
        n5 = 0;
        for (n = 0; n < pointArray.length; ++n) {
            object = new GeneralPath();
            ((Path2D.Float)object).moveTo(((Point)object3).x, ((Point)object3).y);
            ((Path2D.Float)object).lineTo(pointArray[n].x, pointArray[n].y);
            ((Path2D.Float)object).lineTo(pointArray[++n].x, pointArray[n].y);
            ((Path2D)object).closePath();
            phetShapeGraphic = new PhetShapeGraphic(component);
            phetShapeGraphic.setShape((Shape)object);
            phetShapeGraphic.setLocation(0, 0);
            this.addGraphic(phetShapeGraphic);
            this._outputRays.add(phetShapeGraphic);
        }
        object3 = new PhetShapeGraphic(component);
        ((PhetShapeGraphic)object3).setShape(new Rectangle(0, 0, 10, 130));
        ((PhetShapeGraphic)object3).setColor(new Color(255, 255, 255, 200));
        ((PhetGraphic)object3).rotate(Math.toRadians(8.0));
        ((PhetGraphic)object3).setLocation(361, 99);
        ((PhetGraphic)object3).setIgnoreMouse(true);
        this.addGraphic((PhetGraphic)object3);
        this._outputBeam = new PhetShapeGraphic(component);
        this._outputBeam.setShape(new Rectangle(0, 0, 10, 130));
        this._outputBeam.rotate(Math.toRadians(-188.0));
        this._outputBeam.setLocation(371, 545);
        this._outputBeam.setIgnoreMouse(true);
        this.addGraphic(this._outputBeam);
        this.update();
    }

    public void update() {
        int n;
        int n2 = this._fourierSeries.getNumberOfHarmonics();
        double d = 0.0;
        for (n = 0; n < n2; ++n) {
            double d2 = this._fourierSeries.getHarmonic(n).getAmplitude();
            int n3 = 0;
            if (Math.abs(d2) > 0.0) {
                n3 = 25 + (int)Math.abs(175.0 * d2 / 1.0);
            }
            Color color = HarmonicColors.getInstance().getColor(n);
            Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), n3);
            PhetShapeGraphic phetShapeGraphic = (PhetShapeGraphic)this._outputBars.get(n);
            phetShapeGraphic.setColor(color2);
            PhetShapeGraphic phetShapeGraphic2 = (PhetShapeGraphic)this._outputRays.get(n);
            phetShapeGraphic2.setColor(color2);
            d += Math.abs(d2);
        }
        n = 0;
        if (d > 0.0) {
            n = 25 + (int)Math.abs(175.0 * d / ((double)n2 * 1.0));
        }
        Color color = new Color(255, 255, 255, n);
        this._outputBeam.setColor(color);
    }
}

