/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticalquantumcontrol.view;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.opticalquantumcontrol.OQCResources;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class AmplitudesChart
extends Chart {
    private static final Color AXIS_COLOR = Color.BLACK;
    private static final Stroke AXIS_STROKE = new BasicStroke(1.0f);
    private static final Font AXIS_TITLE_FONT = new PhetFont(1, 16);
    private static final Color AXIS_TITLE_COLOR = Color.BLACK;
    private static final String X_AXIS_LABEL = OQCResources.AMPLITUDE_X_AXIS_LABEL;
    private static final Stroke Y_MAJOR_TICK_STROKE = new BasicStroke(1.0f);
    private static final Stroke Y_MINOR_TICK_STROKE = new BasicStroke(1.0f);
    private static final Font Y_MAJOR_TICK_FONT = new PhetFont(1, 12);
    private static final Color MAJOR_GRIDLINE_COLOR = Color.BLACK;
    private static final Color MINOR_GRIDLINE_COLOR = Color.BLACK;
    private static final Stroke MAJOR_GRIDLINE_STROKE = new BasicStroke(0.25f);
    private static final Stroke MINOR_GRIDLINE_STROKE = new BasicStroke(0.25f);
    private static final NumberFormat RANGE_LABELS_FORMAT = new DecimalFormat("0.00");

    public AmplitudesChart(Component component, Range2D range2D, Dimension dimension) {
        super(component, range2D, dimension);
        this.getXAxis().setStroke(AXIS_STROKE);
        this.getXAxis().setColor(AXIS_COLOR);
        HTMLGraphic hTMLGraphic = new HTMLGraphic(component, AXIS_TITLE_FONT, X_AXIS_LABEL, AXIS_TITLE_COLOR);
        hTMLGraphic.setRegistrationPoint(-2, hTMLGraphic.getHeight() / 2);
        this.setXAxisTitle(hTMLGraphic);
        this.getHorizontalTicks().setVisible(false);
        this.getXAxis().setMajorTicksVisible(false);
        this.getXAxis().setMinorTicksVisible(false);
        this.getXAxis().setMajorTickLabelsVisible(false);
        this.getXAxis().setMinorTickLabelsVisible(false);
        this.getVerticalGridlines().setMinorGridlinesVisible(false);
        this.getVerticalGridlines().setMajorGridlinesVisible(false);
        this.getYAxis().setStroke(AXIS_STROKE);
        this.getYAxis().setColor(AXIS_COLOR);
        this.getYAxis().setMajorTicksVisible(false);
        this.getYAxis().setMajorTickLabelsVisible(false);
        this.getYAxis().setMinorTicksVisible(false);
        this.getYAxis().setMinorTickLabelsVisible(false);
        this.getVerticalTicks().setRangeLabelsVisible(false);
        this.getVerticalTicks().setRangeLabelsNumberFormat(RANGE_LABELS_FORMAT);
        this.getVerticalTicks().setMajorTicksVisible(true);
        this.getVerticalTicks().setMajorTickLabelsVisible(true);
        this.getVerticalTicks().setMajorTickSpacing(0.5);
        this.getVerticalTicks().setMajorTickStroke(Y_MAJOR_TICK_STROKE);
        this.getVerticalTicks().setMajorTickFont(Y_MAJOR_TICK_FONT);
        this.getHorizonalGridlines().setMajorGridlinesVisible(true);
        this.getHorizonalGridlines().setMajorTickSpacing(0.5);
        this.getHorizonalGridlines().setMajorGridlinesColor(MAJOR_GRIDLINE_COLOR);
        this.getHorizonalGridlines().setMajorGridlinesStroke(MAJOR_GRIDLINE_STROKE);
        this.getHorizonalGridlines().setMinorGridlinesVisible(false);
        this.getHorizonalGridlines().setMinorTickSpacing(0.1);
        this.getHorizonalGridlines().setMinorGridlinesColor(MINOR_GRIDLINE_COLOR);
        this.getHorizonalGridlines().setMinorGridlinesStroke(MINOR_GRIDLINE_STROKE);
    }
}

