/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticalquantumcontrol.model;

import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.opticalquantumcontrol.model.Harmonic;
import java.util.ArrayList;

public class FourierSeries
extends SimpleObservable
implements SimpleObserver {
    private double _fundamentalFrequency;
    private ArrayList _harmonics;
    private ArrayList _availableHarmonics;
    private boolean _adjusting;

    public FourierSeries() {
        this(1, 440.0);
    }

    public FourierSeries(int n, double d) {
        this._fundamentalFrequency = d;
        this._harmonics = new ArrayList();
        this._availableHarmonics = new ArrayList();
        this._adjusting = false;
        this.setNumberOfHarmonics(n);
    }

    public void setNumberOfHarmonics(int n) {
        assert (n > 0);
        Harmonic harmonic = null;
        int n2 = this._harmonics.size();
        if (n != n2) {
            this._adjusting = true;
            if (n < n2) {
                int n3 = n2 - n;
                for (int i = n2 - 1; i > n2 - n3 - 1; --i) {
                    harmonic = (Harmonic)this._harmonics.get(i);
                    harmonic.removeAllObservers();
                    harmonic.setAmplitude(0.0);
                    this._availableHarmonics.add(harmonic);
                    this._harmonics.remove(i);
                }
            } else {
                int n4 = n - n2;
                for (int i = 0; i < n4; ++i) {
                    int n5 = this._availableHarmonics.size();
                    if (n5 > 0) {
                        harmonic = (Harmonic)this._availableHarmonics.get(n5 - 1);
                        this._availableHarmonics.remove(n5 - 1);
                        harmonic.setOrder(n2 + i);
                    } else {
                        harmonic = new Harmonic(n2 + i);
                    }
                    this._harmonics.add(harmonic);
                    harmonic.addObserver(this);
                }
            }
            this.notifyObservers();
            this._adjusting = false;
        }
    }

    public int getNumberOfHarmonics() {
        return this._harmonics.size();
    }

    public Harmonic getHarmonic(int n) {
        assert (n >= 0 && n < this._harmonics.size());
        return (Harmonic)this._harmonics.get(n);
    }

    public void setAdjusting(boolean bl) {
        this._adjusting = bl;
        if (!this._adjusting) {
            this.update();
        }
    }

    public void update() {
        if (!this._adjusting) {
            this.notifyObservers();
        }
    }
}

