/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticalquantumcontrol.help;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.opticalquantumcontrol.OQCResources;
import edu.colorado.phet.opticalquantumcontrol.help.HelpBubble;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;

public class ExplanationDialog
extends PaintImmediateDialog {
    private static final Color BACKGROUND_COLOR = Color.WHITE;
    private static final Color BUBBLE_COLOR;
    private static final Color BUBBLE_ARROW_COLOR;
    private static final Color BUBBLE_TEXT_COLOR;
    private static final Color TEXT_COLOR;

    public ExplanationDialog(Frame frame) {
        super(frame, false);
        this.setTitle(OQCResources.EXPLANATION_TITLE);
        this.setResizable(false);
        ApparatusPanel apparatusPanel = new ApparatusPanel();
        apparatusPanel.setBackground(BACKGROUND_COLOR);
        CompositePhetGraphic compositePhetGraphic = new CompositePhetGraphic(apparatusPanel);
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic(apparatusPanel, OQCResources.EXPLANATION_IMAGE);
        phetImageGraphic.setLocation(0, 0);
        compositePhetGraphic.addGraphic(phetImageGraphic);
        CompositePhetGraphic compositePhetGraphic2 = new HelpBubble(apparatusPanel, OQCResources.EXPLANATION_MASK);
        ((HelpBubble)compositePhetGraphic2).setColors(BUBBLE_TEXT_COLOR, BUBBLE_COLOR, BUBBLE_ARROW_COLOR);
        ((HelpBubble)compositePhetGraphic2).pointAt(new Point(100, 175), 7, 40);
        compositePhetGraphic.addGraphic(compositePhetGraphic2);
        HelpBubble helpBubble = new HelpBubble(apparatusPanel, OQCResources.EXPLANATION_MIRROR);
        helpBubble.setColors(BUBBLE_TEXT_COLOR, BUBBLE_COLOR, BUBBLE_ARROW_COLOR);
        helpBubble.pointAt(new Point(605, 205), 10, 50);
        compositePhetGraphic.addGraphic(helpBubble);
        HelpBubble helpBubble2 = new HelpBubble(apparatusPanel, OQCResources.EXPLANATION_GRATING);
        helpBubble2.setColors(BUBBLE_TEXT_COLOR, BUBBLE_COLOR, BUBBLE_ARROW_COLOR);
        helpBubble2.pointAt(new Point(320, 420), 11, 40);
        compositePhetGraphic.addGraphic(helpBubble2);
        int n = OQCResources.EXPLANATION_FONT_SIZE;
        compositePhetGraphic2 = new HTMLGraphic(apparatusPanel);
        compositePhetGraphic2.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        ((HTMLGraphic)compositePhetGraphic2).setFont(new PhetFont(0, n));
        ((HTMLGraphic)compositePhetGraphic2).setColor(TEXT_COLOR);
        ((HTMLGraphic)compositePhetGraphic2).setHTML(OQCResources.EXPLANATION_TEXT);
        compositePhetGraphic.setRegistrationPoint(compositePhetGraphic.getWidth() / 2, 0);
        compositePhetGraphic.setLocation(Math.max(compositePhetGraphic.getWidth() / 2, compositePhetGraphic2.getWidth() / 2) + 20, 10);
        apparatusPanel.addGraphic(compositePhetGraphic);
        compositePhetGraphic2.setLocation(20, compositePhetGraphic.getHeight() + 20);
        apparatusPanel.addGraphic(compositePhetGraphic2);
        this.getContentPane().add(apparatusPanel);
        int n2 = Math.max(compositePhetGraphic.getWidth(), compositePhetGraphic2.getWidth()) + 40;
        int n3 = compositePhetGraphic.getHeight() + compositePhetGraphic2.getHeight() + 40 + 50;
        this.setSize(n2, n3);
        this.center();
    }

    private void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        this.setLocation(n3, n4);
    }

    static {
        BUBBLE_ARROW_COLOR = BUBBLE_COLOR = new Color(250, 250, 170);
        BUBBLE_TEXT_COLOR = Color.BLACK;
        TEXT_COLOR = Color.BLACK;
    }
}

