/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticalquantumcontrol.enums;

import edu.colorado.phet.opticalquantumcontrol.enums.AbstractEnum;

public class MoleculeEnum
extends AbstractEnum {
    public static final MoleculeEnum UNDEFINED = new MoleculeEnum("undefined");
    public static final MoleculeEnum MOLECULE0 = new MoleculeEnum("molecule0");
    public static final MoleculeEnum MOLECULE1 = new MoleculeEnum("molecule1");
    public static final MoleculeEnum MOLECULE2 = new MoleculeEnum("molecule2");
    public static final MoleculeEnum MOLECULE3 = new MoleculeEnum("molecule3");
    public static final MoleculeEnum MOLECULE4 = new MoleculeEnum("molecule4");
    public static final MoleculeEnum MOLECULE5 = new MoleculeEnum("molecule5");
    public static final MoleculeEnum MOLECULE6 = new MoleculeEnum("molecule6");
    public static final MoleculeEnum MOLECULE7 = new MoleculeEnum("molecule7");
    private static final MoleculeEnum[] MOLECULES = new MoleculeEnum[]{MOLECULE0, MOLECULE1, MOLECULE2, MOLECULE3, MOLECULE4, MOLECULE5, MOLECULE6, MOLECULE7};
    private static final double[] MOLECULE0_AMPLITUDES = new double[]{0.29, 1.0, 0.86, 0.29, 1.0, 0.57, -0.13};
    private static final double[] MOLECULE1_AMPLITUDES = new double[]{-1.0, -0.23, 0.89, -0.77, 0.21, 0.49, -0.76};
    private static final double[] MOLECULE2_AMPLITUDES = new double[]{-0.65, 0.83, -0.65, 0.17, 0.53, -1.0, 0.58};
    private static final double[] MOLECULE3_AMPLITUDES = new double[]{0.47, 1.0, 0.96, 0.75, 0.13, 0.18, 0.49};
    private static final double[] MOLECULE4_AMPLITUDES = new double[]{1.0, 0.37, 1.0, 0.49, -0.35, 0.23, -0.69};
    private static final double[] MOLECULE5_AMPLITUDES = new double[]{-0.74, 0.2, 0.36, 0.86, 0.01, -0.24, 1.0};
    private static final double[] MOLECULE6_AMPLITUDES = new double[]{0.3, 0.26, -0.51, -1.0, -0.19, -0.06, -0.32};
    private static final double[] MOLECULE7_AMPLITUDES = new double[]{0.95, 1.0, -0.16, -0.2, 0.07, 0.59, 0.53};

    private MoleculeEnum(String string) {
        super(string);
    }

    public static int size() {
        return MOLECULES.length;
    }

    public static MoleculeEnum getByIndex(int n) {
        if (n >= MOLECULES.length) {
            throw new IllegalArgumentException("index out of range: " + n);
        }
        return MOLECULES[n];
    }

    public static double[] getAmplitudes(MoleculeEnum moleculeEnum) {
        double[] dArray = null;
        if (moleculeEnum == MOLECULE0) {
            dArray = MOLECULE0_AMPLITUDES;
        } else if (moleculeEnum == MOLECULE1) {
            dArray = MOLECULE1_AMPLITUDES;
        } else if (moleculeEnum == MOLECULE2) {
            dArray = MOLECULE2_AMPLITUDES;
        } else if (moleculeEnum == MOLECULE3) {
            dArray = MOLECULE3_AMPLITUDES;
        } else if (moleculeEnum == MOLECULE4) {
            dArray = MOLECULE4_AMPLITUDES;
        } else if (moleculeEnum == MOLECULE5) {
            dArray = MOLECULE5_AMPLITUDES;
        } else if (moleculeEnum == MOLECULE6) {
            dArray = MOLECULE6_AMPLITUDES;
        } else if (moleculeEnum == MOLECULE7) {
            dArray = MOLECULE7_AMPLITUDES;
        }
        return dArray;
    }
}

