/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticalquantumcontrol.charts;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class PulseChart
extends Chart {
    private static final Color AXIS_COLOR = Color.BLACK;
    private static final Stroke AXIS_STROKE = new BasicStroke(2.0f);
    private static final Font AXIS_TITLE_FONT = new PhetFont(1, 16);
    private static final Color AXIS_TITLE_COLOR = Color.BLACK;
    private static final NumberFormat RANGE_LABELS_FORMAT = new DecimalFormat("0.00");
    private static final Stroke MAJOR_TICK_STROKE = new BasicStroke(1.0f);
    private static final Font MAJOR_TICK_FONT = new PhetFont(1, 12);
    private static final Color MAJOR_TICK_COLOR = Color.BLACK;
    private static final Stroke MINOR_TICK_STROKE = MAJOR_TICK_STROKE;
    private static final Font MINOR_TICK_FONT = MAJOR_TICK_FONT;
    private static final Color MINOR_TICK_COLOR = MAJOR_TICK_COLOR;
    private static final Color MAJOR_GRIDLINE_COLOR = Color.BLACK;
    private static final Stroke MAJOR_GRIDLINE_STROKE = new BasicStroke(0.25f);
    private static final Color MINOR_GRIDLINE_COLOR = Color.BLACK;
    private static final Stroke MINOR_GRIDLINE_STROKE = new BasicStroke(0.25f);
    private HTMLGraphic _xAxisTitleGraphic;

    public PulseChart(Component component, Range2D range2D, Dimension dimension) {
        super(component, range2D, dimension);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this.getXAxis().setStroke(AXIS_STROKE);
        this.getXAxis().setColor(AXIS_COLOR);
        this._xAxisTitleGraphic = new HTMLGraphic(component, AXIS_TITLE_FONT, "", AXIS_TITLE_COLOR);
        this.setXAxisTitle(this._xAxisTitleGraphic);
        this.getXAxis().setMajorTicksVisible(false);
        this.getXAxis().setMajorTickLabelsVisible(false);
        this.getXAxis().setMinorTicksVisible(false);
        this.getXAxis().setMinorTickLabelsVisible(false);
        this.getHorizontalTicks().setMajorTicksVisible(true);
        this.getHorizontalTicks().setMajorTickLabelsVisible(true);
        this.getHorizontalTicks().setMajorTickSpacing(0.25);
        this.getHorizontalTicks().setMajorTickStroke(MAJOR_TICK_STROKE);
        this.getHorizontalTicks().setMajorTickFont(MAJOR_TICK_FONT);
        this.getHorizontalTicks().setMajorNumberFormat(new DecimalFormat("#.##"));
        this.getVerticalGridlines().setMajorGridlinesVisible(true);
        this.getVerticalGridlines().setMajorTickSpacing(0.25);
        this.getVerticalGridlines().setMajorGridlinesColor(MAJOR_GRIDLINE_COLOR);
        this.getVerticalGridlines().setMajorGridlinesStroke(MAJOR_GRIDLINE_STROKE);
        this.getVerticalGridlines().setMinorGridlinesVisible(true);
        this.getVerticalGridlines().setMinorTickSpacing(0.125);
        this.getVerticalGridlines().setMinorGridlinesColor(MINOR_GRIDLINE_COLOR);
        this.getVerticalGridlines().setMinorGridlinesStroke(MINOR_GRIDLINE_STROKE);
        this.getYAxis().setStroke(AXIS_STROKE);
        this.getYAxis().setColor(AXIS_COLOR);
        this.getYAxis().setMajorTicksVisible(false);
        this.getYAxis().setMajorTickLabelsVisible(false);
        this.getYAxis().setMinorTicksVisible(false);
        this.getYAxis().setMinorTickLabelsVisible(false);
        this.getVerticalTicks().setRangeLabelsVisible(false);
        this.getVerticalTicks().setRangeLabelsNumberFormat(RANGE_LABELS_FORMAT);
        this.getVerticalTicks().setMajorTicksVisible(true);
        this.getVerticalTicks().setMajorTickLabelsVisible(true);
        this.getVerticalTicks().setMajorTickSpacing(5.0);
        this.getVerticalTicks().setMajorTickStroke(MAJOR_TICK_STROKE);
        this.getVerticalTicks().setMajorTickFont(MAJOR_TICK_FONT);
        this.getHorizonalGridlines().setMajorGridlinesVisible(true);
        this.getHorizonalGridlines().setMajorTickSpacing(5.0);
        this.getHorizonalGridlines().setMajorGridlinesColor(MAJOR_GRIDLINE_COLOR);
        this.getHorizonalGridlines().setMajorGridlinesStroke(MAJOR_GRIDLINE_STROKE);
        this.getHorizonalGridlines().setMinorGridlinesVisible(true);
        this.getHorizonalGridlines().setMinorTickSpacing(1.0);
        this.getHorizonalGridlines().setMinorGridlinesColor(MINOR_GRIDLINE_COLOR);
        this.getHorizonalGridlines().setMinorGridlinesStroke(MINOR_GRIDLINE_STROKE);
        this.autoscaleY(range2D.getMaxY());
    }

    public void setXAxisTitle(String string) {
        this._xAxisTitleGraphic.setHTML(string);
        this._xAxisTitleGraphic.setRegistrationPoint(-3, this._xAxisTitleGraphic.getHeight() / 2);
    }

    public void autoscaleY(double d) {
        if (d < 1.0) {
            d = 1.0;
        }
        Range2D range2D = this.getRange();
        range2D.setMaxY(d);
        range2D.setMinY(-d);
        this.setRange(range2D);
        double d2 = range2D.getMaxY() < 2.0 ? 0.5 : (range2D.getMaxY() < 5.0 ? 1.0 : 5.0);
        this.getVerticalTicks().setMajorTickSpacing(d2);
        this.getHorizonalGridlines().setMajorTickSpacing(d2);
    }
}

