/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.charts;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.Orientation;
import java.util.ArrayList;

public interface GridStrategy {
    public double[] getVisibleGridLines(Chart var1);

    public static class Relative
    implements GridStrategy {
        private Orientation orientation;
        private double spacing;
        private double crossesOtherAxisAt;

        public Relative(Orientation orientation, double d, double d2) {
            this.orientation = orientation;
            this.spacing = d;
            this.crossesOtherAxisAt = d2;
        }

        public void setSpacing(double d) {
            this.spacing = d;
        }

        public double[] getVisibleGridLines(Chart chart) {
            if (this.orientation.isVertical()) {
                return Relative.getGridLinesSlowButCorrectVersion(this.crossesOtherAxisAt, chart.getRange().getMinX(), chart.getRange().getMaxX(), this.spacing);
            }
            if (this.orientation.isHorizontal()) {
                return Relative.getGridLinesSlowButCorrectVersion(this.crossesOtherAxisAt, chart.getRange().getMinY(), chart.getRange().getMaxY(), this.spacing);
            }
            throw new RuntimeException("Illegal Orientation");
        }

        double getCrossesOtherAxisAt() {
            return this.crossesOtherAxisAt;
        }

        private static double[] getGridLinesSlowButCorrectVersion(double d, double d2, double d3, double d4) {
            double d5;
            int n = (int)Math.ceil((d3 - d2) / d4);
            if (n > 100) {
                System.out.println("WARNING: GridStrategy.Relative.getGridLinesSlowButCorrectVersion - large number of gridlines: " + n);
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (d5 = d; d5 <= d3; d5 += d4) {
                if (!(d5 >= d2) || !(d5 <= d3)) continue;
                arrayList.add(new Double(d5));
            }
            for (d5 = d - d4; d5 >= d2; d5 -= d4) {
                if (!(d5 >= d2) || !(d5 <= d3)) continue;
                arrayList.add(new Double(d5));
            }
            double[] dArray = new double[arrayList.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = (Double)arrayList.get(i);
            }
            return dArray;
        }
    }
}

