/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.charts;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;

public class DataSet {
    private ArrayList dataPoints = new ArrayList();
    private ArrayList observers = new ArrayList();

    public void clear() {
        this.dataPoints.clear();
        for (int i = 0; i < this.observers.size(); ++i) {
            Observer observer = (Observer)this.observers.get(i);
            observer.cleared();
        }
    }

    public Point2D[] getPoints() {
        return this.dataPoints.toArray(new Point2D[0]);
    }

    public void addAllPoints(Point2D[] point2DArray) {
        this.addPoints(point2DArray);
    }

    public void addPoints(Point2D[] point2DArray) {
        this.dataPoints.addAll(Arrays.asList(point2DArray));
        for (int i = 0; i < this.observers.size(); ++i) {
            Observer observer = (Observer)this.observers.get(i);
            observer.pointsAdded(point2DArray);
        }
    }

    public void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    public void removeObserver(Observer observer) {
        this.observers.remove(observer);
    }

    public String toString() {
        return this.dataPoints.toString();
    }

    public static interface Observer {
        public void cleared();

        public void pointsAdded(Point2D[] var1);
    }
}

