/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.util.LineShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class PLine
extends PNode {
    private static final PAffineTransform TEMP_TRANSFORM = new PAffineTransform();
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Color DEFAULT_STROKE_PAINT = Color.black;
    private final transient LineShape lineShape;
    private transient Stroke stroke;
    private Paint strokePaint = DEFAULT_STROKE_PAINT;

    public PLine() {
        this(null);
    }

    public PLine(LineShape lineShape) {
        this.stroke = DEFAULT_STROKE;
        this.lineShape = lineShape == null ? new LineShape(null) : lineShape;
    }

    public void setStrokePaint(Paint paint) {
        Paint paint2 = this.strokePaint;
        this.strokePaint = paint;
        this.invalidatePaint();
        this.firePropertyChange(65536, "strokePaint", paint2, this.strokePaint);
    }

    public void setStroke(Stroke stroke) {
        Stroke stroke2 = this.stroke;
        this.stroke = stroke;
        this.updateBoundsFromLine();
        this.invalidatePaint();
        this.firePropertyChange(131072, "stroke", stroke2, this.stroke);
    }

    public boolean setBounds(double d, double d2, double d3, double d4) {
        if (this.lineShape == null || !super.setBounds(d, d2, d3, d4)) {
            return false;
        }
        Rectangle2D rectangle2D = this.lineShape.getBounds2D();
        Rectangle2D rectangle2D2 = this.getLineBoundsWithStroke();
        double d5 = Math.max(rectangle2D2.getWidth() - rectangle2D.getWidth(), rectangle2D2.getHeight() - rectangle2D.getHeight());
        double d6 = d + d5 / 2.0;
        double d7 = d2 + d5 / 2.0;
        double d8 = d3 - d5;
        double d9 = d4 - d5;
        TEMP_TRANSFORM.setToIdentity();
        TEMP_TRANSFORM.translate(d6, d7);
        TEMP_TRANSFORM.scale(d8 / rectangle2D.getWidth(), d9 / rectangle2D.getHeight());
        TEMP_TRANSFORM.translate(-rectangle2D.getX(), -rectangle2D.getY());
        this.lineShape.transformPoints(TEMP_TRANSFORM);
        return true;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        if (super.intersects(rectangle2D)) {
            if (this.lineShape.intersects(rectangle2D)) {
                return true;
            }
            if (this.stroke != null && this.strokePaint != null) {
                return this.stroke.createStrokedShape(this.lineShape).intersects(rectangle2D);
            }
        }
        return false;
    }

    public Rectangle2D getLineBoundsWithStroke() {
        if (this.stroke != null) {
            return this.stroke.createStrokedShape(this.lineShape).getBounds2D();
        }
        return this.lineShape.getBounds2D();
    }

    public void updateBoundsFromLine() {
        if (this.lineShape.getPointCount() == 0) {
            this.resetBounds();
        } else {
            Rectangle2D rectangle2D = this.getLineBoundsWithStroke();
            super.setBounds(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
    }

    protected void paint(PPaintContext pPaintContext) {
        Graphics2D graphics2D = pPaintContext.getGraphics();
        if (this.stroke != null && this.strokePaint != null) {
            graphics2D.setPaint(this.strokePaint);
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(this.lineShape);
        }
    }

    protected void lineChanged() {
        this.firePropertyChange(262144, "path", null, this.lineShape);
        this.updateBoundsFromLine();
        this.invalidatePaint();
    }

    public void addPoint(int n, double d, double d2) {
        this.lineShape.addPoint(n, d, d2);
        this.lineChanged();
    }

    public void removeAllPoints() {
        this.lineShape.removePoints(0, this.lineShape.getPointCount());
        this.lineChanged();
    }
}

