/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.DatableItem;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.ModelAnimationListener;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.geom.Point2D;

public class DatableItemNode
extends PNode {
    private final DatableItem datableItem;
    private final ModelViewTransform2D mvt;
    private PImage image = null;
    private final boolean SHOW_NAME = false;
    private double rotationAngle = 0.0;

    public DatableItemNode(DatableItem datableItem, ModelViewTransform2D modelViewTransform2D) {
        this.datableItem = datableItem;
        this.mvt = modelViewTransform2D;
        datableItem.addAnimationListener(new ModelAnimationListener(){

            public void imageChanged() {
                DatableItemNode.this.updateImage();
            }

            public void positionChanged() {
                DatableItemNode.this.updatePosition();
            }

            public void rotationalAngleChanged() {
                DatableItemNode.this.updateRotationAngle();
            }

            public void sizeChanged() {
                DatableItemNode.this.updateSize();
            }
        });
        this.updateImage();
        this.updatePosition();
        this.updateRotationAngle();
    }

    private void updatePosition() {
        this.setOffset(this.mvt.modelToViewDouble(this.datableItem.getPosition()));
    }

    private void updateSize() {
        Point2D point2D = this.mvt.modelToViewDifferentialDouble(this.datableItem.getWidth(), this.datableItem.getHeight());
        this.image.scale(point2D.getX() / this.image.getFullBoundsReference().getWidth());
        this.image.setOffset(-this.image.getFullBoundsReference().width / 2.0, -this.image.getFullBoundsReference().height / 2.0);
        this.updatePosition();
    }

    private void updateRotationAngle() {
        this.rotateAboutPoint(this.datableItem.getRotationalAngle() - this.rotationAngle, new Point2D.Double(this.image.getFullBoundsReference().width / 2.0, this.getFullBoundsReference().height / 2.0));
        this.rotationAngle = this.datableItem.getRotationalAngle();
        this.updatePosition();
    }

    private void updateImage() {
        if (this.image != null) {
            this.removeChild(this.image);
        }
        this.image = new PImage(this.datableItem.getImage());
        double d = this.mvt.modelToViewDifferentialXDouble(this.datableItem.getWidth());
        double d2 = this.mvt.modelToViewDifferentialYDouble(-this.datableItem.getHeight());
        double d3 = Math.min(d / this.image.getFullBoundsReference().getWidth(), d2 / this.image.getFullBoundsReference().getHeight());
        this.image.scale(d3);
        this.image.setOffset(-this.image.getFullBoundsReference().width / 2.0, -this.image.getFullBoundsReference().height / 2.0);
        this.addChild(this.image);
    }
}

