/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.nuclearreactor;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.Nucleon;
import edu.colorado.phet.nuclearphysics.model.Uranium235Nucleus;
import edu.colorado.phet.nuclearphysics.model.Uranium238Nucleus;
import edu.colorado.phet.nuclearphysics.module.nuclearreactor.ControlRod;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Random;

public class NuclearReactorModel {
    private static final Point2D REACTOR_POSITION = new Point2D.Double(-342.10526315789474, -136.5);
    private static double JOULES_PER_FISSION_EVENT = 3.2E-11;
    private NuclearPhysicsClock _clock;
    private ArrayList _listeners;
    private ArrayList _u235Nuclei;
    private ArrayList _u238Nuclei;
    private ArrayList _daughterNuclei;
    private ArrayList _freeNeutrons;
    private ArrayList _controlRods;
    private ArrayList _reactionChamberRects;
    private int _u235FissionEventCount;
    private int[] _fissionEventBins;
    private int _currentBin;
    private int _clockTicksPerSecond;
    private Rectangle2D _innerReactorRect;
    private double _currentTemperature;
    private double _totalEnergyReleased;
    private double _energyReleasedPerSecond;
    private Random _rand = new Random();
    private boolean _reactionStarted;

    public NuclearReactorModel(NuclearPhysicsClock nuclearPhysicsClock) {
        this._clock = nuclearPhysicsClock;
        nuclearPhysicsClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                NuclearReactorModel.this.handleClockTicked(clockEvent);
            }

            public void simulationTimeReset(ClockEvent clockEvent) {
                NuclearReactorModel.this.reset();
            }
        });
        this._listeners = new ArrayList();
        this._u235Nuclei = new ArrayList();
        this._u238Nuclei = new ArrayList();
        this._daughterNuclei = new ArrayList();
        this._freeNeutrons = new ArrayList();
        this._reactionChamberRects = new ArrayList(6);
        this._controlRods = new ArrayList(5);
        this._clockTicksPerSecond = (int)Math.round(1000.0 / this._clock.getDt());
        this._fissionEventBins = new int[this._clockTicksPerSecond];
        this._currentBin = 0;
        this._totalEnergyReleased = 0.0;
        this._energyReleasedPerSecond = 0.0;
        this._reactionStarted = false;
        double d = 101.66666666666667;
        double d2 = d / 5.0;
        d -= d2 * 5.0 / 6.0;
        double d3 = 233.0;
        for (int i = 0; i < 6; ++i) {
            double d4 = REACTOR_POSITION.getX() + 20.0 + (double)i * (d + d2);
            double d5 = REACTOR_POSITION.getY() + 20.0;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d5, d, d3);
            this._reactionChamberRects.add(double_);
            if (i >= 5) continue;
            ControlRod controlRod = new ControlRod(d4 + d, d5, d2, 273.0);
            this._controlRods.add(controlRod);
        }
        this._innerReactorRect = new Rectangle2D.Double(REACTOR_POSITION.getX() + 20.0, REACTOR_POSITION.getY() + 20.0, 610.0, 233.0);
    }

    public ConstantDtClock getClock() {
        return this._clock;
    }

    public double getReactorWallWidth() {
        return 20.0;
    }

    public Rectangle2D getReactorRect() {
        return new Rectangle2D.Double(REACTOR_POSITION.getX(), REACTOR_POSITION.getY(), 650.0, 273.0);
    }

    public ArrayList getControlRodsReference() {
        return this._controlRods;
    }

    public void fireNeutrons() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        while ((double)n < 2.0) {
            double d;
            double d2;
            Integer n2 = null;
            while (arrayList.contains(n2 = new Integer(this._rand.nextInt(6)))) {
            }
            arrayList.add(n2);
            Rectangle2D rectangle2D = (Rectangle2D)this._reactionChamberRects.get(n2);
            if (this._rand.nextBoolean()) {
                d2 = this._rand.nextBoolean() ? rectangle2D.getX() : rectangle2D.getX() + rectangle2D.getWidth();
                d = rectangle2D.getY() + this._rand.nextDouble() * rectangle2D.getHeight();
            } else {
                d = this._rand.nextBoolean() ? rectangle2D.getY() : rectangle2D.getY() + rectangle2D.getHeight();
                d2 = rectangle2D.getX() + this._rand.nextDouble() * rectangle2D.getWidth();
            }
            double d3 = Math.atan2(rectangle2D.getCenterY() - d, rectangle2D.getCenterX() - d2);
            double d4 = 2.0 * Math.cos(d3);
            double d5 = 2.0 * Math.sin(d3);
            Nucleon nucleon = new Nucleon(Nucleon.NucleonType.NEUTRON, d2, d, d4, d5, false);
            this._freeNeutrons.add(nucleon);
            this.notifyModelElementAdded(nucleon);
            ++n;
        }
    }

    public void moveControlRods(double d) {
        int n = this._controlRods.size();
        double d2 = this.getReactorRect().getY() + 20.0;
        double d3 = this.getReactorRect().getY() + this.getReactorRect().getHeight() - 20.0;
        if (n > 0) {
            ControlRod controlRod = (ControlRod)this._controlRods.get(0);
            if (controlRod.getPosition().getY() + d < d2) {
                d = d2 - controlRod.getPosition().getY();
            } else if (controlRod.getPosition().getY() + d > d3) {
                d = d3 - controlRod.getPosition().getY();
            }
        }
        for (int i = 0; i < n; ++i) {
            ControlRod controlRod = (ControlRod)this._controlRods.get(i);
            controlRod.setPosition(controlRod.getPosition().getY() + d);
        }
    }

    public void addListener(Listener listener) {
        assert (!this._listeners.contains(listener));
        this._listeners.add(listener);
    }

    public void reset() {
        int n;
        for (n = 0; n < this._freeNeutrons.size(); ++n) {
            this.notifyModelElementRemoved(this._freeNeutrons.get(n));
        }
        this._freeNeutrons.clear();
        int n2 = this._u235Nuclei.size();
        for (n = 0; n < n2; ++n) {
            this.notifyModelElementRemoved(this._u235Nuclei.get(n));
            ((AtomicNucleus)this._u235Nuclei.get(n)).removedFromModel();
        }
        this._u235Nuclei.clear();
        n2 = this._u238Nuclei.size();
        for (n = 0; n < n2; ++n) {
            this.notifyModelElementRemoved(this._u238Nuclei.get(n));
            ((AtomicNucleus)this._u238Nuclei.get(n)).removedFromModel();
        }
        this._u238Nuclei.clear();
        n2 = this._daughterNuclei.size();
        for (n = 0; n < n2; ++n) {
            this.notifyModelElementRemoved(this._daughterNuclei.get(n));
            ((AtomicNucleus)this._daughterNuclei.get(n)).removedFromModel();
        }
        this._daughterNuclei.clear();
        for (n = 0; n < this._clockTicksPerSecond; ++n) {
            this._fissionEventBins[n] = 0;
        }
        this._currentBin = 0;
        this._currentTemperature = 0.0;
        this._totalEnergyReleased = 0.0;
        this._energyReleasedPerSecond = 0.0;
        this.notifyEnergyChanged();
        double d = ((Rectangle2D)this._reactionChamberRects.get(0)).getWidth();
        double d2 = ((Rectangle2D)this._reactionChamberRects.get(0)).getHeight();
        int n3 = (int)((d - 36.0) / 15.0 + 1.0);
        int n4 = (int)((d2 - 36.0) / 15.0 + 1.0);
        Point2D.Double double_ = new Point2D.Double();
        for (n = 0; n < this._reactionChamberRects.size(); ++n) {
            Rectangle2D rectangle2D = (Rectangle2D)this._reactionChamberRects.get(n);
            double d3 = rectangle2D.getX() + 18.0;
            double d4 = rectangle2D.getY() + 18.0;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    ((Point2D)double_).setLocation(d3 + (double)j * 15.0, d4 + (double)i * 15.0);
                    Uranium235Nucleus uranium235Nucleus = new Uranium235Nucleus(this._clock, double_, 0.0);
                    this._u235Nuclei.add(uranium235Nucleus);
                    uranium235Nucleus.addListener(new AtomicNucleus.Adapter(){

                        public void nucleusChangeEvent(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
                            NuclearReactorModel.this.handleU235AtomicWeightChange(atomicNucleus, n, n2, arrayList);
                        }
                    });
                    if (j >= n3 - 1) continue;
                    ((Point2D)double_).setLocation(d3 + ((double)j + 0.5) * 15.0, d4 + ((double)i + 0.5) * 15.0);
                    Uranium238Nucleus uranium238Nucleus = new Uranium238Nucleus(this._clock, double_);
                    this._u238Nuclei.add(uranium238Nucleus);
                }
            }
        }
        this._reactionStarted = false;
        this.notifyResetOccurred();
        this.notifyTemperatureChanged();
        this.notifyEnergyChanged();
    }

    public ArrayList getNuclei() {
        ArrayList arrayList = new ArrayList(this._u235Nuclei.size() + this._u238Nuclei.size() + this._daughterNuclei.size());
        arrayList.addAll(this._u235Nuclei);
        arrayList.addAll(this._u238Nuclei);
        arrayList.addAll(this._daughterNuclei);
        return arrayList;
    }

    public ArrayList getChamberRectsReference() {
        return this._reactionChamberRects;
    }

    public double getTotalEnergyReleased() {
        return this._totalEnergyReleased;
    }

    public double getEnergyReleasedPerSecond() {
        return this._energyReleasedPerSecond;
    }

    public double getTemperature() {
        return this._currentTemperature;
    }

    private void handleClockTicked(ClockEvent clockEvent) {
        int n = this._freeNeutrons.size();
        for (int i = n - 1; i >= 0; --i) {
            int n2;
            int n3;
            Nucleon nucleon = (Nucleon)this._freeNeutrons.get(i);
            assert (nucleon instanceof Nucleon);
            boolean bl = false;
            nucleon.translate();
            if (!this._innerReactorRect.contains(nucleon.getPositionReference())) {
                bl = true;
            }
            int n4 = this._controlRods.size();
            for (n3 = 0; n3 < n4 && !bl; ++n3) {
                ControlRod controlRod = (ControlRod)this._controlRods.get(n3);
                if (!controlRod.particleAbsorbed(nucleon)) continue;
                bl = true;
            }
            n3 = this._u238Nuclei.size();
            for (n2 = 0; n2 < n3 && !bl; ++n2) {
                AtomicNucleus atomicNucleus = (AtomicNucleus)this._u238Nuclei.get(n2);
                if (!(nucleon.getPositionReference().distance(atomicNucleus.getPositionReference()) <= atomicNucleus.getDiameter() / 2.0)) continue;
                bl = atomicNucleus.captureParticle(nucleon);
            }
            n2 = this._u235Nuclei.size();
            for (int j = 0; j < n2 && !bl; ++j) {
                AtomicNucleus atomicNucleus = (AtomicNucleus)this._u235Nuclei.get(j);
                if (!(nucleon.getPositionReference().distance(atomicNucleus.getPositionReference()) <= atomicNucleus.getDiameter() / 2.0)) continue;
                bl = atomicNucleus.captureParticle(nucleon);
            }
            if (!bl) continue;
            this._freeNeutrons.remove(i);
            this.notifyModelElementRemoved(nucleon);
        }
        double d = this._totalEnergyReleased + (double)this._u235FissionEventCount * JOULES_PER_FISSION_EVENT;
        double d2 = this._energyReleasedPerSecond + (double)(this._u235FissionEventCount - this._fissionEventBins[this._currentBin]) * JOULES_PER_FISSION_EVENT;
        this._fissionEventBins[this._currentBin] = this._u235FissionEventCount;
        this._currentBin = (this._currentBin + 1) % this._clockTicksPerSecond;
        if (d2 < JOULES_PER_FISSION_EVENT) {
            d2 = 0.0;
        }
        this._u235FissionEventCount = 0;
        double d3 = d2 * (1.0 / JOULES_PER_FISSION_EVENT);
        if (this._currentTemperature != d3) {
            this._currentTemperature = Math.abs(this._currentTemperature - d3) < 1.0 ? d3 : (this._currentTemperature < d3 ? (this._currentTemperature += 1.0) : (this._currentTemperature -= 1.0));
            this.notifyTemperatureChanged();
        }
        if (d2 != this._energyReleasedPerSecond || d != this._totalEnergyReleased) {
            this._energyReleasedPerSecond = d2;
            this._totalEnergyReleased = d;
            this.notifyEnergyChanged();
        }
    }

    private void notifyModelElementRemoved(Object object) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).modelElementRemoved(object);
        }
    }

    private void notifyModelElementAdded(Object object) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).modelElementAdded(object);
        }
    }

    private void notifyResetOccurred() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).resetOccurred();
        }
    }

    private void notifyReactionStarted() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).reactionStarted();
        }
    }

    private void notifyEnergyChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).energyChanged();
        }
    }

    private void notifyTemperatureChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).temperatureChanged();
        }
    }

    private void handleU235AtomicWeightChange(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
        if (arrayList != null) {
            if (!this._reactionStarted) {
                this.notifyReactionStarted();
                this._reactionStarted = true;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Object e = arrayList.get(i);
                if (e instanceof Nucleon) {
                    this.notifyModelElementAdded(e);
                    double d = this._rand.nextDouble() * Math.PI * 2.0;
                    double d2 = Math.sin(d) * 3.0;
                    double d3 = Math.cos(d) * 3.0;
                    ((Nucleon)e).setVelocity(d2, d3);
                    this._freeNeutrons.add(e);
                    continue;
                }
                if (e instanceof AtomicNucleus) {
                    AtomicNucleus atomicNucleus2 = (AtomicNucleus)e;
                    this.notifyModelElementAdded(atomicNucleus2);
                    double d = this._rand.nextDouble() * Math.PI * 2.0;
                    double d4 = Math.sin(d) * 10.0;
                    double d5 = Math.cos(d) * 10.0;
                    atomicNucleus.setPosition(atomicNucleus2.getPositionReference().getX() + d4, atomicNucleus2.getPositionReference().getY() + d5);
                    atomicNucleus2.setPosition(atomicNucleus2.getPositionReference().getX() - d4, atomicNucleus2.getPositionReference().getY() - d5);
                    this._daughterNuclei.add(atomicNucleus2);
                    assert (atomicNucleus instanceof Uranium235Nucleus);
                    this._u235Nuclei.remove(atomicNucleus);
                    this._daughterNuclei.add(atomicNucleus);
                    ++this._u235FissionEventCount;
                    continue;
                }
                System.err.println("Error: Unexpected byproduct of decay event.");
                assert (false);
            }
        }
    }

    public static class Adapter
    implements Listener {
        public void modelElementAdded(Object object) {
        }

        public void modelElementRemoved(Object object) {
        }

        public void resetOccurred() {
        }

        public void energyChanged() {
        }

        public void temperatureChanged() {
        }

        public void reactionStarted() {
        }
    }

    public static interface Listener {
        public void modelElementAdded(Object var1);

        public void modelElementRemoved(Object var1);

        public void resetOccurred();

        public void energyChanged();

        public void temperatureChanged();

        public void reactionStarted();
    }
}

