/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.model.AbstractBetaDecayNucleus;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import java.awt.geom.Point2D;
import java.util.Random;

public class Hydrogen3Nucleus
extends AbstractBetaDecayNucleus {
    private static double DECAY_TIME_SCALING_FACTOR = 1500.0 / HalfLifeInfo.getHalfLifeForNucleusType(NucleusType.HYDROGEN_3);
    private static final Random RAND = new Random();

    public Hydrogen3Nucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D) {
        super(nuclearPhysicsClock, point2D, 1, 2, DECAY_TIME_SCALING_FACTOR);
    }

    public Hydrogen3Nucleus(NuclearPhysicsClock nuclearPhysicsClock) {
        this(nuclearPhysicsClock, new Point2D.Double(0.0, 0.0));
    }

    public double getHalfLife() {
        return HalfLifeInfo.getHalfLifeForNucleusConfig(this._numProtons, this._numNeutrons);
    }

    public void reset() {
        super.reset();
        if (this._numNeutrons != 2 || this._numProtons != 1) {
            this._numNeutrons = 2;
            this._numProtons = 1;
            this.notifyNucleusChangeEvent(null);
        }
    }

    public boolean hasDecayed() {
        return this._numNeutrons < 2;
    }
}

