/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.controls.valuecontrol;

import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterValue;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterValues;
import edu.colorado.phet.common.phetcommon.view.controls.HTMLLabel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.AbstractSlider;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.ILayoutStrategy;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public abstract class AbstractValueControl
extends JPanel {
    private double _value;
    private double _majorTickSpacing;
    private double _minorTickSpacing;
    private double _upDownArrowDelta;
    private AbstractSlider _slider;
    private JFormattedTextField _textField;
    private HTMLLabel _valueLabel;
    private HTMLLabel _unitsLabel;
    private Font _font;
    private NumberFormat _textFieldFormat;
    private DecimalFormat _tickFormat;
    private boolean _majorTicksVisible;
    private boolean _minorTicksVisible;
    private Hashtable _labelTable;
    private boolean _notifyWhileAdjusting;
    private boolean _isAdjusting;
    private EventListenerList _listenerList;
    private TextFieldListener _textFieldListener;
    private SliderListener _sliderListener;
    private boolean _initialized;
    private boolean _paintTickLabels;
    private boolean _signifyOutOfBounds;

    public AbstractValueControl(AbstractSlider abstractSlider, String string, String string2, String string3, ILayoutStrategy iLayoutStrategy) {
        this._slider = abstractSlider;
        this._slider.setPaintTicks(true);
        this._majorTickSpacing = this._slider.getModelRange();
        this._minorTickSpacing = 0.0;
        this._upDownArrowDelta = this._slider.getModelRange() / 100.0;
        this._slider.setUpDownArrowDelta(this._upDownArrowDelta);
        this._textFieldFormat = new DecimalFormat(string2);
        this._tickFormat = new DecimalFormat(string2);
        this._majorTicksVisible = true;
        this._minorTicksVisible = false;
        this._labelTable = null;
        this._paintTickLabels = true;
        this._signifyOutOfBounds = true;
        this._notifyWhileAdjusting = true;
        this._isAdjusting = false;
        this._font = new PhetFont();
        this._listenerList = new EventListenerList();
        this._valueLabel = new HTMLLabel(string);
        this._unitsLabel = new HTMLLabel(string3);
        this._textField = new JFormattedTextField(this._textFieldFormat);
        this._textField.setValue(new Double(this._value));
        this._textField.setHorizontalAlignment(4);
        this._textField.setColumns(string2.length());
        iLayoutStrategy.doLayout(this);
        this._sliderListener = new SliderListener();
        this._slider.addChangeListener(this._sliderListener);
        this._slider.addMouseListener(this._sliderListener);
        this._textFieldListener = new TextFieldListener();
        this._textField.addActionListener(this._textFieldListener);
        this._textField.addFocusListener(this._textFieldListener);
        this._textField.addKeyListener(this._textFieldListener);
        this.updateTickLabels();
        this._value = this._slider.getModelMin() - 1.0;
        this.setValue(abstractSlider.getModelValue());
        this._initialized = true;
    }

    public AbstractSlider getSlider() {
        return this._slider;
    }

    public JFormattedTextField getTextField() {
        return this._textField;
    }

    public JLabel getValueLabel() {
        return this._valueLabel;
    }

    public void setValueLabelIcon(Icon icon) {
        this._valueLabel.setIcon(icon);
        this._valueLabel.setVerticalTextPosition(0);
        this._valueLabel.setHorizontalTextPosition(4);
    }

    public JLabel getUnitsLabel() {
        return this._unitsLabel;
    }

    public void setValue(double d) {
        if (d != this._value) {
            this.setValue(d, true);
        }
    }

    private void setValue(double d, boolean bl) {
        if (this.isValueInRange(d)) {
            this._value = d;
            this.updateView();
            if (bl) {
                this.fireChangeEvent(new ChangeEvent(this));
            }
        } else {
            if (d < this.getMinimum()) {
                this._value = this.getMinimum();
            } else if (d > this.getMaximum()) {
                this._value = this.getMaximum();
            }
            this.textFieldCorrected(ParameterValues.rangeError, String.valueOf(d), this._value);
            this.beep();
            this.updateView();
        }
    }

    protected boolean isValueInRange(double d) {
        return d >= this.getMinimum() && d <= this.getMaximum();
    }

    public double getValue() {
        return this._value;
    }

    public double getMaximum() {
        return this._slider.getModelMax();
    }

    public double getMinimum() {
        return this._slider.getModelMin();
    }

    public void setUpDownArrowDelta(double d) {
        this._upDownArrowDelta = d;
        this._slider.setUpDownArrowDelta(d);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._valueLabel.setEnabled(bl);
        this._textField.setEnabled(bl);
        this._unitsLabel.setEnabled(bl);
        this._slider.setEnabled(bl);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this._initialized) {
            this._font = font;
            this._valueLabel.setFont(font);
            this._textField.setFont(font);
            this._unitsLabel.setFont(font);
            this._slider.setFont(font);
            this.updateTickLabels();
        }
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this._valueLabel.setToolTipText(string);
        this._textField.setToolTipText(string);
        this._unitsLabel.setToolTipText(string);
        this._slider.setToolTipText(string);
    }

    public void setTextFieldEditable(boolean bl) {
        this._textField.setEditable(bl);
    }

    private double getTextFieldValue() {
        double d;
        String string = this._textField.getText();
        try {
            Number number = this._textFieldFormat.parse(string);
            d = number.doubleValue();
        }
        catch (ParseException parseException) {
            this.beep();
            d = this._value;
        }
        return d;
    }

    public void setTickPattern(String string) {
        this._tickFormat = new DecimalFormat(string);
        this.updateTickLabels();
    }

    public void setMajorTickSpacing(double d) {
        if (d != this._minorTickSpacing) {
            this._majorTickSpacing = d;
            this.updateTickLabels();
        }
    }

    public void setMinorTickSpacing(double d) {
        if (d != this._minorTickSpacing) {
            this._minorTickSpacing = d;
            this.updateTickLabels();
        }
    }

    private void updateView() {
        this._slider.removeChangeListener(this._sliderListener);
        this._slider.setModelValue(this._value);
        this._slider.addChangeListener(this._sliderListener);
        this._textField.removeActionListener(this._textFieldListener);
        String string = this._textFieldFormat.format(this._value);
        this._textField.setText(string);
        this._textField.addActionListener(this._textFieldListener);
    }

    protected void updateTickLabels() {
        double d = this.getMinimum();
        double d2 = this.getMaximum();
        if (this._majorTicksVisible && this._majorTickSpacing > 0.0) {
            this._slider.setMajorTickSpacing(this._slider.modelToSlider(d + this._majorTickSpacing));
        } else {
            this._slider.setMajorTickSpacing(0);
        }
        if (this._minorTicksVisible && this._minorTickSpacing > 0.0) {
            this._slider.setMinorTickSpacing(this._slider.modelToSlider(d + this._minorTickSpacing));
        } else {
            this._slider.setMinorTickSpacing(0);
        }
        this._slider.setPaintLabels((this._minorTicksVisible || this._majorTicksVisible) && this._paintTickLabels);
        if (this._labelTable != null) {
            this._slider.setLabelTable(this._labelTable);
        } else {
            JLabel jLabel;
            double d3;
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            if (this._majorTicksVisible) {
                for (d3 = d; d3 <= d2; d3 += this._majorTickSpacing) {
                    jLabel = new JLabel(this._tickFormat.format(d3));
                    jLabel.setFont(this._font);
                    hashtable.put(new Integer(this._slider.modelToSlider(d3)), jLabel);
                }
            }
            if (this._minorTicksVisible && this._minorTickSpacing > 0.0) {
                for (d3 = d + this._minorTickSpacing; d3 < d2; d3 += this._minorTickSpacing) {
                    jLabel = new JLabel(this._tickFormat.format(d3));
                    jLabel.setFont(this._font);
                    hashtable.put(new Integer(this._slider.modelToSlider(d3)), jLabel);
                }
            }
            if (hashtable.size() != 0) {
                this._slider.setLabelTable(hashtable);
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private void beep() {
        if (this._signifyOutOfBounds) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    protected void sliderStartDrag(double d) {
    }

    protected void sliderEndDrag(double d) {
    }

    protected void sliderDrag(double d) {
    }

    protected void textFieldCommitted(IParameterValue iParameterValue, double d) {
    }

    protected void textFieldCorrected(IParameterValue iParameterValue, String string, double d) {
    }

    private class SliderListener
    extends MouseAdapter
    implements ChangeListener {
        private SliderListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == AbstractValueControl.this._slider) {
                AbstractValueControl.this._isAdjusting = AbstractValueControl.this._slider.getValueIsAdjusting();
                boolean bl = AbstractValueControl.this._notifyWhileAdjusting || !AbstractValueControl.this._isAdjusting;
                double d = AbstractValueControl.this._slider.getModelValue();
                AbstractValueControl.this.sliderDrag(d);
                AbstractValueControl.this.setValue(d, bl);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            AbstractValueControl.this.sliderStartDrag(AbstractValueControl.this._slider.getModelValue());
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            AbstractValueControl.this.sliderEndDrag(AbstractValueControl.this._slider.getModelValue());
        }
    }

    private class TextFieldListener
    extends KeyAdapter
    implements ActionListener,
    FocusListener {
        private TextFieldListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getSource() == AbstractValueControl.this._textField) {
                double d;
                if (keyEvent.getKeyCode() == 38) {
                    double d2 = AbstractValueControl.this.getValue() + AbstractValueControl.this._upDownArrowDelta;
                    if (d2 <= AbstractValueControl.this.getMaximum()) {
                        AbstractValueControl.this.textFieldCommitted(ParameterValues.upKey, d2);
                        AbstractValueControl.this.setValue(d2);
                    }
                } else if (keyEvent.getKeyCode() == 40 && (d = AbstractValueControl.this.getValue() - AbstractValueControl.this._upDownArrowDelta) >= AbstractValueControl.this.getMinimum()) {
                    AbstractValueControl.this.textFieldCommitted(ParameterValues.downKey, d);
                    AbstractValueControl.this.setValue(d);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            double d;
            if (actionEvent.getSource() == AbstractValueControl.this._textField && (d = AbstractValueControl.this.getTextFieldValue()) != AbstractValueControl.this.getValue()) {
                AbstractValueControl.this.textFieldCommitted(ParameterValues.enterKey, d);
                AbstractValueControl.this.setValue(d);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == AbstractValueControl.this._textField) {
                AbstractValueControl.this._textField.selectAll();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == AbstractValueControl.this._textField) {
                try {
                    AbstractValueControl.this._textField.commitEdit();
                    double d = AbstractValueControl.this.getTextFieldValue();
                    if (d != AbstractValueControl.this.getValue()) {
                        AbstractValueControl.this.textFieldCommitted(ParameterValues.focusLost, d);
                        AbstractValueControl.this.setValue(d);
                    }
                }
                catch (ParseException parseException) {
                    AbstractValueControl.this.textFieldCorrected(ParameterValues.parseError, AbstractValueControl.this._textField.getText(), AbstractValueControl.this.getValue());
                    AbstractValueControl.this.beep();
                    AbstractValueControl.this.updateView();
                }
            }
        }
    }
}

