/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.view;

import edu.colorado.phet.naturalselection.NaturalSelectionApplication;
import edu.colorado.phet.naturalselection.NaturalSelectionResources;
import edu.colorado.phet.naturalselection.model.NaturalSelectionModel;
import edu.colorado.phet.naturalselection.util.HighContrastImageFilter;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.geom.AffineTransform;

public class NaturalSelectionBackgroundNode
extends PNode
implements NaturalSelectionModel.Listener {
    private int climate;
    private PImage equatorImage = NaturalSelectionResources.getImageNode("natural_selection_background_equator_2.png");
    private PImage arcticImage = NaturalSelectionResources.getImageNode("natural_selection_background_arctic_2.png");
    private double baseWidth;
    private double baseHeight;

    public NaturalSelectionBackgroundNode(int n) {
        if (NaturalSelectionApplication.isHighContrast()) {
            this.equatorImage = HighContrastImageFilter.getEquator().getPImage("natural_selection_background_equator_2.png");
        }
        this.baseWidth = this.equatorImage.getWidth();
        this.baseHeight = this.equatorImage.getHeight();
        this.climate = n;
        if (this.climate == 0) {
            this.addChild(this.equatorImage);
        } else if (this.climate == 1) {
            this.addChild(this.arcticImage);
        }
    }

    public void reset() {
        this.setClimate(0);
    }

    public void setClimate(int n) {
        if (this.climate == n) {
            return;
        }
        this.climate = n;
        if (this.climate == 0) {
            this.removeChild(this.arcticImage);
            this.addChild(this.equatorImage);
        } else if (this.climate == 1) {
            this.removeChild(this.equatorImage);
            this.addChild(this.arcticImage);
        }
    }

    public void onEvent(NaturalSelectionModel.Event event) {
        if (event.getType() == 2) {
            this.setClimate(event.getNewClimate());
        }
    }

    public AffineTransform getBackgroundTransform(int n, int n2) {
        return new AffineTransform((double)n / this.baseWidth, 0.0, 0.0, (double)n2 / this.baseHeight, 0.0, 0.0);
    }

    public void updateLayout(int n, int n2) {
        this.setTransform(this.getBackgroundTransform(n, n2));
    }
}

