/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.view;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartNode;
import edu.colorado.phet.common.jfreechartphet.piccolo.XYPlotNode;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.naturalselection.NaturalSelectionApplication;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.NaturalSelectionResources;
import edu.colorado.phet.naturalselection.NaturalSelectionStrings;
import edu.colorado.phet.naturalselection.model.ColorGene;
import edu.colorado.phet.naturalselection.model.TailGene;
import edu.colorado.phet.naturalselection.model.TeethGene;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.block.AbstractBlock;
import org.jfree.chart.block.LineBorder;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleInsets;

public class BunnyStatsCanvas
extends PhetPCanvas {
    private JFreeChartNode chartNode;
    private XYPlotNode plotNode;
    private XYSeriesCollection mainDataset;
    private XYPlot emptyPlot;
    private XYPlot mainPlot;
    private PSwing zoomHolder;
    private final int[] zoomBounds = new int[]{5, 15, 30, 50, 75, 100, 150, 200, 250, 350, 500, 1000, 2000, 3000, 5000};
    private int zoomIndex = 3;
    private int cachedPopulation = 0;
    private static final Dimension DEFAULT_STATS_SIZE = new Dimension(300, 200);
    private int cycleCounter = 0;
    private int pos = 0;
    private int low = 0;
    private int[] cachedPositions = new int[]{2, 2, 2, 2, 2, 2, 2};
    private boolean[] cachedValid = new boolean[]{false, false, false, false, false, false, false};

    public BunnyStatsCanvas() {
        super(DEFAULT_STATS_SIZE);
        Object object;
        PNode pNode = new PNode();
        this.addScreenChild(pNode);
        this.mainDataset = this.createDataset();
        this.emptyPlot = this.createPlot(this.createDataset());
        this.mainPlot = this.createPlot(this.mainDataset);
        JFreeChart jFreeChart = new JFreeChart(this.emptyPlot);
        jFreeChart.setBackgroundPaint(NaturalSelectionConstants.COLOR_CONTROL_PANEL);
        if (NaturalSelectionApplication.isHighContrast()) {
            jFreeChart.setBackgroundPaint(Color.BLACK);
            jFreeChart.setBorderPaint(Color.WHITE);
            object = jFreeChart.getLegend();
            ((LegendTitle)object).setBackgroundPaint(Color.BLACK);
            ((LegendTitle)object).setItemPaint(Color.WHITE);
            ((AbstractBlock)object).setFrame(new LineBorder(Color.WHITE, new BasicStroke(1.0f), new RectangleInsets(5.0, 5.0, 5.0, 5.0)));
        }
        jFreeChart.setAntiAlias(false);
        this.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        this.chartNode = new JFreeChartNode(jFreeChart);
        pNode.addChild(this.chartNode);
        this.plotNode = new XYPlotNode(this.mainPlot);
        object = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.plotNode.setRenderingHints((RenderingHints)object);
        pNode.addChild(this.plotNode);
        object = new JPanel(new FlowLayout());
        ((JComponent)object).setOpaque(false);
        JButton jButton = new JButton(new ImageIcon(NaturalSelectionResources.getImage("zoomIn.gif")));
        JButton jButton2 = new JButton(new ImageIcon(NaturalSelectionResources.getImage("zoomOut.gif")));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BunnyStatsCanvas.this.zoomIndex--;
                BunnyStatsCanvas.this.updateZoom();
                BunnyStatsCanvas.this.updateLayout();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BunnyStatsCanvas.this.zoomIndex++;
                BunnyStatsCanvas.this.updateZoom();
                BunnyStatsCanvas.this.updateLayout();
            }
        });
        jButton.setOpaque(true);
        jButton2.setOpaque(true);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        ((Container)object).add(jButton);
        ((Container)object).add(jButton2);
        this.zoomHolder = new PSwing((JComponent)object);
        pNode.addChild(this.zoomHolder);
        this.updateZoom();
        this.updateLayout();
        this.setBorder(null);
    }

    public void onTick(int n) {
        if (this.cachedPopulation != n) {
            this.cachedPopulation = n;
            this.addDataPoint(n);
        } else if (this.cycleCounter++ % 3 == 0) {
            this.addDataPoint(n);
        }
    }

    public void reset() {
        for (int i = 0; i < 7; ++i) {
            this.mainDataset.getSeries(i).clear();
        }
        this.pos = 0;
        this.low = 0;
        this.cachedPositions = new int[]{2, 2, 2, 2, 2, 2, 2};
        this.cachedValid = new boolean[]{false, false, false, false, false, false, false};
        this.zoomIndex = 3;
        this.updateZoom();
        this.updateLayout();
    }

    private XYSeriesCollection createDataset() {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(new XYSeries((Comparable)((Object)NaturalSelectionStrings.STATS_TOTAL)));
        xYSeriesCollection.addSeries(new XYSeries((Comparable)((Object)NaturalSelectionStrings.GENE_COLOR_WHITE)));
        xYSeriesCollection.addSeries(new XYSeries((Comparable)((Object)NaturalSelectionStrings.GENE_COLOR_BROWN)));
        xYSeriesCollection.addSeries(new XYSeries((Comparable)((Object)NaturalSelectionStrings.GENE_TAIL_SHORT)));
        xYSeriesCollection.addSeries(new XYSeries((Comparable)((Object)NaturalSelectionStrings.GENE_TAIL_LONG)));
        xYSeriesCollection.addSeries(new XYSeries((Comparable)((Object)NaturalSelectionStrings.GENE_TEETH_SHORT)));
        xYSeriesCollection.addSeries(new XYSeries((Comparable)((Object)NaturalSelectionStrings.GENE_TEETH_LONG)));
        return xYSeriesCollection;
    }

    private XYPlot createPlot(XYSeriesCollection xYSeriesCollection) {
        XYPlot xYPlot = new XYPlot();
        NumberAxis numberAxis = new NumberAxis(NaturalSelectionStrings.STATS_TIME);
        numberAxis.setTickLabelsVisible(false);
        numberAxis.setRange(0.0, 300.0);
        xYPlot.setDomainAxis(numberAxis);
        NumberAxis numberAxis2 = new NumberAxis(NaturalSelectionStrings.STATS_POPULATION);
        numberAxis2.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        xYPlot.setRangeAxis(numberAxis2);
        numberAxis2.setRange(0.0, 50.0);
        xYPlot.setRenderer(new StandardXYItemRenderer());
        xYPlot.setDataset(0, xYSeriesCollection);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer();
        standardXYItemRenderer.setStroke(new BasicStroke(3.0f));
        if (NaturalSelectionApplication.isHighContrast()) {
            numberAxis.setAxisLinePaint(Color.WHITE);
            numberAxis.setLabelPaint(Color.WHITE);
            numberAxis.setTickLabelPaint(Color.WHITE);
            numberAxis.setTickMarkPaint(Color.WHITE);
            numberAxis2.setAxisLinePaint(Color.WHITE);
            numberAxis2.setLabelPaint(Color.WHITE);
            numberAxis2.setTickLabelPaint(Color.WHITE);
            numberAxis2.setTickMarkPaint(Color.WHITE);
            standardXYItemRenderer.setSeriesPaint(0, Color.WHITE);
            standardXYItemRenderer.setSeriesPaint(1, Color.RED);
            standardXYItemRenderer.setSeriesPaint(2, Color.CYAN);
            standardXYItemRenderer.setSeriesPaint(3, Color.BLUE);
            standardXYItemRenderer.setSeriesPaint(4, Color.ORANGE);
            standardXYItemRenderer.setSeriesPaint(5, Color.YELLOW);
            standardXYItemRenderer.setSeriesPaint(6, Color.MAGENTA);
            xYPlot.setBackgroundPaint(Color.BLACK);
            xYPlot.setDomainGridlinePaint(Color.WHITE);
            xYPlot.setRangeGridlinePaint(Color.WHITE);
            xYPlot.setDomainZeroBaselinePaint(Color.WHITE);
            xYPlot.setOutlinePaint(Color.WHITE);
            xYPlot.setRangeTickBandPaint(new Color(32, 32, 32));
            xYPlot.setRangeZeroBaselinePaint(Color.WHITE);
        } else {
            standardXYItemRenderer.setSeriesPaint(0, Color.BLACK);
            standardXYItemRenderer.setSeriesPaint(1, Color.RED);
            standardXYItemRenderer.setSeriesPaint(2, Color.CYAN);
            standardXYItemRenderer.setSeriesPaint(3, Color.BLUE);
            standardXYItemRenderer.setSeriesPaint(4, Color.ORANGE);
            standardXYItemRenderer.setSeriesPaint(5, Color.YELLOW.darker());
            standardXYItemRenderer.setSeriesPaint(6, Color.MAGENTA);
        }
        xYPlot.setRenderer(0, standardXYItemRenderer);
        return xYPlot;
    }

    protected void updateLayout() {
        double d = 10.0;
        double d2 = 10.0;
        double d3 = (double)this.getWidth() - 20.0;
        double d4 = (double)this.getHeight() - 20.0;
        this.chartNode.setBounds(0.0, 0.0, d3, d4);
        this.chartNode.setOffset(d, d2);
        this.chartNode.updateChartRenderingInfo();
        ChartRenderingInfo chartRenderingInfo = this.chartNode.getChartRenderingInfo();
        PlotRenderingInfo plotRenderingInfo = chartRenderingInfo.getPlotInfo();
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        ((Rectangle2D)double_).setRect(rectangle2D);
        Rectangle2D rectangle2D2 = this.chartNode.localToGlobal(double_);
        this.plotNode.setOffset(0.0, 0.0);
        this.plotNode.setDataArea(rectangle2D2);
        this.zoomHolder.setOffset(rectangle2D2.getX(), rectangle2D2.getY());
    }

    private synchronized void updateZoom() {
        if (this.zoomIndex < 0) {
            this.zoomIndex = 0;
        }
        if (this.zoomIndex >= this.zoomBounds.length) {
            this.zoomIndex = this.zoomBounds.length - 1;
        }
        this.mainPlot.getRangeAxis().setRange(0.0, this.zoomBounds[this.zoomIndex]);
        this.emptyPlot.getRangeAxis().setRange(0.0, this.zoomBounds[this.zoomIndex]);
    }

    private void setDataAtIndex(int n, int n2) {
        XYSeries xYSeries = this.mainDataset.getSeries(n);
        if (this.cachedPositions[n] == n2) {
            if (this.cachedValid[n]) {
                xYSeries.setNotify(false);
                xYSeries.remove(xYSeries.getItemCount() - 1);
                xYSeries.setNotify(true);
            } else {
                this.cachedValid[n] = true;
            }
        } else {
            this.cachedValid[n] = false;
            this.cachedPositions[n] = n2;
        }
        xYSeries.add(this.pos, n2, false);
    }

    private synchronized void addDataPoint(int n) {
        this.setDataAtIndex(0, n);
        this.setDataAtIndex(1, ColorGene.getInstance().getPrimaryPhenotypeCount());
        this.setDataAtIndex(2, ColorGene.getInstance().getSecondaryPhenotypeCount());
        this.setDataAtIndex(3, TailGene.getInstance().getPrimaryPhenotypeCount());
        this.setDataAtIndex(4, TailGene.getInstance().getSecondaryPhenotypeCount());
        this.setDataAtIndex(5, TeethGene.getInstance().getPrimaryPhenotypeCount());
        this.setDataAtIndex(6, TeethGene.getInstance().getSecondaryPhenotypeCount());
        ++this.pos;
        if (this.pos >= 301) {
            ++this.low;
        }
        this.mainPlot.getDomainAxis().setRange(this.low, this.low + 300);
    }
}

