/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.model;

import edu.colorado.phet.naturalselection.NaturalSelectionStrings;
import edu.colorado.phet.naturalselection.defaults.NaturalSelectionDefaults;
import edu.colorado.phet.naturalselection.model.Allele;
import edu.colorado.phet.naturalselection.model.Bunny;
import edu.colorado.phet.naturalselection.model.Gene;

public class TailGene
extends Gene {
    public static final Allele TAIL_SHORT_ALLELE = new Allele(NaturalSelectionStrings.GENE_TAIL_SHORT);
    public static final Allele TAIL_LONG_ALLELE = new Allele(NaturalSelectionStrings.GENE_TAIL_LONG);
    private static TailGene instance = null;

    private TailGene() {
        super(TAIL_SHORT_ALLELE, TAIL_LONG_ALLELE, NaturalSelectionDefaults.TAIL_DOMINANT_ALLELE);
    }

    public static TailGene getInstance() {
        if (instance == null) {
            instance = new TailGene();
        }
        return instance;
    }

    public Allele getBunnyPhenotype(Bunny bunny) {
        return bunny.getTailPhenotype();
    }
}

