/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.model;

import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.model.Allele;
import edu.colorado.phet.naturalselection.model.Bunny;
import edu.colorado.phet.naturalselection.model.ColorGene;
import edu.colorado.phet.naturalselection.model.Famine;
import edu.colorado.phet.naturalselection.model.Frenzy;
import edu.colorado.phet.naturalselection.model.Gene;
import edu.colorado.phet.naturalselection.model.Genotype;
import edu.colorado.phet.naturalselection.model.Landscape;
import edu.colorado.phet.naturalselection.model.NaturalSelectionClock;
import edu.colorado.phet.naturalselection.model.Shrub;
import edu.colorado.phet.naturalselection.model.TailGene;
import edu.colorado.phet.naturalselection.model.TeethGene;
import edu.colorado.phet.naturalselection.model.Tree;
import edu.colorado.phet.naturalselection.persistence.BunnyConfig;
import edu.colorado.phet.naturalselection.persistence.NaturalSelectionConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaturalSelectionModel
extends ClockAdapter {
    private NaturalSelectionClock clock;
    private Frenzy frenzy;
    private Famine famine;
    private ArrayList<Bunny> bunnies;
    private Bunny rootFather;
    private Bunny rootMother;
    private List<Shrub> shrubs;
    private List<Tree> trees;
    private ArrayList<Listener> listeners;
    private double time = 0.0;
    private double lastYearTick = 0.0;
    private double lastEventTick = NaturalSelectionConstants.getSettings().getSelectionTick();
    private int generation = 0;
    private boolean gameEnded = false;
    private int lastFrenziedGeneration = -1;
    private int lastFamineGeneration = -1;
    private boolean friendAdded = false;
    private int climate = 0;
    private int selectionFactor = 0;
    private Landscape landscape;
    private static final Random random = new Random(System.currentTimeMillis());

    public NaturalSelectionModel(NaturalSelectionClock naturalSelectionClock) {
        this.clock = naturalSelectionClock;
        this.landscape = new Landscape();
        this.bunnies = new ArrayList();
        this.listeners = new ArrayList();
        ColorGene.getInstance().setModel(this);
        TeethGene.getInstance().setModel(this);
        TailGene.getInstance().setModel(this);
        this.rootFather = new Bunny(this, null, null, 0);
        this.rootFather.notifyInit();
        this.bunnies.add(this.rootFather);
        this.clock.addClockListener(this);
        this.shrubs = new LinkedList<Shrub>();
        this.shrubs.add(new Shrub(this, 80.0, 330.0, 1.0));
        this.shrubs.add(new Shrub(this, 750.0, 200.0, 0.8));
        this.shrubs.add(new Shrub(this, 320.0, 130.0, 0.6));
        this.trees = new LinkedList<Tree>();
        this.trees.add(new Tree(this, 125.0, 138.0, 1.0));
        this.trees.add(new Tree(this, 917.0, 115.0, 0.7));
        this.trees.add(new Tree(this, 635.0, 90.0, 0.2));
        if (!NaturalSelectionConstants.getSettings().isClockStartRunning()) {
            this.clock.stop();
        }
    }

    public void reset() {
        if (this.isDuringFrenzy()) {
            this.prematureEndFrenzy();
        }
        if (this.isDuringFamine()) {
            this.prematureEndFamine();
        }
        Bunny.reset();
        this.climate = 0;
        this.selectionFactor = 0;
        this.friendAdded = false;
        this.generation = 0;
        this.time = 0.0;
        this.gameEnded = false;
        this.lastFrenziedGeneration = -1;
        this.lastFamineGeneration = -1;
        this.lastYearTick = 0.0;
        this.lastEventTick = NaturalSelectionConstants.getSettings().getSelectionTick();
        this.frenzy = null;
        this.bunnies = new ArrayList();
        ColorGene.getInstance().reset();
        TailGene.getInstance().reset();
        TeethGene.getInstance().reset();
        this.rootFather = new Bunny(this, null, null, 0);
        this.rootFather.notifyInit();
        this.bunnies.add(this.rootFather);
        this.clock.resetSimulationTime();
        if (NaturalSelectionConstants.getSettings().isClockStartRunning()) {
            this.clock.start();
        } else {
            this.clock.stop();
        }
        this.notifyGenerationChange();
        this.initialize();
    }

    public void save(NaturalSelectionConfig naturalSelectionConfig) {
        NaturalSelectionClock naturalSelectionClock = this.getClock();
        naturalSelectionConfig.setClockDt(naturalSelectionClock.getDt());
        naturalSelectionConfig.setClockPaused(naturalSelectionClock.isPaused());
        naturalSelectionConfig.setClockTime(naturalSelectionClock.getSimulationTime());
        naturalSelectionConfig.setClimate(this.climate);
        naturalSelectionConfig.setSelectionFactor(this.selectionFactor);
        naturalSelectionConfig.setTime(this.time);
        naturalSelectionConfig.setLastYearTick(this.lastYearTick);
        naturalSelectionConfig.setLastEventTick(this.lastEventTick);
        naturalSelectionConfig.setGeneration(this.generation);
        naturalSelectionConfig.setGameEnded(this.gameEnded);
        naturalSelectionConfig.setLastFrenziedGeneration(this.lastFrenziedGeneration);
        naturalSelectionConfig.setFriendAdded(this.friendAdded);
        naturalSelectionConfig.setRootFatherId(this.rootFather.bunnyId);
        if (this.rootMother == null) {
            naturalSelectionConfig.setRootMotherId(-1);
        } else {
            naturalSelectionConfig.setRootMotherId(this.rootMother.bunnyId);
        }
        BunnyConfig[] bunnyConfigArray = new BunnyConfig[this.bunnies.size()];
        for (int i = 0; i < bunnyConfigArray.length; ++i) {
            bunnyConfigArray[i] = this.bunnies.get(i).getConfig();
        }
        naturalSelectionConfig.setBunnies(bunnyConfigArray);
        naturalSelectionConfig.setColorRegularDominant(ColorGene.getInstance().getDominantAllele() == ColorGene.WHITE_ALLELE);
        naturalSelectionConfig.setTeethRegularDominant(TeethGene.getInstance().getDominantAllele() == TeethGene.TEETH_SHORT_ALLELE);
        naturalSelectionConfig.setTailRegularDominant(TailGene.getInstance().getDominantAllele() == TailGene.TAIL_SHORT_ALLELE);
    }

    public void load(NaturalSelectionConfig naturalSelectionConfig) {
        this.clock.setDt(naturalSelectionConfig.getClockDt());
        this.clock.setPaused(naturalSelectionConfig.isClockPaused());
        this.clock.setSimulationTime(naturalSelectionConfig.getClockTime());
        this.setClimate(naturalSelectionConfig.getClimate());
        this.setSelectionFactor(naturalSelectionConfig.getSelectionFactor());
        this.time = naturalSelectionConfig.getTime();
        this.lastYearTick = naturalSelectionConfig.getLastYearTick();
        this.lastEventTick = naturalSelectionConfig.getLastEventTick();
        this.generation = naturalSelectionConfig.getGeneration();
        this.gameEnded = naturalSelectionConfig.isGameEnded();
        this.lastFrenziedGeneration = naturalSelectionConfig.getLastFrenziedGeneration();
        this.friendAdded = naturalSelectionConfig.isFriendAdded();
        if (naturalSelectionConfig.isColorRegularDominant()) {
            ColorGene.getInstance().setDominantAllele(ColorGene.WHITE_ALLELE);
        } else {
            ColorGene.getInstance().setDominantAllele(ColorGene.BROWN_ALLELE);
        }
        if (naturalSelectionConfig.isTeethRegularDominant()) {
            TeethGene.getInstance().setDominantAllele(TeethGene.TEETH_SHORT_ALLELE);
        } else {
            TeethGene.getInstance().setDominantAllele(TeethGene.TEETH_LONG_ALLELE);
        }
        if (naturalSelectionConfig.isTailRegularDominant()) {
            TailGene.getInstance().setDominantAllele(TailGene.TAIL_SHORT_ALLELE);
        } else {
            TailGene.getInstance().setDominantAllele(TailGene.TAIL_LONG_ALLELE);
        }
        for (BunnyConfig bunnyConfig : naturalSelectionConfig.getBunnies()) {
            this.addBunnyConfig(bunnyConfig, naturalSelectionConfig);
        }
    }

    public Bunny getBunnyById(int n) {
        for (Bunny bunny : this.bunnies) {
            if (bunny.bunnyId != n) continue;
            return bunny;
        }
        return null;
    }

    public void addBunnyConfig(BunnyConfig bunnyConfig, NaturalSelectionConfig naturalSelectionConfig) {
        if (bunnyConfig.getId() == naturalSelectionConfig.getRootFatherId()) {
            this.rootFather.setId(naturalSelectionConfig.getRootFatherId());
            return;
        }
        Bunny bunny = new Bunny(this, this.getBunnyById(bunnyConfig.getFatherId()), this.getBunnyById(bunnyConfig.getMotherId()), bunnyConfig.getGeneration());
        Bunny bunny2 = this.getBunnyById(bunnyConfig.getPotentialMateId());
        if (bunny2 != null) {
            bunny.setPotentialMate(bunny2);
            bunny2.setPotentialMate(bunny);
        }
        if (naturalSelectionConfig.getRootMotherId() == bunnyConfig.getId()) {
            this.rootMother = bunny;
        }
        if (bunny.bunnyId != bunnyConfig.getId()) {
            System.out.println("WARNING: bunny IDs do not match!");
        }
        bunny.setMated(bunnyConfig.isMated());
        bunny.setMutated(bunnyConfig.isMutated());
        bunny.setAlive(bunnyConfig.isAlive());
        if (bunnyConfig.getFatherId() >= 0) {
            this.getBunnyById(bunnyConfig.getFatherId()).getChildren().add(bunny);
        }
        if (bunnyConfig.getMotherId() >= 0) {
            this.getBunnyById(bunnyConfig.getMotherId()).getChildren().add(bunny);
        }
        bunny.setAge(bunnyConfig.getAge());
        bunny.setColorPhenotype(this.regularColor(bunnyConfig.isColorPhenotypeRegular()));
        bunny.setTeethPhenotype(this.regularTeeth(bunnyConfig.isTeethPhenotypeRegular()));
        bunny.setTailPhenotype(this.regularTail(bunnyConfig.isTailPhenotypeRegular()));
        bunny.setColorGenotype(new Genotype(ColorGene.getInstance(), this.regularColor(bunnyConfig.isColorFatherGenotypeRegular()), this.regularColor(bunnyConfig.isColorMotherGenotypeRegular())));
        bunny.setTeethGenotype(new Genotype(TeethGene.getInstance(), this.regularTeeth(bunnyConfig.isTeethFatherGenotypeRegular()), this.regularTeeth(bunnyConfig.isTeethMotherGenotypeRegular())));
        bunny.setTailGenotype(new Genotype(TailGene.getInstance(), this.regularTail(bunnyConfig.isTailFatherGenotypeRegular()), this.regularTail(bunnyConfig.isTailMotherGenotypeRegular())));
        bunny.setPosition(new Point3D.Double(bunnyConfig.getX(), bunnyConfig.getY(), bunnyConfig.getZ()));
        bunny.setSinceHopTime(bunnyConfig.getSinceHopTime());
        bunny.setMovingRight(bunnyConfig.isMovingRight());
        bunny.setHunger(bunnyConfig.getHunger());
        bunny.setHopDirection(new Point3D.Double(bunnyConfig.getHopX(), bunnyConfig.getHopY(), bunnyConfig.getHopZ()));
        bunny.notifyInit();
        this.bunnies.add(bunny);
        this.notifyNewBunny(bunny);
    }

    private Allele regularColor(boolean bl) {
        return bl ? ColorGene.WHITE_ALLELE : ColorGene.BROWN_ALLELE;
    }

    private Allele regularTeeth(boolean bl) {
        return bl ? TeethGene.TEETH_SHORT_ALLELE : TeethGene.TEETH_LONG_ALLELE;
    }

    private Allele regularTail(boolean bl) {
        return bl ? TailGene.TAIL_SHORT_ALLELE : TailGene.TAIL_LONG_ALLELE;
    }

    public void initialize() {
        this.notifyNewBunny(this.rootFather);
    }

    public void addFriend() {
        this.time = 0.0;
        this.lastYearTick = 0.0;
        this.lastEventTick = NaturalSelectionConstants.getSettings().getTicksPerYear() / 4.0;
        this.friendAdded = true;
        this.rootMother = new Bunny(this, null, null, 0);
        this.rootMother.notifyInit();
        this.rootFather.setPotentialMate(this.rootMother);
        this.rootMother.setPotentialMate(this.rootFather);
        this.bunnies.add(this.rootMother);
        this.notifyNewBunny(this.rootMother);
    }

    private void nextGeneration() {
        this.ageBunnies();
        if (!this.friendAdded) {
            int n = this.getPopulation();
            if (n == 0) {
                this.endGame();
            } else if (n > NaturalSelectionConstants.getSettings().getMaxPopulation()) {
                this.bunniesTakeOver();
            }
            return;
        }
        this.mateBunnies();
        ++this.generation;
        this.notifyGenerationChange();
        ColorGene.getInstance().setMutatable(false);
        TailGene.getInstance().setMutatable(false);
        TeethGene.getInstance().setMutatable(false);
        int n = this.getPopulation();
        if (n == 0) {
            this.endGame();
        } else if (n > NaturalSelectionConstants.getSettings().getMaxPopulation()) {
            this.bunniesTakeOver();
        }
    }

    public void bunniesTakeOver() {
        if (this.gameEnded) {
            return;
        }
        this.gameEnded = true;
        this.clock.pause();
        this.notifyBunniesTakeOver();
    }

    public void endGame() {
        if (this.gameEnded) {
            return;
        }
        this.gameEnded = true;
        this.clock.pause();
        this.notifyGameOver();
    }

    private void mateBunnies() {
        List<Bunny> list = this.getAliveBunnyList();
        Collections.shuffle(list);
        LinkedList<Bunny> linkedList = new LinkedList<Bunny>();
        Bunny bunny = null;
        for (Bunny bunny2 : list) {
            if (bunny == null) {
                bunny = bunny2;
                continue;
            }
            Bunny[] bunnyArray = Bunny.mateBunnies(bunny, bunny2, this.generation + 1);
            for (int i = 0; i < bunnyArray.length; ++i) {
                Bunny bunny3 = bunnyArray[i];
                linkedList.add(bunny3);
            }
            bunny = null;
        }
        this.mutateSomeBunnies(linkedList);
        for (Bunny bunny2 : linkedList) {
            bunny2.notifyInit();
            this.bunnies.add(bunny2);
            this.notifyNewBunny(bunny2);
        }
    }

    private void mutateSomeBunnies(List<Bunny> list) {
        Gene gene = null;
        Allele allele = null;
        if (ColorGene.getInstance().getMutatable()) {
            gene = ColorGene.getInstance();
            allele = ColorGene.BROWN_ALLELE;
        } else if (TailGene.getInstance().getMutatable()) {
            gene = TailGene.getInstance();
            allele = TailGene.TAIL_LONG_ALLELE;
        } else if (TeethGene.getInstance().getMutatable()) {
            gene = TeethGene.getInstance();
            allele = TeethGene.TEETH_LONG_ALLELE;
        } else {
            return;
        }
        ArrayList<Bunny> arrayList = new ArrayList<Bunny>();
        for (Bunny bunny : list) {
            if (gene.getBunnyPhenotype(bunny) == allele) continue;
            arrayList.add(bunny);
        }
        if (arrayList.size() == 0) {
            return;
        }
        int n = NaturalSelectionConstants.getSettings().getMutatingBunnyBase();
        int n2 = NaturalSelectionConstants.getSettings().getMutatingBunnyPerBunnies();
        int n3 = n + arrayList.size() / n2;
        for (int i = 0; i < n3 && !arrayList.isEmpty(); ++i) {
            Bunny bunny = (Bunny)arrayList.get(random.nextInt(arrayList.size()));
            arrayList.remove(bunny);
            bunny.mutateGene(gene, allele);
        }
    }

    public void killAllBunnies() {
        for (Bunny bunny : this.bunnies) {
            if (!bunny.isAlive()) continue;
            bunny.die();
        }
    }

    private void ageBunnies() {
        Iterator<Bunny> iterator = this.bunnies.iterator();
        while (iterator.hasNext()) {
            iterator.next().ageMe();
        }
    }

    private void startFamine() {
        if (this.lastFamineGeneration == this.generation) {
            return;
        }
        this.lastFamineGeneration = this.generation;
        if (this.isDuringFamine() || this.getPopulation() == 0) {
            return;
        }
        this.famine = new Famine(this, NaturalSelectionConstants.getSettings().getFamineTicks());
        this.notifyFamineStart(this.famine);
        this.famine.init();
    }

    public void prematureEndFamine() {
        if (this.famine != null && this.famine.isRunning()) {
            this.famine.endFamine();
        }
        this.famine = null;
    }

    public void endFamine() {
        this.famine = null;
    }

    public boolean isDuringFamine() {
        return this.famine != null;
    }

    public void startFrenzy() {
        if (this.isDuringFrenzy()) {
            return;
        }
        if (this.getPopulation() == 0) {
            return;
        }
        if (this.lastFrenziedGeneration == this.generation) {
            return;
        }
        this.lastFrenziedGeneration = this.generation;
        this.frenzy = new Frenzy(this, NaturalSelectionConstants.getSettings().getFrenzyTicks());
        this.notifyFrenzyStart(this.frenzy);
        this.frenzy.init();
    }

    public void prematureEndFrenzy() {
        if (this.frenzy != null && this.frenzy.isRunning()) {
            this.frenzy.endFrenzy();
        }
        this.frenzy = null;
    }

    public void endFrenzy() {
        this.frenzy = null;
    }

    public boolean isDuringFrenzy() {
        return this.frenzy != null;
    }

    public NaturalSelectionClock getClock() {
        return this.clock;
    }

    public int getPopulation() {
        int n = 0;
        for (Bunny bunny : this.bunnies) {
            if (!bunny.isAlive()) continue;
            ++n;
        }
        return n;
    }

    public int getGeneration() {
        return this.generation;
    }

    public ArrayList<Bunny> getBunnyList() {
        return this.bunnies;
    }

    public List<Bunny> getAliveBunnyList() {
        LinkedList<Bunny> linkedList = new LinkedList<Bunny>();
        for (Bunny bunny : this.bunnies) {
            if (!bunny.isAlive()) continue;
            linkedList.add(bunny);
        }
        return linkedList;
    }

    public int getClimate() {
        return this.climate;
    }

    public void setClimate(int n) {
        if (this.climate == n) {
            return;
        }
        this.climate = n;
        this.notifyClimateChange();
    }

    public int getSelectionFactor() {
        return this.selectionFactor;
    }

    public void setSelectionFactor(int n) {
        if (this.selectionFactor == n) {
            return;
        }
        this.selectionFactor = n;
        if (this.selectionFactor == 2) {
            this.startFrenzy();
        } else {
            this.prematureEndFrenzy();
        }
        if (this.selectionFactor == 1) {
            // empty if block
        }
        this.notifySelectionFactorChange();
    }

    public boolean isFriendAdded() {
        return this.friendAdded;
    }

    public int getGenerationProgressPercent() {
        if (!this.friendAdded) {
            return 0;
        }
        return (int)(100.0 * (this.time - this.lastYearTick) / NaturalSelectionConstants.getSettings().getTicksPerYear());
    }

    public List<Shrub> getShrubs() {
        return this.shrubs;
    }

    public List<Tree> getTrees() {
        return this.trees;
    }

    public Landscape getLandscape() {
        return this.landscape;
    }

    @Override
    public void simulationTimeChanged(ClockEvent clockEvent) {
        double d = NaturalSelectionConstants.getSettings().getTicksPerYear();
        if (!this.isDuringFrenzy() && !this.isDuringFamine()) {
            this.time += 1.0;
            while (this.time - this.lastYearTick > d) {
                this.lastYearTick += d;
                this.nextGeneration();
            }
            while (this.time - this.lastEventTick > d) {
                this.lastEventTick += d;
                if (this.selectionFactor == 2) {
                    this.startFrenzy();
                }
                if (this.selectionFactor != 1) continue;
                this.startFamine();
            }
        }
        this.clock.notifyPhysicalListeners(clockEvent);
        if (!this.isDuringFrenzy() && !this.isDuringFamine()) {
            this.clock.notifyTimeListeners(clockEvent);
        }
    }

    private void notifyGenerationChange() {
        Event event = new Event(this, 0);
        event.setNewGeneration(this.generation);
        this.notifyListenersOfEvent(event);
    }

    private void notifyNewBunny(Bunny bunny) {
        Event event = new Event(this, 1);
        event.setNewBunny(bunny);
        this.notifyListenersOfEvent(event);
    }

    private void notifyClimateChange() {
        Event event = new Event(this, 2);
        event.setNewClimate(this.climate);
        this.notifyListenersOfEvent(event);
    }

    private void notifySelectionFactorChange() {
        Event event = new Event(this, 3);
        event.setNewSelectionFactor(this.selectionFactor);
        this.notifyListenersOfEvent(event);
    }

    private void notifyFrenzyStart(Frenzy frenzy) {
        Event event = new Event(this, 4);
        event.setFrenzy(frenzy);
        this.notifyListenersOfEvent(event);
    }

    private void notifyFamineStart(Famine famine) {
        Event event = new Event(this, 7);
        event.setFamine(famine);
        this.notifyListenersOfEvent(event);
    }

    private void notifyListenersOfEvent(Event event) {
        for (Listener listener : this.listeners) {
            listener.onEvent(event);
        }
    }

    private void notifyGameOver() {
        for (Listener listener : this.listeners) {
            listener.onEvent(new Event(this, 5));
        }
    }

    private void notifyBunniesTakeOver() {
        for (Listener listener : this.listeners) {
            listener.onEvent(new Event(this, 6));
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public class Event {
        private NaturalSelectionModel model;
        private int type;
        private int newGeneration;
        private int newSelectionFactor;
        private int newClimate;
        private Bunny newBunny;
        private Frenzy frenzy;
        private Famine famine;

        public Event(NaturalSelectionModel naturalSelectionModel2, int n) {
            this.model = naturalSelectionModel2;
            this.type = n;
        }

        public int getType() {
            return this.type;
        }

        public Bunny getNewBunny() {
            return this.newBunny;
        }

        public int getNewSelectionFactor() {
            return this.newSelectionFactor;
        }

        public int getNewClimate() {
            return this.newClimate;
        }

        public Frenzy getFrenzy() {
            return this.frenzy;
        }

        private void setNewBunny(Bunny bunny) {
            this.newBunny = bunny;
        }

        private void setNewGeneration(int n) {
            this.newGeneration = n;
        }

        private void setNewSelectionFactor(int n) {
            this.newSelectionFactor = n;
        }

        private void setNewClimate(int n) {
            this.newClimate = n;
        }

        private void setFrenzy(Frenzy frenzy) {
            this.frenzy = frenzy;
        }

        private void setFamine(Famine famine) {
            this.famine = famine;
        }
    }

    public static interface Listener {
        public void onEvent(Event var1);
    }
}

