/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import java.util.LinkedList;
import java.util.List;

public class NaturalSelectionClock
extends ConstantDtClock {
    private List<Listener> physicalToAdd = new LinkedList<Listener>();
    private List<Listener> timeToAdd = new LinkedList<Listener>();
    private List<Listener> physicalToRemove = new LinkedList<Listener>();
    private List<Listener> timeToRemove = new LinkedList<Listener>();
    private List<Listener> physicalListeners = new LinkedList<Listener>();
    private List<Listener> timeListeners = new LinkedList<Listener>();
    private boolean notifying = false;

    public NaturalSelectionClock(int n, double d) {
        super(1000 / n, d);
    }

    public void setDt(double d) {
        super.setDt(d);
        this.resetSimulationTime();
    }

    public void stepClockWhilePaused() {
        int n = 0;
        while ((double)n < NaturalSelectionConstants.getSettings().getTicksPerYear() / 4.0) {
            super.stepClockWhilePaused();
            ++n;
        }
    }

    public void addPhysicalListener(Listener listener) {
        if (this.notifying) {
            this.physicalToAdd.add(listener);
        } else {
            this.physicalListeners.add(listener);
        }
    }

    public void removePhysicalListener(Listener listener) {
        if (this.notifying) {
            this.physicalToRemove.add(listener);
        } else {
            this.physicalListeners.remove(listener);
        }
    }

    public void addTimeListener(Listener listener) {
        if (this.notifying) {
            this.timeToAdd.add(listener);
        } else {
            this.timeListeners.add(listener);
        }
    }

    public void notifyPhysicalListeners(ClockEvent clockEvent) {
        this.notifying = true;
        for (Listener listener : this.physicalListeners) {
            listener.onTick(clockEvent);
        }
        this.notifying = false;
        this.checkAfterNotify();
    }

    public void notifyTimeListeners(ClockEvent clockEvent) {
        this.notifying = true;
        for (Listener listener : this.timeListeners) {
            listener.onTick(clockEvent);
        }
        this.notifying = false;
        this.checkAfterNotify();
    }

    public void checkAfterNotify() {
        if (!this.physicalToAdd.isEmpty()) {
            for (Listener listener : this.physicalToAdd) {
                this.physicalListeners.add(listener);
            }
            this.physicalToAdd.clear();
        }
        if (!this.physicalToRemove.isEmpty()) {
            for (Listener listener : this.physicalToRemove) {
                this.physicalListeners.remove(listener);
            }
            this.physicalToRemove.clear();
        }
        if (!this.timeToAdd.isEmpty()) {
            for (Listener listener : this.timeToAdd) {
                this.timeListeners.add(listener);
            }
            this.timeToAdd.clear();
        }
        if (!this.timeToRemove.isEmpty()) {
            for (Listener listener : this.timeToRemove) {
                this.timeListeners.remove(listener);
            }
            this.timeToRemove.clear();
        }
    }

    public static interface Listener {
        public void onTick(ClockEvent var1);
    }
}

