/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.dialog;

import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.naturalselection.NaturalSelectionApplication;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.model.Bunny;
import edu.colorado.phet.naturalselection.view.PedigreeNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class PedigreeChartCanvas
extends PhetPCanvas {
    private PedigreeNode pedigreeNode;
    private double lastCenterPoint = 0.0;
    private Bunny lastDisplayedBunny = null;

    public PedigreeChartCanvas() {
        super.setWorldTransformStrategy(new PhetPCanvas.ConstantTransformStrategy(new AffineTransform()));
        this.setBackground(NaturalSelectionApplication.accessibleColor(NaturalSelectionConstants.COLOR_GENERATION_CHART));
        PNode pNode = new PNode();
        this.addWorldChild(pNode);
        this.pedigreeNode = new PedigreeNode();
        pNode.addChild(this.pedigreeNode);
        this.pedigreeNode.setOffset(new Point2D.Double(0.0, 5.0));
        this.setCenterPoint(0.0);
    }

    public void setCenterPoint(double d) {
        this.lastCenterPoint = d;
        this.pedigreeNode.setOffset(new Point2D.Double((double)(this.getWidth() / 2) - d, 5.0));
    }

    public void reset() {
        this.pedigreeNode.reset();
    }

    public void displayBunny(Bunny bunny) {
        this.pedigreeNode.displayBunny(bunny);
        this.lastDisplayedBunny = bunny;
    }

    public Bunny getLastDisplayedBunny() {
        return this.lastDisplayedBunny;
    }

    protected void updateLayout() {
        this.setCenterPoint(this.lastCenterPoint);
    }
}

