/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.developer;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.naturalselection.NaturalSelectionApplication;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.NaturalSelectionSettings;
import edu.colorado.phet.naturalselection.model.NaturalSelectionModel;
import edu.colorado.phet.naturalselection.module.NaturalSelectionModule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

public class DeveloperSettingsPanel
extends VerticalLayoutPanel {
    NaturalSelectionApplication app;
    private NaturalSelectionModule module;
    private NaturalSelectionModel model;
    private NaturalSelectionSettings nsSettings;
    private List<Setting> settings;
    private EasyGridBagLayout layout;
    private int col = 0;
    private int row = 0;

    public DeveloperSettingsPanel(NaturalSelectionApplication naturalSelectionApplication) {
        this.app = naturalSelectionApplication;
        JPanel jPanel = new JPanel();
        this.layout = new EasyGridBagLayout(jPanel);
        jPanel.setLayout(this.layout);
        this.settings = new LinkedList<Setting>();
        this.module = (NaturalSelectionModule)naturalSelectionApplication.getActiveModule();
        this.model = this.module.getMyModel();
        this.nsSettings = NaturalSelectionConstants.getSettings();
        this.setBorder(new TitledBorder("Settings"));
        this.addSetting(new Setting("clockFrameRate", new SpinnerNumberModel(this.nsSettings.getClockFrameRate(), 1, 50, 1), "Frames per second (controls animation and model)"){

            public void apply() {
                DeveloperSettingsPanel.this.model.getClock().setDelay(1000 / this.getInt());
            }
        });
        this.addSetting(new Setting("ticksPerYear", new SpinnerNumberModel(this.nsSettings.getTicksPerYear(), 30.0, 1000.0, 10.0), "Number of clock ticks per year. When smaller, generations will pass more quickly."){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setTicksPerYear(this.getDouble());
            }
        });
        this.addSetting(new Setting("selectionTick", new SpinnerNumberModel(this.nsSettings.getSelectionTick(), 0.0, 1000.0, 10.0), "The tick when the selection factor activates (wolves frenzy or bunnies starve). This must be in between 0 and ticksPerYear."){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setSelectionTick(this.getDouble());
            }
        });
        this.addSetting(new Setting("frenzyTicks", new SpinnerNumberModel(this.nsSettings.getFrenzyTicks(), 15.0, 750.0, 150.0), "Maximum number of clock ticks per frenzy"){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setFrenzyTicks(this.getDouble());
            }
        });
        this.addSetting(new Setting("famineTicks", new SpinnerNumberModel(this.nsSettings.getFamineTicks(), 15.0, 750.0, 150.0), "Maximum number of clock ticks per famine"){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setFamineTicks(this.getDouble());
            }
        });
        this.addSetting(new Setting("bunniesDieWhenThisOld", new SpinnerNumberModel(this.nsSettings.getBunniesDieWhenTheyAreThisOld(), 2, 12, 1), "As the title says, bunnies die when they get to this age."){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setBunniesDieWhenTheyAreThisOld(this.getInt());
            }
        });
        this.addSetting(new Setting("bunnyBetweenHopTime", new SpinnerNumberModel(this.nsSettings.getBunnyBetweenHopTime(), 0, 500, 5), "Number of ticks between hopping for each bunny."){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setBunnyBetweenHopTime(this.getInt());
            }
        });
        this.addSetting(new Setting("bunnyHopTime", new SpinnerNumberModel(this.nsSettings.getBunnyHopTime(), 2, 100, 2), "Number of ticks when the bunny is in mid-air. Suggested to change bunnyNormalHopDistance with this"){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setBunnyHopTime(this.getInt());
            }
        });
        this.addSetting(new Setting("bunnyHopHeight", new SpinnerNumberModel(this.nsSettings.getBunnyHopHeight(), 5, 300, 5), "The height at which bunnies hop to."){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setBunnyHopHeight(this.getInt());
            }
        });
        this.addSetting(new Setting("bunnyNormalHopDistance", new SpinnerNumberModel(this.nsSettings.getBunnyNormalHopDistance(), 2.0, 100.0, 2.0), "The distance each bunny hop goes"){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setBunnyNormalHopDistance(this.getDouble());
            }
        });
        this.addSetting(new Setting("bunnyHungerThreshold", new SpinnerNumberModel(this.nsSettings.getBunnyHungerThreshold(), 5, 1000, 5), "When bunnies (with long teeth now) get hungry, they go to the bush. The bush resets to 0. This should be less than bunnyMaxHunger"){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setBunnyHungerThreshold(this.getInt());
            }
        });
        this.addSetting(new Setting("bunnyMaxHunger", new SpinnerNumberModel(this.nsSettings.getBunnyMaxHunger(), 0, 1000, 5), "Maximum hunger. Currently the lower (closer) it is to bunnyHungerThreshold, the more bunnies at the start will go towards bushes."){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setBunnyMaxHunger(this.getInt());
            }
        });
        this.nextCol();
        this.addSetting(new Setting("wolfMaxStep", new SpinnerNumberModel(this.nsSettings.getWolfMaxStep(), 1.0, 20.0, 1.0), "The amount of distance a wolf can move in a tick."){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setWolfMaxStep(this.getDouble());
            }
        });
        this.addSetting(new Setting("wolfDoubleBackDistance", new SpinnerNumberModel(this.nsSettings.getWolfDoubleBackDistance(), 6.0, 120.0, 6.0), "If a wolf is too close to a bunny to eat it (the mouth is a certain distance from the middle of the wolf), the wolf has to move away to this distance before going back to eat the bunny."){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setWolfDoubleBackDistance(this.getDouble());
            }
        });
        this.addSetting(new Setting("wolfKillDistance", new SpinnerNumberModel(this.nsSettings.getWolfKillDistance(), 2.0, 40.0, 2.0), "The distance the wolf head can be from a bunny to kill it, when pointing the correct direction"){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setWolfKillDistance(this.getDouble());
            }
        });
        this.addSetting(new Setting("wolfBase", new SpinnerNumberModel(this.nsSettings.getWolfBase(), 0, 50, 1), "When a wolf frenzy starts, the number of wolves = wolfBase + population / bunniesPerWolves"){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setWolfBase(this.getInt());
            }
        });
        this.addSetting(new Setting("bunniesPerWolves", new SpinnerNumberModel(this.nsSettings.getBunniesPerWolves(), 1, 100, 1), "When a wolf frenzy starts, the number of wolves = wolfBase + population / bunniesPerWolves"){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setBunniesPerWolves(this.getInt());
            }
        });
        this.addSetting(new Setting("maxPopulation", new SpinnerNumberModel(this.nsSettings.getMaxPopulation(), 10, 10000, 10), "Maximum population of bunnies. If exceeded, the 'Bunnies take over the world' dialog will be shown, and the user will have to reset."){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setMaxPopulation(this.getInt());
            }
        });
        this.addSetting(new Setting("mutatingBunnyBase", new SpinnerNumberModel(this.nsSettings.getMutatingBunnyBase(), 1, 100, 1), "When possible, at least this many bunnies will mutate when the user desires."){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setMutatingBunnyBase(this.getInt());
            }
        });
        this.addSetting(new Setting("mutatingBunnyPerBunnies", new SpinnerNumberModel(this.nsSettings.getMutatingBunnyPerBunnies(), 1, 100, 1), "Total number of bunnies to mutate = mutatingBunnyBase + population / mutatingBunnyPerBunnies"){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setMutatingBunnyPerBunnies(this.getInt());
            }
        });
        this.nextCol();
        this.layout.addComponent(new JLabel("P_base(die) = (pop + offset) ^ exponent * scale "), this.row++, this.col);
        this.layout.addComponent(new JLabel("P_blend|regular(die) = min( maxKillFraction, P_base(die) * blendScale )"), this.row++, this.col);
        this.layout.addComponent(new JLabel("P_noBlend|longTeeth(die) = min( maxKillFraction, P_base(die) )"), this.row++, this.col);
        this.addSetting(new Setting("maxKillFraction", new SpinnerNumberModel(this.nsSettings.getMaxKillFraction(), 0.1, 1.0, 0.025)){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setMaxKillFraction(this.getDouble());
            }
        });
        this.addSetting(new Setting("wolfSelectionBunnyOffset", new SpinnerNumberModel(this.nsSettings.getWolfSelectionBunnyOffset(), -50.0, 50.0, 1.0)){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setWolfSelectionBunnyOffset(this.getDouble());
            }
        });
        this.addSetting(new Setting("wolfSelectionBunnyExponent", new SpinnerNumberModel(this.nsSettings.getWolfSelectionBunnyExponent(), 0.1, 1.0, 0.05)){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setWolfSelectionBunnyExponent(this.getDouble());
            }
        });
        this.addSetting(new Setting("wolfSelectionScale", new SpinnerNumberModel(this.nsSettings.getWolfSelectionScale(), 0.05, 1.0, 0.05)){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setWolfSelectionScale(this.getDouble());
            }
        });
        this.addSetting(new Setting("wolfSelectionBlendScale", new SpinnerNumberModel(this.nsSettings.getWolfSelectionBlendScale(), 0.1, 1.0, 0.1)){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setWolfSelectionBlendScale(this.getDouble());
            }
        });
        this.addSetting(new Setting("foodSelectionBunnyOffset", new SpinnerNumberModel(this.nsSettings.getFoodSelectionBunnyOffset(), -50.0, 50.0, 1.0)){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setFoodSelectionBunnyOffset(this.getDouble());
            }
        });
        this.addSetting(new Setting("foodSelectionBunnyExponent", new SpinnerNumberModel(this.nsSettings.getFoodSelectionBunnyExponent(), 0.1, 1.0, 0.05)){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setFoodSelectionBunnyExponent(this.getDouble());
            }
        });
        this.addSetting(new Setting("foodSelectionScale", new SpinnerNumberModel(this.nsSettings.getFoodSelectionScale(), 0.05, 1.0, 0.05)){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setFoodSelectionScale(this.getDouble());
            }
        });
        this.addSetting(new Setting("foodSelectionBlendScale", new SpinnerNumberModel(this.nsSettings.getFoodSelectionBlendScale(), 0.1, 1.0, 0.1)){

            public void apply() {
                DeveloperSettingsPanel.this.nsSettings.setFoodSelectionBlendScale(this.getDouble());
            }
        });
        this.add(jPanel);
        JButton jButton = new JButton("Reset with Changes");
        this.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Setting setting : DeveloperSettingsPanel.this.settings) {
                    setting.apply();
                }
                DeveloperSettingsPanel.this.module.reset();
            }
        });
    }

    public void nextCol() {
        ++this.col;
        this.row = 0;
    }

    public void addSetting(Setting setting) {
        this.layout.addComponent(setting, this.row++, this.col);
        this.settings.add(setting);
    }

    private abstract class Setting
    extends JPanel {
        private SpinnerModel model;
        private JSpinner spinner;

        protected Setting(String string, SpinnerModel spinnerModel) {
            this.model = spinnerModel;
            this.add(new JLabel(string));
            this.spinner = new JSpinner(spinnerModel);
            this.add(this.spinner);
        }

        protected Setting(String string, SpinnerModel spinnerModel, String string2) {
            this.model = spinnerModel;
            this.add(new JLabel(string));
            this.spinner = new JSpinner(spinnerModel);
            this.add(this.spinner);
            this.setToolTipText(string2);
        }

        public int getInt() {
            return this.getNumber().intValue();
        }

        public double getDouble() {
            return this.getNumber().doubleValue();
        }

        public Number getNumber() {
            return (Number)this.model.getValue();
        }

        public abstract void apply();
    }
}

