/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.developer;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.naturalselection.NaturalSelectionApplication;
import edu.colorado.phet.naturalselection.developer.DeveloperControlsDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;

public class DeveloperControlsMenuItem
extends JCheckBoxMenuItem {
    private NaturalSelectionApplication application;
    private JDialog developerControlsDialog;

    public DeveloperControlsMenuItem(NaturalSelectionApplication naturalSelectionApplication) {
        super("Developer controls...");
        this.application = naturalSelectionApplication;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeveloperControlsMenuItem.this.handleDeveloperControls();
            }
        });
    }

    private void handleDeveloperControls() {
        System.out.println("DeveloperControlsMenuItem.handleDeveloperControls");
        if (this.isSelected()) {
            PhetFrame phetFrame = PhetApplication.getInstance().getPhetFrame();
            this.developerControlsDialog = new DeveloperControlsDialog((Frame)phetFrame, this.application);
            this.developerControlsDialog.setVisible(true);
            this.developerControlsDialog.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    this.cleanup();
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.cleanup();
                }

                private void cleanup() {
                    DeveloperControlsMenuItem.this.setSelected(false);
                    DeveloperControlsMenuItem.this.developerControlsDialog = null;
                }
            });
        } else {
            this.developerControlsDialog.dispose();
        }
    }
}

